-- CK_ODS_CKODSPOLICY CK_ODS_保单业务数据
insert into CK_ODS.CK_ODS_KAFKA.CKODSPOLICY -- topic CKODSPOLICY
select
      s1.policyNo                             as policyNo                 -- 保单号
    , s1.businessNo                           as businessNo               -- 业务号
    , s1.businessOffice                       as businessOffice           -- 保单归属机构代码
    , s1.productCode                          as productCode              -- 险种代码
    , s1.netPremium                           as netPremium               -- 保费（不含税）
    , s1.premium                              as premium                  -- 保费（含税）
    , s1.taxFee                               as taxFee                   -- 增值税税额
    , s1.shortRateCoefficient                 as shortRateCoefficient     -- 短期费率
    , s1.shortRateWay                         as shortRateWay             -- 短期费率方式
    , s1.discountRate                         as discountRate             -- 车险费率交强险保费浮动比率
    , s1.amount                               as amount                   -- 保额
    , u1.customerName                         as appcustomerName          -- 投保人姓名
    , u1.identifyNumber                       as appidentifyNumber        -- 投保人统一社会信用代码
    , u1.identifyType                         as appidentifyType          -- 投保人证件类型
    , s1.plcPublicInsurant[1].customerName    as pubcustomerName           -- 被保人姓名
    , s1.plcPublicInsurant[1].identifyNumber  as pubidentifyNumber         -- 被保人统一社会信用代码
    , s1.plcPublicInsurant[1].identifyType    as pubidentifyType           -- 被保人证件类型
    , 's1.plcCarowners.customerName  '          as carcustomerName           -- 车主姓名
    , 's1.plcCarowners.identifyNumber'          as caridentifyNumber         -- 车主统一社会信用代码
    , 's1.plcCarowners.identifyType  '          as caridentifyType           -- 车主证件类型
    , s1.plcCar05.licensePlateNo              as licensePlateNo           -- 车牌号
    , s1.plcCar05.licenseType                 as licenseType              -- 车牌种类
    , s1.plcCar05.vehiclecode                 as vehiclecode              -- 车辆车型
    , s1.plcCar05.carKindCode                 as carKindCode              -- 车辆种类
    , s1.plcCar05.carUserNatureCode           as carUserNatureCode        -- 车辆使用性质
    , s1.plcCar05.energyTypesCode             as energyTypesCode          -- 能源种类
    , s1.plcCar05.tradeName                   as tradeName                -- 车辆制造厂
    , s1.plcCar05.seatcount                   as seatcount                -- 座位数
    , s1.plcCar05.exhaustscale                as exhaustscale             -- 排量
    , s1.plcCar05.purchaseprice               as purchaseprice            -- 新车购置价格
    , s1.plcCar05.vinNo                       as vinNo                    -- 标的车vin值
    , s1.plcCar05.passengersNumber            as passengersNumber         -- 核定载客人数
    , s1.plcCar05.brandName                   as brandName                -- 车辆品牌名称
    , s1.plcCar05.actualvalue                 as actualvalue              -- 车辆实际价值
    , s1.plcCar05.enrollDate                  as enrollDate               -- 车辆初次登记日期
    , s1.startTime                            as startTime                -- 起保日期
    , s1.endTime                              as endTime                  -- 起保日期
    , s1.conTerReasons                        as conTerReasons            -- 保单终止原因代码
    , s1.signDate                             as signDate                 -- 签单日期
    , s1.policyCreatDate                      as policyCreatDate          -- 保单生成时间
    , s1.plcSolution[1].PlcRation.traffAdjVal as traffAdjVal              -- 交通违法系数
	, DATE_FORMAT(LOCALTIMESTAMP,'yyyy-MM-dd HH:mm:ss')      as log_time  -- 加工平台处理数据时间

from ODS.ODS_KAFKA.POLICY s1
cross join unnest(s1.plcApplicant) as u1 (customerName,identifyNumber,identifyType)
where left( s1.productCode ,2) = '05'
;
