-- RZ_DM_QUANTILE ZB_DM_单位时间内访问时间排序


-- QUANTILE_AGENTID 单位时间内访问时间排序按应用统计
insert into RZ_DM.RZ_DM_KAFKA.QUANTILE_AGENTID
SELECT
    s1.`applicationname`                           as `applicationname`
    ,s1.`agentid`                                  as `agentid`
    ,s1.`time`                                     as `time`
    ,SPLIT_INDEX(s1.`quantile`,';',0)              as `quantile50`
    ,SPLIT_INDEX(s1.`quantile`,';',1)              as `quantile75`
    ,SPLIT_INDEX(s1.`quantile`,';',2)              as `quantile95`
    ,SPLIT_INDEX(s1.`quantile`,';',3)              as `quantile99`
    ,s1.`createtime`                               as `createtime`
from (
    select
        d1.`applicationName`                                                                 as `applicationname`
        ,d1.`agentId`                                                                        as `agentid`
        ,DATE_FORMAT(tumble_end(d1.row_time, interval '1' minute) ,'yyyy-MM-dd HH:mm:ss')     as `time`
        ,CastToTagIndexUDF(LISTAGG(d1.`elapsed`,';') )                                        as `quantile` -- 拼接
        ,cast(DateTimeToLongUDF(tumble_start(d1.row_time, interval '1' minute)) as varchar)    as `createtime`
    from RZ_ODS.RZ_ODS_KAFKA.RZDATA d1
    where
    UPPER(RIGHT(d1.`rpc`,3)) not in ('.JS')
    and UPPER(RIGHT(d1.`rpc`,4)) not in ('.JPG','.ICO','.CSS','.TTF','.PNG','.PNG','.JPG','.TXT','.MP4','.MP3','.PDF','.DWR')
    and UPPER(RIGHT(d1.`rpc`,5)) not in ('.JSON','.HTML','.LESS','.JPEG')
    and UPPER(RIGHT(d1.`rpc`,6)) not in ('.WOFF2')
    group by
         d1.`applicationName`
        ,d1.`agentId`
        ,tumble(d1.row_time, interval '1' minute)
) s1
;


-- QUANTILE_APP 单位时间内访问时间排序按集群统计
insert into RZ_DM.RZ_DM_KAFKA.QUANTILE_APP
SELECT
    s1.`applicationname`                           as `applicationname`
    ,s1.`time`                                     as `time`
    ,SPLIT_INDEX(s1.`quantile`,';',0)              as `quantile50`
    ,SPLIT_INDEX(s1.`quantile`,';',1)              as `quantile75`
    ,SPLIT_INDEX(s1.`quantile`,';',2)              as `quantile95`
    ,SPLIT_INDEX(s1.`quantile`,';',3)              as `quantile99`
    ,s1.`createtime`                               as `createtime`
from (
    select
        d1.`applicationName`                                                    as `applicationname`
        ,DATE_FORMAT(tumble_end(d1.row_time, interval '1' minute) ,'yyyy-MM-dd HH:mm:ss')     as `time`
        ,CastToTagIndexUDF(LISTAGG(d1.`elapsed`,';') )                                        as `quantile` -- 拼接
        ,cast(DateTimeToLongUDF(tumble_start(d1.row_time, interval '1' minute)) as varchar)    as `createtime`
    from RZ_ODS.RZ_ODS_KAFKA.RZDATA d1
    where
    UPPER(RIGHT(d1.`rpc`,3)) not in ('.JS')
    and UPPER(RIGHT(d1.`rpc`,4)) not in ('.JPG','.ICO','.CSS','.TTF','.PNG','.PNG','.JPG','.TXT','.MP4','.MP3','.PDF','.DWR')
    and UPPER(RIGHT(d1.`rpc`,5)) not in ('.JSON','.HTML','.LESS','.JPEG')
    and UPPER(RIGHT(d1.`rpc`,6)) not in ('.WOFF2')
    group by
         d1.`applicationName`
        ,tumble(d1.row_time, interval '1' minute)
) s1
;







