-- ZB_DM_CXCBDD ZB_DM_车险承保大单
-- bigcbd/日期
-- 核保或者核批时间在今天，按照保费或者未决赔款排序，按保单的保费取前10，车险riskcode 05开头，其他为非车，

-- 总公司
insert into ZB_DM.ZB_DM_REDIS.SET_VARCHAR
select
    CONCAT(
            'bigcbd/'
        ,s1.`uwConclueDate`
        )                      as `key`
     ,CastToJsonArrayUDF(
        listagg(concat(
                     'com'      ,':'  ,`com`      ,','
                    ,'comname'  ,':'  ,`comname`  ,','
                    ,'risk'     ,':'  ,`risk`     ,','
                    ,'riskname' ,':'  ,`riskname` ,','
                    ,'chnl'     ,':'  ,`chnl`     ,','
                    ,'chnlname' ,':'  ,`chnlname` ,','
                    ,'cost'     ,':'  ,`cost`     ,','
                    ,'no'       ,':'  ,`no`
                    ),';')
    )                      as `val`
from (
         select
             *
         from(
                 select
                      d1.`uwConclueDate`                      as `uwConclueDate`
                      ,d1.`LEVEL1COMCODE`                     as `com`
                      ,d1.`LEVEL1COMDESC`                     as `comname`
                      ,d1.`risk`                              as `risk`
                      ,d1.`riskname`                          as `riskname`
                      ,d1.`chnl`                              as `chnl`
                      ,d1.`chnlname`                          as `chnlname`
                      ,cast(d1.`cost` as varchar)             as `cost`
                      ,d1.`no`                                as `no`
                      ,ROW_NUMBER() OVER(PARTITION BY d1.`uwConclueDate` ORDER BY d1.`cost` DESC) as rownum
                 from (
                          select
                              a1.`uwConclueDate`                     as `uwConclueDate`
                               ,a1.`LEVEL1COMCODE`                     as `LEVEL1COMCODE`
                               ,a1.`LEVEL1COMDESC`                     as `LEVEL1COMDESC`
                               ,a1.`risk`                              as `risk`
                               ,a1.`riskname`                          as `riskname`
                               ,a1.`chnl`                              as `chnl`
                               ,a1.`chnlname`                          as `chnlname`
                               ,sum(cast(a1.`cost` as decimal(18,2)))  as `cost`
                               ,a1.`no`                                as `no`
                          from ZB_ODS.ZB_ODS_KAFKA.CBDATA a1
                          where a1.`COMNAME` is not null
                            and a1.`uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
                            and left(a1.risk,2) ='05'
                          group by
                              a1.`uwConclueDate`
                              ,a1.`LEVEL1COMCODE`
                              ,a1.`LEVEL1COMDESC`
                              ,a1.`risk`
                              ,a1.`riskname`
                              ,a1.`chnl`
                              ,a1.`chnlname`
                              ,a1.`no`
                      ) d1
             ) c1
         where c1.rownum <= 20
     ) s1
group by
    s1.`uwConclueDate`
;



-- 分公司
insert into ZB_DM.ZB_DM_REDIS.SET_VARCHAR
select
    CONCAT(
            'bigccitybd/'
        ,s1.`uwConclueDate`
        ,'/',s1.`group_com`
        )                      as `key`
     ,CastToJsonArrayUDF(
        listagg(concat(
                     'com'      ,':'  ,`com`      ,','
                    ,'comname'  ,':'  ,`comname`  ,','
                    ,'city'     ,':'  ,`city`     ,','
                    ,'cityname' ,':'  ,`cityname` ,','
                    ,'risk'     ,':'  ,`risk`     ,','
                    ,'riskname' ,':'  ,`riskname` ,','
                    ,'chnl'     ,':'  ,`chnl`     ,','
                    ,'chnlname' ,':'  ,`chnlname` ,','
                    ,'cost'     ,':'  , `cost`    ,','
                    ,'no'       ,':'  ,`no`
                    ),';')
    )                      as `val`
from (
         select
             *
         from (
                  select
                      d1.`uwConclueDate`                     as `uwConclueDate`
                       ,d1.`LEVEL1COMCODE`                     as `group_com`
                       ,d1.`LEVEL1COMCODE`                     as `com`
                       ,d1.`LEVEL1COMDESC`                     as `comname`
                       ,d1.`LEVEL2COMCODE`                     as `city`
                       ,d1.`LEVEL2COMDESC`                     as `cityname`
                       ,d1.`risk`                              as `risk`
                       ,d1.`riskname`                          as `riskname`
                       ,d1.`chnl`                              as `chnl`
                       ,d1.`chnlname`                          as `chnlname`
                       ,cast(d1.`cost` as varchar)             as `cost`
                       ,d1.`no`                                as `no`
                       ,ROW_NUMBER() OVER(PARTITION BY d1.`LEVEL1COMCODE`,d1.`uwConclueDate` ORDER BY d1.`cost` DESC) as rownum
                  from (
                           select
                                a1.`uwConclueDate`                     as `uwConclueDate`
                               ,a1.`LEVEL1COMCODE`                     as `LEVEL1COMCODE`
                               ,a1.`LEVEL1COMDESC`                     as `LEVEL1COMDESC`
                               ,a1.`LEVEL2COMCODE`                     as `LEVEL2COMCODE`
                               ,a1.`LEVEL2COMDESC`                     as `LEVEL2COMDESC`
                               ,a1.`risk`                              as `risk`
                               ,a1.`riskname`                          as `riskname`
                               ,a1.`chnl`                              as `chnl`
                               ,a1.`chnlname`                          as `chnlname`
                               ,sum(cast(a1.`cost` as decimal(18,2)))  as `cost`
                               ,a1.`no`                                as `no`
                           from ZB_ODS.ZB_ODS_KAFKA.CBDATA a1
                           where a1.`COMNAME` is not null
                             and a1.`uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
                             and left(a1.risk,2) ='05'
                           group by
                               a1.`uwConclueDate`
                               ,a1.`LEVEL1COMCODE`
                               ,a1.`LEVEL1COMDESC`
                               ,a1.`LEVEL2COMCODE`
                               ,a1.`LEVEL2COMDESC`
                               ,a1.`risk`
                               ,a1.`riskname`
                               ,a1.`chnl`
                               ,a1.`chnlname`
                               ,a1.`no`
                       ) d1
              ) c1
         where c1.rownum <= 20
     ) s1
group by
    s1.`uwConclueDate`
       ,s1.`group_com`
;


-- 中支
insert into ZB_DM.ZB_DM_REDIS.SET_VARCHAR
select
    CONCAT(
            'bigccountrybd/'
        ,s1.`uwConclueDate`
        ,'/',s1.`group_com`
        )                      as `key`
     ,CastToJsonArrayUDF(
        listagg(concat(
                        'com'         ,':'  ,`com`         ,','
                    ,'comname'     ,':'  ,`comname`     ,','
                    ,'city'        ,':'  ,`city`        ,','
                    ,'cityname'    ,':'  ,`cityname`    ,','
                    ,'country'     ,':'  ,`country`     ,','
                    ,'countryname' ,':'  ,`countryname` ,','
                    ,'risk'        ,':'  ,`risk`        ,','
                    ,'riskname'    ,':'  ,`riskname`    ,','
                    ,'chnl'        ,':'  ,`chnl`        ,','
                    ,'chnlname'    ,':'  ,`chnlname`    ,','
                    ,'cost'        ,':'  ,cast(`cost` as varchar) ,','
                    ,'no'          ,':'  ,`no`
                    ),';')
    )                         as `val`
from (
         select
             *
         from (
                  select
                      d1.`uwConclueDate`                     as `uwConclueDate`
                       ,d1.`LEVEL2COMCODE`                     as `group_com`
                       ,d1.`LEVEL1COMCODE`                     as `com`
                       ,d1.`LEVEL1COMDESC`                     as `comname`
                       ,d1.`LEVEL2COMCODE`                     as `city`
                       ,d1.`LEVEL2COMDESC`                     as `cityname`
                       ,d1.`LEVEL3COMCODE`                     as `country`
                       ,d1.`LEVEL3COMDESC`                     as `countryname`
                       ,d1.`risk`                              as `risk`
                       ,d1.`riskname`                          as `riskname`
                       ,d1.`chnl`                              as `chnl`
                       ,d1.`chnlname`                          as `chnlname`
                       ,cast(d1.`cost` as varchar)             as `cost`
                       ,d1.`no`                                as `no`
                       ,ROW_NUMBER() OVER(PARTITION BY d1.`LEVEL2COMCODE`,d1.`uwConclueDate` ORDER BY d1.`cost` DESC) as rownum
                  from (
                           select
                               a1.`uwConclueDate`                     as `uwConclueDate`
                                ,a1.`LEVEL1COMCODE`                     as `LEVEL1COMCODE`
                                ,a1.`LEVEL1COMDESC`                     as `LEVEL1COMDESC`
                                ,a1.`LEVEL2COMCODE`                     as `LEVEL2COMCODE`
                                ,a1.`LEVEL2COMDESC`                     as `LEVEL2COMDESC`
                                ,a1.`LEVEL3COMCODE`                     as `LEVEL3COMCODE`
                                ,a1.`LEVEL3COMDESC`                     as `LEVEL3COMDESC`
                                ,a1.`risk`                              as `risk`
                                ,a1.`riskname`                          as `riskname`
                                ,a1.`chnl`                              as `chnl`
                                ,a1.`chnlname`                          as `chnlname`
                                ,sum(cast(a1.`cost` as decimal(18,2)))  as `cost`
                                ,a1.`no`                                as `no`
                           from ZB_ODS.ZB_ODS_KAFKA.CBDATA a1
                           where a1.`COMNAME` is not null
                             and a1.`uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
                             and left(a1.risk,2) ='05'
                           group by
                               a1.`uwConclueDate`
                                   ,a1.`LEVEL1COMCODE`
                                   ,a1.`LEVEL1COMDESC`
                                   ,a1.`LEVEL2COMCODE`
                                   ,a1.`LEVEL2COMDESC`
                                   ,a1.`LEVEL3COMCODE`
                                   ,a1.`LEVEL3COMDESC`
                                   ,a1.`risk`
                                   ,a1.`riskname`
                                   ,a1.`chnl`
                                   ,a1.`chnlname`
                                   ,a1.`no`
                       ) d1
              ) c1
         where c1.rownum <= 20
     ) s1
group by
    s1.`uwConclueDate`
       ,s1.`group_com`
;