-- ZB_DM_NOCAR_HB  ZB_DM_承保非车险合并


-- 非车险去重
CREATE TEMPORARY VIEW VIEW_ZB_DM_NOCAR_HB AS
SELECT
    s1.`uwConclueDate`                      as `uwConclueDate`
     ,s1.`LEVEL1COMCODE`                     as `LEVEL1COMCODE`
     ,s1.`LEVEL1COMDESC`                     as `LEVEL1COMDESC`
     ,s1.`LEVEL2COMCODE`                     as `LEVEL2COMCODE`
     ,s1.`LEVEL2COMDESC`                     as `LEVEL2COMDESC`
     ,s1.`LEVEL3COMCODE`                     as `LEVEL3COMCODE`
     ,s1.`LEVEL3COMDESC`                     as `LEVEL3COMDESC`
     ,s1.`risk`                              as `risk`
     ,s1.`riskname`                          as `riskname`
     ,s1.`chnl`                              as `chnl`
     ,s1.`chnlname`                          as `chnlname`
     ,s1.`cost`                              as `cost`
     ,s1.`no`                                as `no`
from (
         select
             *
              ,ROW_NUMBER() OVER(PARTITION BY `no`,`COMCODE`,`cost` ORDER BY `uwConclueDate` DESC) as rownum
         from ZB_ODS.ZB_ODS_KAFKA.CBDATA
         where
             `COMNAME` is not null
           and `uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
     ) s1
where s1.rownum = 1
  and left(s1.risk,2) <> '05'
;

-- ZB_DM_QDBF_NOCAR/ZB_DM_非车险今日签单保费
-- key:allnocarqbbf/日期
-- 1、日期:核保日期或者核批完成日期(yyyyMMdd)
-- 2、非车险

--  总公司
insert into ZB_DM.ZB_DM_REDIS.SET_DECIMAL
select
    CONCAT(
            'allnocarqdbf/'
        ,s1.`uwConclueDate`
        )                                       as `key`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from (
         SELECT
             d1.`uwConclueDate`                    as `uwConclueDate`
              ,d1.`LEVEL1COMCODE`                    as `LEVEL1COMCODE`
              ,d1.`LEVEL2COMCODE`                    as `LEVEL2COMCODE`
              ,d1.`LEVEL3COMCODE`                    as `LEVEL3COMCODE`
              ,d1.`LEVEL4COMCODE`                    as `LEVEL4COMCODE`
              ,d1.`risk`                             as `risk`
              ,sum(cast(s1.`cost` as DECIMAL(18,2))) as `cost`
         from VIEW_ZB_DM_NOCAR_HB d1
         group by
             d1.`uwConclueDate`
             ,d1.`LEVEL1COMCODE`
             ,d1.`LEVEL2COMCODE`
             ,d1.`LEVEL3COMCODE`
             ,d1.`LEVEL4COMCODE`
             ,d1.`risk`
     ) s1
group by
    s1.`uwConclueDate`
;

-- 分公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'provnocarqdbf/'
        ,s1.`uwConclueDate`
        )                                       as `key`
     ,s1.`LEVEL1COMCODE`                     as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from (
         SELECT
             d1.`uwConclueDate`                    as `uwConclueDate`
              ,d1.`LEVEL1COMCODE`                    as `LEVEL1COMCODE`
              ,d1.`LEVEL2COMCODE`                    as `LEVEL2COMCODE`
              ,d1.`LEVEL3COMCODE`                    as `LEVEL3COMCODE`
              ,d1.`LEVEL4COMCODE`                    as `LEVEL4COMCODE`
              ,d1.`risk`                             as `risk`
              ,sum(cast(s1.`cost` as DECIMAL(18,2))) as `cost`
         from VIEW_ZB_DM_NOCAR_HB d1
         group by
             d1.`uwConclueDate`
             ,d1.`LEVEL1COMCODE`
             ,d1.`LEVEL2COMCODE`
             ,d1.`LEVEL3COMCODE`
             ,d1.`LEVEL4COMCODE`
             ,d1.`risk`
     ) s1
group by
    s1.`uwConclueDate`
    ,s1.`LEVEL1COMCODE`
;

-- 中支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'citynocarqdbf/'
        ,s1.`uwConclueDate`
        )                                    as `key`
     ,s1.`LEVEL2COMCODE`                     as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from (
         SELECT
             d1.`uwConclueDate`                    as `uwConclueDate`
              ,d1.`LEVEL1COMCODE`                    as `LEVEL1COMCODE`
              ,d1.`LEVEL2COMCODE`                    as `LEVEL2COMCODE`
              ,d1.`LEVEL3COMCODE`                    as `LEVEL3COMCODE`
              ,d1.`LEVEL4COMCODE`                    as `LEVEL4COMCODE`
              ,d1.`risk`                             as `risk`
              ,sum(cast(s1.`cost` as DECIMAL(18,2))) as `cost`
         from VIEW_ZB_DM_NOCAR_HB d1
         group by
             d1.`uwConclueDate`
             ,d1.`LEVEL1COMCODE`
             ,d1.`LEVEL2COMCODE`
             ,d1.`LEVEL3COMCODE`
             ,d1.`LEVEL4COMCODE`
             ,d1.`risk`
     ) s1
group by
    s1.`uwConclueDate`
    ,s1.`LEVEL2COMCODE`
;


-- 县支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'countynocarqdbf/'
        ,s1.`uwConclueDate`
        )                                    as `key`
     ,s1.`LEVEL3COMCODE`                     as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from (
         SELECT
             d1.`uwConclueDate`                    as `uwConclueDate`
              ,d1.`LEVEL1COMCODE`                    as `LEVEL1COMCODE`
              ,d1.`LEVEL2COMCODE`                    as `LEVEL2COMCODE`
              ,d1.`LEVEL3COMCODE`                    as `LEVEL3COMCODE`
              ,d1.`LEVEL4COMCODE`                    as `LEVEL4COMCODE`
              ,d1.`risk`                             as `risk`
              ,sum(cast(s1.`cost` as DECIMAL(18,2))) as `cost`
         from VIEW_ZB_DM_NOCAR_HB d1
         group by
             d1.`uwConclueDate`
             ,d1.`LEVEL1COMCODE`
             ,d1.`LEVEL2COMCODE`
             ,d1.`LEVEL3COMCODE`
             ,d1.`LEVEL4COMCODE`
             ,d1.`risk`
     ) s1
group by
    s1.`uwConclueDate`
    ,s1.`LEVEL3COMCODE`
;


-- 团队
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'teamnocarqdbf/'
        ,s1.`uwConclueDate`
        )                                as `key`
     ,s1.`LEVEL4COMCODE`                 as `hkey`
     ,cast(s1.`cost` as DECIMAL(18,2))   as `val`
from (
         SELECT
             d1.`uwConclueDate`                    as `uwConclueDate`
              ,d1.`LEVEL1COMCODE`                    as `LEVEL1COMCODE`
              ,d1.`LEVEL2COMCODE`                    as `LEVEL2COMCODE`
              ,d1.`LEVEL3COMCODE`                    as `LEVEL3COMCODE`
              ,d1.`LEVEL4COMCODE`                    as `LEVEL4COMCODE`
              ,d1.`risk`                             as `risk`
              ,sum(cast(s1.`cost` as DECIMAL(18,2))) as `cost`
         from VIEW_ZB_DM_NOCAR_HB d1
         group by
             d1.`uwConclueDate`
             ,d1.`LEVEL1COMCODE`
             ,d1.`LEVEL2COMCODE`
             ,d1.`LEVEL3COMCODE`
             ,d1.`LEVEL4COMCODE`
             ,d1.`risk`
     ) s1

;


-- 总公司
insert into ZB_DM.ZB_DM_REDIS.SET_VARCHAR
select
    CONCAT(
            'bigfcbd/'
        ,s1.`uwConclueDate`
        )                      as `key`
     ,CastToJsonArrayUDF(
        listagg(concat(
                        'com'      ,':'  ,`com`      ,','
                    ,'comname'  ,':'  ,`comname`  ,','
                    ,'risk'     ,':'  ,`risk`     ,','
                    ,'riskname' ,':'  ,`riskname` ,','
                    ,'chnl'     ,':'  ,`chnl`     ,','
                    ,'chnlname' ,':'  ,`chnlname` ,','
                    ,'cost'     ,':'  ,cast(`cost` as varchar)     ,','
                    ,'no'       ,':'  ,`no`
                    ),';')
    )                      as `val`
from (
         select
             *
         from(
                 select
                     d1.`uwConclueDate`                      as `uwConclueDate`
                      ,d1.`LEVEL1COMCODE`                     as `com`
                      ,d1.`LEVEL1COMDESC`                     as `comname`
                      ,d1.`risk`                              as `risk`
                      ,d1.`riskname`                          as `riskname`
                      ,d1.`chnl`                              as `chnl`
                      ,d1.`chnlname`                          as `chnlname`
                      ,d1.`cost`                              as `cost`
                      ,d1.`no`                                as `no`
                      ,ROW_NUMBER() OVER(PARTITION BY d1.`uwConclueDate` ORDER BY d1.`cost` DESC) as rownum
                 from VIEW_ZB_DM_NOCAR_HB d1
                 where LEFT(d1.`risk`,2) <> '05'
             ) c1
         where c1.rownum <= 20
     ) s1
group by
    s1.`uwConclueDate`
;



-- 分公司
insert into ZB_DM.ZB_DM_REDIS.SET_VARCHAR
select
    CONCAT(
            'bigfccitybd/'
        ,s1.`uwConclueDate`
        ,'/',s1.`group_com`
        )                      as `key`
     ,CastToJsonArrayUDF(
        listagg(concat(
                        'com'      ,':'  ,`com`      ,','
                    ,'comname'  ,':'  ,`comname`  ,','
                    ,'city'     ,':'  ,`city`     ,','
                    ,'cityname' ,':'  ,`cityname` ,','
                    ,'risk'     ,':'  ,`risk`     ,','
                    ,'riskname' ,':'  ,`riskname` ,','
                    ,'chnl'     ,':'  ,`chnl`     ,','
                    ,'chnlname' ,':'  ,`chnlname` ,','
                    ,'cost'     ,':'  ,cast(`cost` as varchar)     ,','
                    ,'no'       ,':'  ,`no`
                    ),';')
    )                      as `val`
from (
         select
             *
         from (
                  select
                      d1.`uwConclueDate`                     as `uwConclueDate`
                       ,d1.`LEVEL1COMCODE`                     as `group_com`
                       ,d1.`LEVEL1COMCODE`                     as `com`
                       ,d1.`LEVEL1COMDESC`                     as `comname`
                       ,d1.`LEVEL2COMCODE`                     as `city`
                       ,d1.`LEVEL2COMDESC`                     as `cityname`
                       ,d1.`risk`                              as `risk`
                       ,d1.`riskname`                          as `riskname`
                       ,d1.`chnl`                              as `chnl`
                       ,d1.`chnlname`                          as `chnlname`
                       ,d1.`cost`                              as `cost`
                       ,d1.`no`                                as `no`
                       ,ROW_NUMBER() OVER(PARTITION BY d1.`LEVEL1COMCODE`,d1.`uwConclueDate` ORDER BY d1.`cost` DESC) as rownum
                  from VIEW_ZB_DM_NOCAR_HB d1
                  where LEFT(d1.`risk`,2) <> '05'
              ) c1
         where c1.rownum <= 20
     ) s1
group by
    s1.`uwConclueDate`
       ,s1.`group_com`
;


-- 中支
insert into ZB_DM.ZB_DM_REDIS.SET_VARCHAR
select
    CONCAT(
            'bigfccountrybd/'
        ,s1.`uwConclueDate`
        ,'/',s1.`group_com`
        )                      as `key`
     ,CastToJsonArrayUDF(
        listagg(concat(
                        'com'         ,':'  ,`com`         ,','
                    ,'comname'     ,':'  ,`comname`     ,','
                    ,'city'        ,':'  ,`city`        ,','
                    ,'cityname'    ,':'  ,`cityname`    ,','
                    ,'country'     ,':'  ,`country`     ,','
                    ,'countryname' ,':'  ,`countryname` ,','
                    ,'risk'        ,':'  ,`risk`        ,','
                    ,'riskname'    ,':'  ,`riskname`    ,','
                    ,'chnl'        ,':'  ,`chnl`        ,','
                    ,'chnlname'    ,':'  ,`chnlname`    ,','
                    ,'cost'        ,':'  ,cast(`cost` as varchar)        ,','
                    ,'no'          ,':'  ,`no`
                    ),';')
    )                         as `val`
from (
         select
             *
         from (
                  select
                      d1.`uwConclueDate`                     as `uwConclueDate`
                       ,d1.`LEVEL2COMCODE`                     as `group_com`
                       ,d1.`LEVEL1COMCODE`                     as `com`
                       ,d1.`LEVEL1COMDESC`                     as `comname`
                       ,d1.`LEVEL2COMCODE`                     as `city`
                       ,d1.`LEVEL2COMDESC`                     as `cityname`
                       ,d1.`LEVEL3COMCODE`                     as `country`
                       ,d1.`LEVEL3COMDESC`                     as `countryname`
                       ,d1.`risk`                              as `risk`
                       ,d1.`riskname`                          as `riskname`
                       ,d1.`chnl`                              as `chnl`
                       ,d1.`chnlname`                          as `chnlname`
                       ,d1.`cost`                              as `cost`
                       ,d1.`no`                                as `no`
                       ,ROW_NUMBER() OVER(PARTITION BY d1.`LEVEL2COMCODE`,d1.`uwConclueDate` ORDER BY d1.`cost` DESC) as rownum
                  from VIEW_ZB_DM_NOCAR_HB d1
                  where LEFT(d1.`risk`,2) <> '05'
              ) c1
         where c1.rownum <= 20
     ) s1
group by
    s1.`uwConclueDate`
       ,s1.`group_com`
;