-- HSET_DECIMAL_CHECK HSET格式DECIMAL数值存储核对

insert into ZB_DM.ZB_CK_RESULT.ZB_CK
select
    case when s1.`key` is null then concat(s2.`key`,DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMddHHmmss'))
         else concat(s1.`key`,DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMddHHmmss')
         end                                      AS id
    ,s1.`key`                                     AS current_key
    ,s1.`hkey`                                    AS current_hkey
    ,s1.`val`                                     AS current_val
    ,s2.`key`                                     AS actual_key
    ,s2.`hkey`                                    AS actual_hkey
    ,s2.`val`                                     AS actual_val
    ,cast(cast (s1.`val` as decimal (18,2)) - cast (s2.`val` as decimal (18,2)) as varchar )  AS poorVal
    ,case when (cast (s1.`val` as decimal (18,2)) - cast (s2.`val` as decimal (18,2))) = 0 then '是'
          else '否'
          end                                      AS ifSign
from ZB_ODS.ZB_DM_REDIS.HSET_DECIMAL s1
full outer join ZB_ODS.ZB_DM_REDIS_PRD.HSET_DECIMAL s2 on s1.`key` = s2.`key`
where case when s1.`key` is null then SPLIT_INDEX(s2.`key`,'/',1) = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
           when s1.`key` is not null then SPLIT_INDEX(s1.`key`,'/',1) = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
           end
  AND case when s1.`key` is null then s2.`key` regexp'allxlbf/|chnlbf/|alldayywlybf/|allmonthywlybf/|allquarterywlybf/|allywlybf/|xxzdaybf/|xxzmonthbf/|' ||
                                                     'xxzquarterbf/|xxzyearbf/|allyjxlbf/|chnlyjbf/|allwjxlbf/|chnlwjbf/|provqdbf/|provcarqdbf/|provnocarqdbf/|' ||
        'provqbbf/|provmonthqbbf/|provdayqdbf/|provquarterqdbf/|provxlbf/|chnlbf/|provdayywlybf/|provdayywlybf/|provquarterywlybf/|provywlybf/|provxxzbf/|' ||
        'provxxzdaybf/|provxxzmonthbf/|provxxzquarterbf/|provxxzyearbf/|provyjpk/|provyjxlbf/|chnlyjbf/|provwjpk/|provwjxlbf/|chnlwjbf/|cityqdbf/|citycarqdbf/|citynocarqdbf/|' ||
        'cityqbbf/|citymonthqbbf/|citydayqdbf/|cityquarterqdbf/|cityxlbf/|citychnlbf/|citydayywlybf/|citymonthywlybf/|cityquarterywlybf/|cityywlybf/|cityxxzbf/|' ||
        'cityxxzdaybf/|cityxxzmonthbf/|cityxxzquarterbf/|cityxxzyearbf/|cityyjpk/|cityyjxlbf/|citychnlyjbf/|citywjpk/|citywjxlbf/|citychnlwjbf/|countryqdbf/|' ||
        'countycarqdbf/|countynocarqdbf/|countryqbbf/|countrymonthqbbf/|countrydayqdbf/|countyquarterqdbf/|countryxlbf/|countrychnlbf/|countrydayywlybf/|' ||
        'countrymonthywlybf/|countryquarterywlybf/|countryywlybf/|countryxxzbf/|countryxxzdaybf/|countryxxzmonthbf/|countryxxzquarterbf/|countryxxzyearbf/|countyyjpk/|' ||
        'countyyjxlbf/|countychnlyjbf/|countywjpk/|countywjxlbf/|countychnlwjbf/|teamqdbf/|teamcarqdbf/|teamnocarqdbf/|teamqbbf/|teammonthqbbf/|teamdayqdbf/|' ||
        'teamquarterqdbf/|teamxlbf/|teamchnlbf/|teamdayywlybf/|teammonthywlybf/|teamquarterywlybf/|teamywlybf/|teamxxzbf/|teamxxzdaybf/|teamxxzmonthbf/|teamxxzquarterbf/' ||
        'teamxxzyearbf/|teamyjpk/|teamyjxlbf/|teamchnlyjbf/|teamwjpk/|teamwjxlbf/|teamchnlwjbf/'
        
           else s1.`key` regexp'allxlbf/|chnlbf/|alldayywlybf/|allmonthywlybf/|allquarterywlybf/|allywlybf/|xxzdaybf/|xxzmonthbf/|' ||
                                                     'xxzquarterbf/|xxzyearbf/|allyjxlbf/|chnlyjbf/|allwjxlbf/|chnlwjbf/|provqdbf/|provcarqdbf/|provnocarqdbf/|' ||
        'provqbbf/|provmonthqbbf/|provdayqdbf/|provquarterqdbf/|provxlbf/|chnlbf/|provdayywlybf/|provdayywlybf/|provquarterywlybf/|provywlybf/|provxxzbf/|' ||
        'provxxzdaybf/|provxxzmonthbf/|provxxzquarterbf/|provxxzyearbf/|provyjpk/|provyjxlbf/|chnlyjbf/|provwjpk/|provwjxlbf/|chnlwjbf/|cityqdbf/|citycarqdbf/|citynocarqdbf/|' ||
        'cityqbbf/|citymonthqbbf/|citydayqdbf/|cityquarterqdbf/|cityxlbf/|citychnlbf/|citydayywlybf/|citymonthywlybf/|cityquarterywlybf/|cityywlybf/|cityxxzbf/|' ||
        'cityxxzdaybf/|cityxxzmonthbf/|cityxxzquarterbf/|cityxxzyearbf/|cityyjpk/|cityyjxlbf/|citychnlyjbf/|citywjpk/|citywjxlbf/|citychnlwjbf/|countryqdbf/|' ||
        'countycarqdbf/|countynocarqdbf/|countryqbbf/|countrymonthqbbf/|countrydayqdbf/|countyquarterqdbf/|countryxlbf/|countrychnlbf/|countrydayywlybf/|' ||
        'countrymonthywlybf/|countryquarterywlybf/|countryywlybf/|countryxxzbf/|countryxxzdaybf/|countryxxzmonthbf/|countryxxzquarterbf/|countryxxzyearbf/|countyyjpk/|' ||
        'countyyjxlbf/|countychnlyjbf/|countywjpk/|countywjxlbf/|countychnlwjbf/|teamqdbf/|teamcarqdbf/|teamnocarqdbf/|teamqbbf/|teammonthqbbf/|teamdayqdbf/|' ||
        'teamquarterqdbf/|teamxlbf/|teamchnlbf/|teamdayywlybf/|teammonthywlybf/|teamquarterywlybf/|teamywlybf/|teamxxzbf/|teamxxzdaybf/|teamxxzmonthbf/|teamxxzquarterbf/' ||
        'teamxxzyearbf/|teamyjpk/|teamyjxlbf/|teamchnlyjbf/|teamwjpk/|teamwjxlbf/|teamchnlwjbf/'
           end
;
    