-- ZB_ODS_LPDATA ZB_ODS_指标加工理赔业务数据

insert into ZB_ODS.ZB_ODS_KAFKA.LPDATA
select
     s1.businessOffice               as `COMCODE`                --
    ,t1.COMNAME                      as `COMNAME`                --
    ,t1.LEVEL1COMCODE                as `LEVEL1COMCODE`          --
    ,t1.LEVEL2COMCODE                as `LEVEL2COMCODE`          --
    ,t1.LEVEL3COMCODE                as `LEVEL3COMCODE`          --
    ,t1.LEVEL4COMCODE                as `LEVEL4COMCODE`          --
    ,t1.LEVEL5COMCODE                as `LEVEL5COMCODE`          --
    ,t1.LEVEL1COMDESC                as `LEVEL1COMDESC`          --
    ,t1.LEVEL2COMDESC                as `LEVEL2COMDESC`          --
    ,t1.LEVEL3COMDESC                as `LEVEL3COMDESC`          --
    ,t1.LEVEL4COMDESC                as `LEVEL4COMDESC`          --
    ,t1.LEVEL5COMDESC                as `LEVEL5COMDESC`          --
    ,s1.productCode                  as `risk`                   -- 险种代码
    ,t3.RISKNAME                     as `riskname`               --
    ,t3.CLASSCODE                    as `classcode`              -- 险类代码
    ,t3.CLASSNAME                    as `classname`              --
    ,s1.businessNatureCode           as `businessNatureCode`     -- 业务来源
    ,t4.CODEDESC                     as `businessNatureName`     --
    ,s1.businessChannelCode          as `chnl`                   -- 业务渠道
    ,t2.NEWCHNLTYPEDESC              as `chnlname`               --
    ,s1.cladate                      as `cladate`                -- 立案日期
    ,s1.setdate                      as `setdate`                -- 结案日期/估损调整日期
    ,s1.settledamount                as `settledamount`          -- 已决赔款金额/估损提转差
    ,s1.lossamout                    as `lossamout`              -- 估损金额
    ,s1.flag                         as `flag`                   -- 类型
    ,s1.claimno                      as `claimno`                -- 赔案号
    ,s1.`no`                         as `no`                     -- 保单号
 	,DATE_FORMAT(LOCALTIMESTAMP,'yyyy-MM-dd HH:mm:ss')                    as log_time

from (
    select
         businessOffice                                        as businessOffice       -- 机构
        ,productCode                                           as productCode          -- 险种
        ,businessNatureCode                                    as businessNatureCode   -- 业务来源
        ,businessChannelCode                                   as businessChannelCode  -- 渠道
        ,left(replace(cladate,'-',''),6)                       as cladate              -- 立案日期
        ,replace(setdate,'-','')                               as setdate              -- 结案日期
        ,settledamount                                         as settledamount        -- 已决赔款金额
        ,lossamout                                             as lossamout            -- 估损金额
        ,'yj'                                                  as flag                 -- 类型
        ,claimno                                               as claimno              -- 赔案号
        ,`no`                                                  as `no`                 -- 保单号
        ,proctime                                              as proctime

    from ZB_ODS.ZB_SOURCE_KAFKA_YJPK.YJPK  -- 保单业务数据

    union all
    select
         businessOffice                                        as businessOffice       -- 机构
        ,productCode                                           as productCode          -- 险种
        ,businessNatureCode                                    as businessNatureCode   -- 业务来源
        ,businessChannelCode                                   as businessChannelCode  -- 渠道
        ,left(replace(cladate,'-',''),6)                       as cladate              -- 立案日期
        ,replace(setdate,'-','')                               as setdate              -- 估损调整日期
        ,settledamount                                         as settledamount        -- 估损提转差
        ,lossamout                                             as lossamout            -- 估损金额
        ,flag                                                  as flag                 -- 类型
        ,claimno                                               as claimno              -- 赔案号
        ,`no`                                                  as `no`                 -- 保单号
        ,proctime                                              as proctime
    from ZB_ODS.ZB_SOURCE_KAFKA_WJPK.WJPK  -- 批单业务数据

) s1
left join ZB_ODS.ZB_ODS_MYSQL.CD_COM_ALL for system_time as of s1.proctime as t1 on s1.businessOffice = t1.COMCODE
left join ZB_ODS.ZB_ODS_MYSQL.CD_NEWCHNLTYPE for system_time as of s1.proctime as t2 on s1.businessChannelCode = t2.NEWCHNLTYPE
left join ZB_ODS.ZB_ODS_MYSQL.CD_REALTIME_RISK for system_time as of s1.proctime as t3 on s1.productCode = t3.RISKCODE
left join ZB_ODS.ZB_ODS_MYSQL.CD_BUSINESSNATURE for system_time as of s1.proctime as t4 on s1.businessNatureCode = t4.CODE
;



