package com.chinalife.contract.insurance.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.concurrent.ConcurrentHashMap;

import org.activiti.engine.impl.util.CollectionUtil;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.chinalife.actual.domain.BusinessEntity;
import com.chinalife.actual.domain.PositionPath;
import com.chinalife.actual.domain.PositionPath.StartPosition;
import com.chinalife.actual.domain.Role;
import com.chinalife.contract.agreement.entity.PlcAgrConfigurationEO;
import com.chinalife.contract.agreement.entity.PlcAvaProductEO;
import com.chinalife.contract.agreement.vo.PlcAgrAcceptVO;
import com.chinalife.contract.agreement.vo.PlcAgrClauseItemVO;
import com.chinalife.contract.agreement.vo.PlcAgrClauseVO;
import com.chinalife.contract.agreement.vo.PlcAgrPurchaseVO;
import com.chinalife.contract.agreement.vo.PlcAvaProductVO;
import com.chinalife.contract.autoplatform.utils.CarPlatBeanUtils;
import com.chinalife.contract.constant.ContractSpecActualConstant;
import com.chinalife.contract.constant.ContractSpecActualConstant.ReservedRoleKind;
import com.chinalife.contract.constant.enums.CoinLinkCodeEnum;
import com.chinalife.contract.constant.enums.CoinsIdentityEnum;
import com.chinalife.contract.entity.PlcAddressEO;
import com.chinalife.contract.entity.PlcAgentplanEO;
import com.chinalife.contract.entity.PlcBasicEO;
import com.chinalife.contract.entity.PlcCarChargerEO;
import com.chinalife.contract.entity.PlcCarEO;
import com.chinalife.contract.entity.PlcCarShipTaxEO;
import com.chinalife.contract.entity.PlcClauseEO;
import com.chinalife.contract.entity.PlcClauseitemEO;
import com.chinalife.contract.entity.PlcCoinscommissionEO;
import com.chinalife.contract.entity.PlcCoinsinformationEO;
import com.chinalife.contract.entity.PlcCommissiondetailEO;
import com.chinalife.contract.entity.PlcCostEO;
import com.chinalife.contract.entity.PlcCustomerEO;
import com.chinalife.contract.entity.PlcDeviceEO;
import com.chinalife.contract.entity.PlcEngageEO;
import com.chinalife.contract.entity.PlcFeeEO;
import com.chinalife.contract.entity.PlcGrpcustomerEO;
import com.chinalife.contract.entity.PlcHouseEO;
import com.chinalife.contract.entity.PlcInsurantEO;
import com.chinalife.contract.entity.PlcMainEO;
import com.chinalife.contract.entity.PlcMgCommissiondetailEO;
import com.chinalife.contract.entity.PlcPackageEO;
import com.chinalife.contract.entity.PlcPlanEO;
import com.chinalife.contract.entity.PlcPrintInformationEO;
import com.chinalife.contract.entity.PlcRationEO;
import com.chinalife.contract.entity.PlcRegulationEO;
import com.chinalife.contract.entity.PlcSalesEO;
import com.chinalife.contract.entity.PlcSolutionEO;
import com.chinalife.contract.entity.PlcTisPlanEO;
import com.chinalife.contract.entity.PlpCoinsinformationEO;
import com.chinalife.contract.entity.PlpCommissiondetailEO;
import com.chinalife.contract.entity.PlpCostEO;
import com.chinalife.contract.entity.PlpEndorseEO;
import com.chinalife.contract.entity.PlpEndorsecommissionEO;
import com.chinalife.contract.entity.PlpEndorsecontentEO;
import com.chinalife.contract.entity.PlpMgCommissiondetailEO;
import com.chinalife.contract.entity.PlpPayeeaccountEO;
import com.chinalife.contract.entity.PlpRegulationEO;
import com.chinalife.contract.print.vo.BusinessEntityVO;
import com.chinalife.contract.task.vo.MultiProductInfoVo;
import com.chinalife.integration.common.utils.CommonUtil;
import com.sun.star.uno.RuntimeException;

/**
 * @Description: 合约中实体对象
 * @author: lshi041
 * @date: Oct 6, 2017 9:48:16 PM
 */
public class ContractBusinessEntity implements Serializable {

    /**
     * @Fields serialVersionUID : 序列号
     */
    private static final long serialVersionUID = -4328265983159066732L;

    private static Logger logger = LoggerFactory.getLogger(ContractBusinessEntity.class);

    /**
     * 投保单｜报价单｜批单｜保单等实体
     */
    protected BusinessEntity bs;
    /**
     * 条款的汇总信息
     */
    private ClauseItemInfo clauseItemInfo;

    /**
     * 条款的Role集合，key:clauseCode，value:条款信息
     */
    private ConcurrentHashMap<String, String> clauseMap;

    /**
     * 房屋标的的Role集合key:标的序号，value:房屋标的信息
     */
    private ConcurrentHashMap<String, PlcHouseEO> houseMap;
    /**
     * 联共保的Role集合
     */
    private Map<String, Role> plcCoinsRoleMap;

    /**
     * 缴费集合的Role集合
     */
    private Map<String, Role> plcPlanRoleMap;

    /**
     * @Fields plcApplicantRoleMap : 投保人的Role集合
     */
    private Map<String, Role> plcApplicantRoleMap;

    /**
     * @Fields plcInsurantRoleMap : 被保人的Role的集合
     */
    private Map<String, Role> plcInsurantRoleMap;

    /**
     * @param bs
     *            投保单｜报价单｜批单｜保单等实体
     * @description 构造方法
     */
    public ContractBusinessEntity(BusinessEntity bs) {
        this.bs = bs;
    }

    /**
     * @return clauseMap
     * @description 获取条款的Role的集合Map
     */
    public ConcurrentHashMap<String, String> getClauseMap() {
        this.getPlcClauses();
        return clauseMap;
    }

    /**
     * @return houseMap
     * @description 获取房屋集合的Map
     */
    public ConcurrentHashMap<String, PlcHouseEO> getHouseMap() {
        this.getplcHouseList();
        return houseMap;
    }

    public void setHouseMap(ConcurrentHashMap<String, PlcHouseEO> houseMap) {
        this.houseMap = houseMap;
    }

    public void setClauseMap(ConcurrentHashMap<String, String> clauseMap) {
        this.clauseMap = clauseMap;
    }

    /**
     * @return plcMain
     * @Description: 获取投保单|保单摘要信息
     */
    public PlcMainEO getPlcMain() {

        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
       
        if (role.getFixedActual() instanceof PlcMainEO) {
            return (PlcMainEO) role.getFixedActual();
        } else {
            try {
                PlcMainEO targetOb = (PlcMainEO)role.getFixedActual();
                //BeanUtils.populate(targetOb, role.getProperty());
                return targetOb;
            } catch (Exception ex) {
                logger.error("format property to PlcMainEO error", ex);
                return null;
            }
        }
    }

    /**
     * @return targetOb
     * @Description: 获取投保单|保单|批单基本信息
     */
    public PlcBasicEO getPlcBasic() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        Object plcBasicRoleOb = role.find(StartPosition.R.name() + ":"
                + ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcBasic.name()));
        if (plcBasicRoleOb == null) {
            return null;
        }
        Role plcBasicRole = null;
        if (plcBasicRoleOb instanceof Role) {
            plcBasicRole = (Role) plcBasicRoleOb;
        } else if (plcBasicRoleOb instanceof Collection) {
            List<Role> list = (List<Role>) plcBasicRoleOb;
            plcBasicRole = list.get(0);
        }
        try {
            PlcBasicEO targetOb = (PlcBasicEO) plcBasicRole.getFixedActual();

            // BeanUtils.populate(targetOb, plcBasicRole.getProperty());
            return targetOb;
        } catch (Exception ex) {
            logger.error("format property to PlcBasicEO error");
            return null;
        }
    }

    /**
     * 需要产生的协议核保任务
     *
     * @return List<MultiProductInfoVo>
     */

    public List<MultiProductInfoVo> getProtocolCheckTask() {
        List<MultiProductInfoVo> protocolCheckTaskList = new ArrayList<>();
        // NOAT-17797 协议多联保方案提核生成从联方核保任务时，按照structureId进行去重，对每一方从联归属部门只生成一条核保任务
        List<String> structureIdList = new ArrayList<>();
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        try {
            String businessNo = bs.getStringProperty(ContractSpecActualConstant.ReservedActualProperty.businessNo.name());
            //NOAT-17797 控制协议批改时只生成主联方的核保任务（从联方无需核保，和保单批改保持一致）
            String businessType = bs.getStringProperty(ContractSpecActualConstant.ReservedActualProperty.businessType.name());
            String mainActualId = String.valueOf(bs.getId());
            String specId = bs.getStringProperty(ContractSpecActualConstant.ReservedActualProperty.specId.name());
            String agrProductCode = bs.getStringProperty(ContractSpecActualConstant.ReservedActualProperty.productCode.name());
            String agreementTypeCode = bs.getStringProperty(ContractSpecActualConstant.ReservedActualProperty.agreementTypeCode.name());
            // 可售产品
            Object prductObj = role.find(StartPosition.R.name() + ":" + ReservedRoleKind.plcAvaProduct.name());
            boolean agrFlag = true;
            if ("01".equals(agreementTypeCode)) {
                agrFlag = false;
            }
            // 货运险协议
            boolean cargoFlag = false;
            if ("09".equals(agreementTypeCode)) {
                cargoFlag = true;
            }
            if (prductObj instanceof Collection) {
                List<Role> prductObjRoleList = (List<Role>) prductObj;
                if (cargoFlag) {
                    MultiProductInfoVo protocolCheckTask = new MultiProductInfoVo(mainActualId);
                    protocolCheckTask.setProductCode(agrProductCode);
                    protocolCheckTask.setSpecId(specId);
                    protocolCheckTask.setBusinessNo(businessNo);
                    protocolCheckTask.setMainActualId(mainActualId);
                    protocolCheckTaskList.add(protocolCheckTask);
                } else {
                    for (Role prductObjRole : prductObjRoleList) {
                        // Map<String, Object> prductObjRoleMap =
                        // prductObjRole.getProperty();
                        PlcAvaProductEO plcAvaProduct = (PlcAvaProductEO) prductObjRole.getFixedActual();
                        // BeanUtils.copyProperties(plcAvaProduct,
                        // prductObjRoleMap);
                        if (prductObjRoleList.size() > 1) {
                            MultiProductInfoVo protocolCheckTask = new MultiProductInfoVo(
                                    plcAvaProduct.getActualId().toString());
                            if (!agrFlag) {
                                protocolCheckTask.setProductCode(agrProductCode);
                            } else {
                                protocolCheckTask.setProductCode(plcAvaProduct.getProductCode());
                            }
                            protocolCheckTask.setSpecId(specId);
                            protocolCheckTask.setBusinessNo(businessNo);
                            protocolCheckTask.setMainActualId(mainActualId);
                            protocolCheckTaskList.add(protocolCheckTask);
                        } else {
                            MultiProductInfoVo protocolCheckTask = new MultiProductInfoVo(mainActualId);
                            if (!agrFlag) {
                                protocolCheckTask.setProductCode(agrProductCode);
                            } else {
                                protocolCheckTask.setProductCode(plcAvaProduct.getProductCode());
                            }
                            protocolCheckTask.setSpecId(specId);
                            protocolCheckTask.setBusinessNo(businessNo);
                            protocolCheckTask.setMainActualId(mainActualId);
                            protocolCheckTaskList.add(protocolCheckTask);
                        }
                        
                        // 遍历产品下承保方案
                        Object plcAgrAcceptObj = prductObjRole
                                .find(StartPosition.R.name() + ":" + ReservedRoleKind.plcAgrAccept.name());
                        if (plcAgrAcceptObj instanceof Collection) {
                            List<Role> plcAgrAcceptRoleList = (List<Role>) plcAgrAcceptObj;
                            for (Role plcAgrAcceptRole : plcAgrAcceptRoleList) {
                                // 联共保信息对象
                                List<Role> plcCoinsList = (List<Role>) plcAgrAcceptRole
                                        .find(StartPosition.R.name() + ":" + ReservedRoleKind.plcCoins.name());
                                if (!plcCoinsList.isEmpty()) {
                                    Role plcCoinsObjRole = plcCoinsList.get(0);
                                    // 联保基本信息
                                    Object plcLinkBasicInformatObj = plcCoinsObjRole.find(
                                            StartPosition.R.name() + ":" + ReservedRoleKind.plcLinkBasicInformat.name());
                                    
                                    // 获取联共保销售信息
                                    List<Role> coinsSalesList = (List<Role>) plcCoinsObjRole
                                            .find(PositionPath.StartPosition.R.name() + ":"
                                                    + ContractSpecActualConstant.ReservedRoleKind.plcCoinsSale.name());
                                    
                                    if (plcLinkBasicInformatObj instanceof Collection) {
                                        List<Role> plcLinkBasicInformatObjRoleList = (List<Role>) plcLinkBasicInformatObj;
                                        for (Role plcLinkBasicInformatObjRole : plcLinkBasicInformatObjRoleList) {
                                            // Map<String, Object>
                                            // plcLinkBasicInformatObjRoleMap =
                                            // plcLinkBasicInformatObjRole
                                            // .getProperty();
                                            PlcCoinsinformationEO plcCoinBasicInformat = (PlcCoinsinformationEO) plcLinkBasicInformatObjRole
                                                    .getFixedActual();
                                            // BeanUtils.copyProperties(plcCoinBasicInformat,
                                            // plcLinkBasicInformatObjRoleMap);
                                            
                                            String coinInfoLinkNo = plcCoinBasicInformat.getLinkNo();
                                            
                                            String structureId = "";
                                            A: for (Role saleRole : coinsSalesList) {
                                                String saleLinkNo = String.valueOf(saleRole.getValue(
                                                        ContractSpecActualConstant.ReservedCoinsProperty.linkNo.name()));
                                                if (saleLinkNo.equals(coinInfoLinkNo)) {
                                                    structureId = String.valueOf(saleRole.getValue(ContractSpecActualConstant.ReservedActualProperty.businessOffice
                                                            .name()));
                                                    break A;
                                                }
                                            }
                                            
                                            if (CoinsIdentityEnum.InnerOther.getValue().equals(plcCoinBasicInformat.getCoinsIdentity())
                                                    && !structureIdList.contains(structureId) && !"77".equals(businessType)) {
                                                structureIdList.add(structureId);
                                                
                                                MultiProductInfoVo protocolCheckTaskLink = new MultiProductInfoVo(
                                                        plcCoinBasicInformat.getActualId().toString());
                                                if (!agrFlag) {
                                                    protocolCheckTaskLink.setProductCode(agrProductCode);
                                                } else {
                                                    protocolCheckTaskLink.setProductCode(plcAvaProduct.getProductCode());
                                                }
                                                
                                                protocolCheckTaskLink.setSpecId(specId);// 继续取plcMain的specId
                                                protocolCheckTaskLink.setIsCoin(CoinLinkCodeEnum.FollowCoinLink.getValue()); // 设置为从联保
                                                protocolCheckTaskLink.setStructureId(structureId); // structureId
                                                protocolCheckTaskLink.setBusinessNo(businessNo);
                                                protocolCheckTaskLink.setMainActualId(mainActualId);
                                                protocolCheckTaskList.add(protocolCheckTaskLink);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception ex) {
            logger.error("format property  error");
            throw new RuntimeException(ex);
        }
        return protocolCheckTaskList;
    }

    /**
     * @return customerEntityList
     * @Description: 查询投保人集合
     */
    @SuppressWarnings({ "unchecked" })
    public List<ProductCustomerEntity> getPlcApplicants() {

        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<ProductCustomerEntity> customerEntityList = new ArrayList<ProductCustomerEntity>();
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcApplicant.name());

        List<Role> roleList = role.findChildren(Role.class, path);
        try {
            for (Role r : roleList) {
                // Map<String, Object> propertyMap = r.getProperty();
                ProductCustomerEntity productCustomerEntity = new ProductCustomerEntity(); // 这个不是EO不能 取getFixedActual
                PlcInsurantEO eo = (PlcInsurantEO) r.getFixedActual(); //getFixedActual 获取的是role挂的静态表
                BeanUtils.copyProperties(productCustomerEntity, eo);
                CarPlatBeanUtils.copy(eo, productCustomerEntity);
                Object plcCustomerOb = convertChildRoleToObject(r, ReservedRoleKind.plcCustomer.name(),
                        PlcCustomerEO.class);
                productCustomerEntity
                        .setPlcCustomerEO(plcCustomerOb == null ? null : (PlcCustomerEO) plcCustomerOb);
                Object plcGrpcustomerOb = convertChildRoleToObject(r, ReservedRoleKind.plcGrpCustomer.name(),
                        PlcGrpcustomerEO.class);
                productCustomerEntity
                        .setPlcGrpcustomerEO(plcGrpcustomerOb == null ? null : (PlcGrpcustomerEO) plcGrpcustomerOb);
                customerEntityList.add(productCustomerEntity);
            }
        } catch (Exception ex) {
            logger.error("format property to PlcApplicant error", ex);
        }
        return customerEntityList;
    }

    /**
     * @return customerEntityList
     * @Description: 获取投保人|被保人等信息
     */
    @SuppressWarnings({ "unchecked" })
    public List<ProductCustomerEntity> getPlcInsurants() {

        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<ProductCustomerEntity> customerEntityList = new ArrayList<ProductCustomerEntity>();
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcInsurant.name());
        List<Role> roleList = role.findChildren(Role.class, path);
        try {
            for (Role r : roleList) {
                // Map<String, Object> propertyMap = r.getProperty();
                PlcInsurantEO eo = (PlcInsurantEO) r.getFixedActual();
                ProductCustomerEntity productCustomerEntity = new ProductCustomerEntity();
                // BeanUtils.copyProperties(productCustomerEntity, eo);
                CarPlatBeanUtils.copy(eo, productCustomerEntity);
                Object plcCustomerOb = convertChildRoleToObject(r, ReservedRoleKind.plcCustomer.name(),
                        PlcCustomerEO.class);
                productCustomerEntity
                        .setPlcCustomerEO(plcCustomerOb == null ? null : (PlcCustomerEO) plcCustomerOb);
                Object plcGrpcustomerOb = convertChildRoleToObject(r, ReservedRoleKind.plcGrpCustomer.name(),
                        PlcGrpcustomerEO.class);
                productCustomerEntity
                        .setPlcGrpcustomerEO(plcGrpcustomerOb == null ? null : (PlcGrpcustomerEO) plcGrpcustomerOb);
                customerEntityList.add(productCustomerEntity);
            }
        } catch (Exception ex) {
            logger.error("format property to PlcInsurants error", ex);
        }
        return customerEntityList;
    }

    /**
     * @return customerEntityList
     * @Description: 获取收益人
     */
    @SuppressWarnings({ "unchecked" })
    public List<ProductCustomerEntity> getPlcBeneficiarys() {

        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<ProductCustomerEntity> customerEntityList = new ArrayList<ProductCustomerEntity>();
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcBeneficiary.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        try {
            if (o instanceof Role) {
                Role actRole = (Role) o;
                ProductCustomerEntity productCustomerEntity = new ProductCustomerEntity();
                BeanUtils.copyProperties(productCustomerEntity, actRole.getFixedActual());
                Object plcCustomerOb = convertChildRoleToObject(actRole, ReservedRoleKind.plcCustomer.name(),
                        PlcCustomerEO.class);
                productCustomerEntity.setPlcCustomerEO(plcCustomerOb == null ? null : (PlcCustomerEO) plcCustomerOb);
                Object plcGrpcustomerOb = convertChildRoleToObject(actRole, ReservedRoleKind.plcGrpCustomer.name(),
                        PlcGrpcustomerEO.class);
                productCustomerEntity
                        .setPlcGrpcustomerEO(plcGrpcustomerOb == null ? null : (PlcGrpcustomerEO) plcGrpcustomerOb);
                customerEntityList.add(productCustomerEntity);

            } else if (o instanceof Collection) {

                List<Role> roleList = (List<Role>) o;

                for (Role r : roleList) {
                    ProductCustomerEntity productCustomerEntity = new ProductCustomerEntity();
                    BeanUtils.copyProperties(productCustomerEntity, r.getFixedActual());
                    Object plcCustomerOb = convertChildRoleToObject(r, ReservedRoleKind.plcCustomer.name(),
                            PlcCustomerEO.class);
                    productCustomerEntity
                            .setPlcCustomerEO(plcCustomerOb == null ? null : (PlcCustomerEO) plcCustomerOb);
                    Object plcGrpcustomerOb = convertChildRoleToObject(r, ReservedRoleKind.plcGrpCustomer.name(),
                            PlcGrpcustomerEO.class);
                    productCustomerEntity
                            .setPlcGrpcustomerEO(plcGrpcustomerOb == null ? null : (PlcGrpcustomerEO) plcGrpcustomerOb);
                    customerEntityList.add(productCustomerEntity);
                }

            }
        } catch (Exception ex) {
            logger.error("format property to plcBeneficiary error", ex);
        }
        return customerEntityList;
    }

    /**
     * @return plcClauseList
     * @Description: 获取条款信息
     */
    @SuppressWarnings({ "unchecked" })
    public List<PlcClauseEO> getPlcClauses() {
        ConcurrentHashMap<String, String> clauseMap = new ConcurrentHashMap<>();
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlcClauseEO> plcClauseList = new ArrayList<PlcClauseEO>();
        /// 报价方案
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcSolution.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return plcClauseList;
        }
        if (o instanceof Collection) {
            List<Role> roleList = (List<Role>) o;
            for (Role r : roleList) {
                // 承保方案
                Object plcPackageOb = r.find("R:" + ReservedRoleKind.plcPackage.name());

                if (plcPackageOb == null) {
                    continue;
                }
                if (plcPackageOb instanceof Collection) {

                    List<Role> plcPackageRoleList = (List<Role>) plcPackageOb;

                    for (Role plcPackageRole : plcPackageRoleList) {

                        Object mainClauseOb = plcPackageRole.find("R:" + ReservedRoleKind.plcMainClause.name());
                        if (mainClauseOb == null) {
                            continue;
                        }
                        if (mainClauseOb instanceof Collection) {

                            List<Role> mainRoleList = (List<Role>) mainClauseOb;

                            try {
                                for (Role mainRole : mainRoleList) {
                                    // 主条款
                                    PlcClauseEO mainOb = (PlcClauseEO) mainRole.getFixedActual();
                                    // BeanUtils.populate(mainOb,
                                    // mainRole.getProperty());
                                    plcClauseList.add(mainOb);
                                    clauseMap.put(mainOb.getClauseCode(), mainOb.getClauseName());
                                    Object plcAccessoryClauseOb = mainRole
                                            .find("R:" + ReservedRoleKind.plcAccessoryClause.name());
                                    // 附加条款
                                    if (plcAccessoryClauseOb == null) {
                                        continue;
                                    }
                                    if (plcAccessoryClauseOb instanceof Collection) {
                                        List<Role> plcAccessoryClauseRoleList = (List<Role>) plcAccessoryClauseOb;

                                        for (Role accessoryRole : plcAccessoryClauseRoleList) {
                                            if (accessoryRole == null) {
                                                continue;
                                            }
                                            PlcClauseEO accessoryOb = (PlcClauseEO) accessoryRole.getFixedActual();
                                            // BeanUtils.populate(accessoryOb,
                                            // accessoryRole.getProperty());
                                            plcClauseList.add(accessoryOb);
                                            clauseMap.put(accessoryOb.getClauseCode(), accessoryOb.getClauseName());
                                        }

                                    }

                                }
                            } catch (Exception ex) {
                                logger.error("format property to PlcClauseEO error", ex);
                            }

                        }
                    }
                }
            }
        }
        this.setClauseMap(clauseMap);
        return plcClauseList;
    }

    /**
     * @return plcClauseList
     * @Description: 获取条款信息
     */
    @SuppressWarnings({ "unchecked" })
    public List<PlcClauseEO> getPlcClausesFinal() {
        ConcurrentHashMap<String, String> clauseMap = new ConcurrentHashMap<>();
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }

        List<PlcClauseEO> plcClauseList = new ArrayList<PlcClauseEO>();
        /// 报价方案
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcSolution.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return plcClauseList;
        }
        if (o instanceof Collection) {
            List<Role> roleList = (List<Role>) o;
            for (Role r : roleList) {
                if ("1".equals(r.getValue("selectFlag"))) {
                    // 承保方案
                    Object plcPackageOb = r.find("R:" + ReservedRoleKind.plcPackage.name());

                    if (plcPackageOb == null) {
                        continue;
                    }
                    if (plcPackageOb instanceof Collection) {

                        List<Role> plcPackageRoleList = (List<Role>) plcPackageOb;

                        for (Role plcPackageRole : plcPackageRoleList) {

                            Object mainClauseOb = plcPackageRole.find("R:" + ReservedRoleKind.plcMainClause.name());
                            if (mainClauseOb == null) {
                                continue;
                            }
                            if (mainClauseOb instanceof Collection) {

                                List<Role> mainRoleList = (List<Role>) mainClauseOb;

                                try {
                                    for (Role mainRole : mainRoleList) {
                                        // 主条款
                                        PlcClauseEO mainOb = (PlcClauseEO) mainRole.getFixedActual();
                                        // BeanUtils.populate(mainOb,
                                        // mainRole.getProperty());
                                        plcClauseList.add(mainOb);
                                        clauseMap.put(mainOb.getClauseCode(), mainOb.getClauseName());
                                        Object plcAccessoryClauseOb = mainRole
                                                .find("R:" + ReservedRoleKind.plcAccessoryClause.name());
                                        // 附加条款
                                        if (plcAccessoryClauseOb == null) {
                                            continue;
                                        }
                                        if (plcAccessoryClauseOb instanceof Collection) {
                                            List<Role> plcAccessoryClauseRoleList = (List<Role>) plcAccessoryClauseOb;

                                            for (Role accessoryRole : plcAccessoryClauseRoleList) {
                                                if (accessoryRole == null) {
                                                    continue;
                                                }
                                                PlcClauseEO accessoryOb = (PlcClauseEO) accessoryRole.getFixedActual();
                                                // BeanUtils.populate(accessoryOb,
                                                // accessoryRole.getProperty());
                                                plcClauseList.add(accessoryOb);
                                                clauseMap.put(accessoryOb.getClauseCode(), accessoryOb.getClauseName());
                                            }

                                        }

                                    }
                                } catch (Exception ex) {
                                    logger.error("format property to PlcClauseEO error", ex);
                                }

                            }
                        }
                    }
                }
            }
        }
        this.setClauseMap(clauseMap);
        return plcClauseList;
    }

    /**
     * @param role
     *            角色
     * @param kind
     *            角色的Kind
     * @param kindClass
     *            目标转化类
     * @return object
     * @description 将role转化成实体对象
     */
    @SuppressWarnings({ "unchecked", "rawtypes" })
    private Object convertChildRoleToObject(Role role, String kind, Class kindClass) {

        Map<String, Object> childRoleMap = role.findChildrenRole();

        Object targetOb = null;
        try {
            for (Entry<String, Object> entry : childRoleMap.entrySet()) {
                if (entry.getKey().equalsIgnoreCase(kind)) {

                    Object v = entry.getValue();

                    if (v instanceof Role) {
                        Role actRole = (Role) v;
                        // Map<String, Object> propertyMap =
                        // actRole.getProperty();
                        targetOb = actRole.getFixedActual();
                        // BeanUtils.copyProperties(targetOb, propertyMap);
                    } else if (v instanceof Collection) {
                        List<Role> roleList = (List<Role>) v;
                        List<Object> objectList = new ArrayList<Object>();
                        for (Role r : roleList) {
                            // Map<String, Object> propertyMap =
                            // r.getProperty();
                            Object ob = r.getFixedActual();
                            // BeanUtils.copyProperties(ob, propertyMap);
                            objectList.add(ob);
                        }
                        targetOb = objectList;
                    }
                }
            }
        } catch (Exception ex) {
            logger.error("format property to convertChildRoleToObject error", ex);
        }
        return targetOb;
    }

    /**
     * @return plcClauseItemList
     * @Description: 获取条责标信息
     */
    @SuppressWarnings({ "unchecked" })
    public List<PlcClauseitemEO> getPlcClauseItem() {

        Role role = bs.getRole();
        if (role == null) {
            return null;
        }

        ClauseItemInfo clauseItemInfo = new ClauseItemInfo();

        List<PlcClauseitemEO> plcClauseItemList = new ArrayList<PlcClauseitemEO>();
        /// 报价方案
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcSolution.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return plcClauseItemList;
        }
        if (!(o instanceof Collection)) {
            return plcClauseItemList;
        }

        List<Role> roleList = (List<Role>) o;
        for (Role r : roleList) {
            // 承保方案
            Object plcPackageOb = r.find("R:" + ReservedRoleKind.plcPackage.name());

            if (plcPackageOb == null) {
                continue;
            }
            if (!(plcPackageOb instanceof Collection)) {
                continue;
            }

            List<Role> plcPackageRoleList = (List<Role>) plcPackageOb;

            for (Role plcPackageRole : plcPackageRoleList) {

                Object mainClauseOb = plcPackageRole.find("R:" + ReservedRoleKind.plcMainClause.name());
                if (mainClauseOb == null) {
                    continue;
                }
                if (!(mainClauseOb instanceof Collection)) {
                    continue;
                }
                List<Role> mainRoleList = (List<Role>) mainClauseOb;

                try {
                    for (Role mainRole : mainRoleList) {
                        // 查询主条款下的条责标
                        clauseItemInfo.setClauseNumber(clauseItemInfo.getClauseNumber() + 1);// 条款数目+1
                        clauseItemInfo.setMainClauseNumber(clauseItemInfo.getMainClauseNumber() + 1);// 主条款数目+！
                        Object plcClauseItemObRole = mainRole.find("R:" + ReservedRoleKind.plcClauseItem.name());
                        if (plcClauseItemObRole != null && plcClauseItemObRole instanceof Collection) {

                            List<Role> clauseItemList = (List<Role>) plcClauseItemObRole;
                            for (Role clauseItemRole : clauseItemList) {
                                PlcClauseitemEO clauseItem = (PlcClauseitemEO) clauseItemRole.getFixedActual();
                                // BeanUtils.populate(clauseItem,
                                // clauseItemRole.getProperty());
                                if (null != clauseItem.getClauseCode()) {
                                    plcClauseItemList.add(clauseItem);
                                    BigDecimal oriCurAmount = clauseItem.getOriCurAmount() == null ? BigDecimal.ZERO
                                            : clauseItem.getOriCurAmount();
                                    BigDecimal oriCurPremium = clauseItem.getOriCurPremium() == null ? BigDecimal.ZERO
                                            : clauseItem.getOriCurPremium();
                                    BigDecimal unitAmount = clauseItem.getUnitAmount() == null ? BigDecimal.ZERO
                                            : clauseItem.getUnitAmount();
                                    clauseItemInfo
                                            .setMainTotalAmount(clauseItemInfo.getMainTotalAmount().add(oriCurAmount));// 主条款保额
                                    clauseItemInfo
                                            .setMainTotalPremium(clauseItemInfo.getMainTotalPremium().add(oriCurPremium));// 主条款保费
                                    clauseItemInfo.setMainTotalUnitAmount(
                                            clauseItemInfo.getMainTotalUnitAmount().add(unitAmount));// 主险总每人保额
                                }
                            }
                        }

                        Object plcAccessoryClauseOb = mainRole.find("R:" + ReservedRoleKind.plcAccessoryClause.name());
                        // 附加条款
                        if (plcAccessoryClauseOb == null || (!(plcAccessoryClauseOb instanceof Collection))) {
                            continue;
                        }
                        List<Role> plcAccessoryClauseRoleList = (List<Role>) plcAccessoryClauseOb;
                        for (Role accessoryRole : plcAccessoryClauseRoleList) {
                            if (accessoryRole == null) {
                                continue;
                            }
                            clauseItemInfo.setClauseNumber(clauseItemInfo.getClauseNumber() + 1);// 条款数目+1
                            clauseItemInfo.setAccessoryClauseNumber(clauseItemInfo.getAccessoryClauseNumber() + 1);// 附加条款+1
                            Object itemObRole = accessoryRole.find("R:" + ReservedRoleKind.plcClauseItem.name());
                            if (itemObRole != null && itemObRole instanceof Collection) {
                                List<Role> clauseItemList = (List<Role>) itemObRole;
                                for (Role clauseItemRole : clauseItemList) {
                                    PlcClauseitemEO clauseItem = (PlcClauseitemEO) clauseItemRole.getFixedActual();
                                    // BeanUtils.populate(clauseItem,
                                    // clauseItemRole.getProperty());
                                    if (null != clauseItem.getClauseCode()) {
                                        plcClauseItemList.add(clauseItem);
                                        BigDecimal unitAmount = clauseItem.getUnitAmount() == null ? BigDecimal.ZERO
                                                : clauseItem.getUnitAmount();
                                        // 家财险，工程险新需求，附加险原币的保额，保费要求为空，送收付需要处理为0
                                        BigDecimal oriCurAmount = BigDecimal.ZERO;
                                        if (clauseItem.getOriCurAmount() != null) {
                                            oriCurAmount = clauseItem.getOriCurAmount();
                                        }
                                        clauseItemInfo.setAccessoryTotalAmount(
                                                clauseItemInfo.getAccessoryTotalAmount().add(oriCurAmount));// 附加条款保额
                                        clauseItemInfo.setAccessoryTotalUnitAmount(
                                                clauseItemInfo.getAccessoryTotalUnitAmount().add(unitAmount));// 附加险总每人保额
                                    }
                                }
                            }
                        }
                    }
                } catch (Exception ex) {
                    logger.error("format property to PlcClauseitemEO error", ex);
                }

            }
        }
        this.setClauseItemInfo(clauseItemInfo);
        return plcClauseItemList;
    }

    /**
     * @return plcClauseItemList
     * @Description: 多方案情况下，获取选中方案信息，用于预确认和确认
     */
    @SuppressWarnings({ "unchecked" })
    public List<PlcClauseitemEO> getPlcClauseItemFinal() {

        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
 
        ClauseItemInfo clauseItemInfo = new ClauseItemInfo();

        List<PlcClauseitemEO> plcClauseItemList = new ArrayList<PlcClauseitemEO>();
        /// 报价方案
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcSolution.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return plcClauseItemList;
        }
        if (!(o instanceof Collection)) {
            return plcClauseItemList;
        }

        List<Role> roleList = (List<Role>) o;
        for (Role r : roleList) {
            if ("1".equals(r.getValue("selectFlag"))) {
                // 承保方案
                Object plcPackageOb = r.find("R:" + ReservedRoleKind.plcPackage.name());

                if (plcPackageOb == null) {
                    continue;
                }
                if (!(plcPackageOb instanceof Collection)) {
                    continue;
                }

                List<Role> plcPackageRoleList = (List<Role>) plcPackageOb;

                for (Role plcPackageRole : plcPackageRoleList) {

                    Object mainClauseOb = plcPackageRole.find("R:" + ReservedRoleKind.plcMainClause.name());
                    if (mainClauseOb == null) {
                        continue;
                    }
                    if (!(mainClauseOb instanceof Collection)) {
                        continue;
                    }
                    List<Role> mainRoleList = (List<Role>) mainClauseOb;

                    try {
                        for (Role mainRole : mainRoleList) {
                            // 查询主条款下的条责标
                            clauseItemInfo.setClauseNumber(clauseItemInfo.getClauseNumber() + 1);// 条款数目+1
                            clauseItemInfo.setMainClauseNumber(clauseItemInfo.getMainClauseNumber() + 1);// 主条款数目+！
                            Object plcClauseItemObRole = mainRole.find("R:" + ReservedRoleKind.plcClauseItem.name());
                            if (plcClauseItemObRole != null && plcClauseItemObRole instanceof Collection) {

                                List<Role> clauseItemList = (List<Role>) plcClauseItemObRole;
                                for (Role clauseItemRole : clauseItemList) {
                                    PlcClauseitemEO clauseItem = (PlcClauseitemEO) clauseItemRole.getFixedActual();
                                    // BeanUtils.populate(clauseItem,
                                    // clauseItemRole.getProperty());
                                    plcClauseItemList.add(clauseItem);
                                    BigDecimal oriCurAmount = clauseItem.getOriCurAmount() == null ? BigDecimal.ZERO
                                            : clauseItem.getOriCurAmount();
                                    BigDecimal oriCurPremium = clauseItem.getOriCurPremium() == null ? BigDecimal.ZERO
                                            : clauseItem.getOriCurPremium();
                                    BigDecimal unitAmount = clauseItem.getUnitAmount() == null ? BigDecimal.ZERO
                                            : clauseItem.getUnitAmount();
                                    clauseItemInfo
                                            .setMainTotalAmount(clauseItemInfo.getMainTotalAmount().add(oriCurAmount));// 主条款保额
                                    clauseItemInfo.setMainTotalPremium(
                                            clauseItemInfo.getMainTotalPremium().add(oriCurPremium));// 主条款保费
                                    clauseItemInfo.setMainTotalUnitAmount(
                                            clauseItemInfo.getMainTotalUnitAmount().add(unitAmount));// 主险总每人保额
                                }
                            }

                            Object plcAccessoryClauseOb = mainRole
                                    .find("R:" + ReservedRoleKind.plcAccessoryClause.name());
                            // 附加条款
                            if (plcAccessoryClauseOb == null || (!(plcAccessoryClauseOb instanceof Collection))) {
                                continue;
                            }
                            List<Role> plcAccessoryClauseRoleList = (List<Role>) plcAccessoryClauseOb;
                            for (Role accessoryRole : plcAccessoryClauseRoleList) {
                                if (accessoryRole == null) {
                                    continue;
                                }
                                clauseItemInfo.setClauseNumber(clauseItemInfo.getClauseNumber() + 1);// 条款数目+1
                                clauseItemInfo.setAccessoryClauseNumber(clauseItemInfo.getAccessoryClauseNumber() + 1);// 附加条款+1
                                Object itemObRole = accessoryRole.find("R:" + ReservedRoleKind.plcClauseItem.name());
                                if (itemObRole != null && itemObRole instanceof Collection) {
                                    List<Role> clauseItemList = (List<Role>) itemObRole;
                                    for (Role clauseItemRole : clauseItemList) {
                                        PlcClauseitemEO clauseItem = (PlcClauseitemEO) clauseItemRole.getFixedActual();
                                        // BeanUtils.populate(clauseItem,
                                        // clauseItemRole.getProperty());
                                        plcClauseItemList.add(clauseItem);
                                        BigDecimal unitAmount = clauseItem.getUnitAmount() == null ? BigDecimal.ZERO
                                                : clauseItem.getUnitAmount();
                                        if (clauseItem.getOriCurAmount() != null) {
                                            clauseItemInfo.setAccessoryTotalAmount(clauseItemInfo.getAccessoryTotalAmount()
                                                    .add(clauseItem.getOriCurAmount()));// 附加条款保额
                                        }
                                        clauseItemInfo.setAccessoryTotalUnitAmount(
                                                clauseItemInfo.getAccessoryTotalUnitAmount().add(unitAmount));// 附加险总每人保额
                                    }
                                }
                            }
                        }
                    } catch (Exception ex) {
                        ex.printStackTrace();
                        logger.error("format property to PlcClauseitemEO error", ex);
                    }

                }

            }
        }
        this.setClauseItemInfo(clauseItemInfo);
        return plcClauseItemList;
    }

    /**
     * @return plcRegulationList
     * @Description: 获取补贴信息
     */
    @SuppressWarnings({ "unchecked" })
    public List<PlcRegulationEO> getPlcRegulation() {

        Role role = bs.getRole();
        if (role == null) {
            return null;
        }

        List<PlcRegulationEO> plcRegulationList = new ArrayList<PlcRegulationEO>();
        /// 报价方案
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcSolution.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return plcRegulationList;
        }
        if (!(o instanceof Collection)) {
            return plcRegulationList;
        }

        List<Role> roleList = (List<Role>) o;
        for (Role r : roleList) {
            // 承保方案
            Object plcPackageOb = r.find("R:" + ReservedRoleKind.plcPackage.name());

            if (plcPackageOb == null) {
                continue;
            }
            if (!(plcPackageOb instanceof Collection)) {
                continue;
            }

            List<Role> plcPackageRoleList = (List<Role>) plcPackageOb;

            for (Role plcPackageRole : plcPackageRoleList) {

                Object mainClauseOb = plcPackageRole.find("R:" + ReservedRoleKind.plcMainClause.name());
                if (mainClauseOb == null) {
                    continue;
                }
                if (!(mainClauseOb instanceof Collection)) {
                    continue;
                }
                List<Role> mainRoleList = (List<Role>) mainClauseOb;

                try {
                    for (Role mainRole : mainRoleList) {
                        // 查询主条款下的条责标
                        Object plcRegulationObRole = mainRole.find("R:" + ReservedRoleKind.plcRegulation.name());
                        if (plcRegulationObRole != null && plcRegulationObRole instanceof Collection) {
                            List<Role> regulationList = (List<Role>) plcRegulationObRole;
                            for (Role regulationRole : regulationList) {
                                PlcRegulationEO regulation = (PlcRegulationEO) regulationRole.getFixedActual();
                                // BeanUtils.populate(regulation,
                                // regulationRole.getProperty());
                                plcRegulationList.add(regulation);
                            }
                        }

                        Object plcAccessoryClauseOb = mainRole.find("R:" + ReservedRoleKind.plcAccessoryClause.name());
                        // 附加条款
                        if (plcAccessoryClauseOb == null || (!(plcAccessoryClauseOb instanceof Collection))) {
                            continue;
                        }
                        List<Role> plcAccessoryClauseRoleList = (List<Role>) plcAccessoryClauseOb;
                        for (Role accessoryRole : plcAccessoryClauseRoleList) {
                            if (accessoryRole == null) {
                                continue;
                            }
                            Object regulationObRole = accessoryRole.find("R:" + ReservedRoleKind.plcRegulation.name());
                            if (regulationObRole != null && regulationObRole instanceof Collection) {
                                List<Role> regulationList = (List<Role>) regulationObRole;
                                for (Role regulationRole : regulationList) {
                                    PlcRegulationEO regulation = (PlcRegulationEO) regulationRole.getFixedActual();
                                    // BeanUtils.populate(regulation,
                                    // regulationRole.getProperty());
                                    plcRegulationList.add(regulation);
                                }
                            }
                        }
                    }
                } catch (Exception ex) {
                    logger.error("format property to PlcRegulationEO error", ex);
                }

            }
        }
        return plcRegulationList;
    }

    /**
     * @return plcRegulationCoinsLinkList
     * @Description: 获取补贴信息
     */
    @SuppressWarnings({ "unchecked" })
    public Map<String, List<PlcRegulationEO>> getPlcRegulationCoinsLink() {

        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        Map<String, List<PlcRegulationEO>> resultMap = new HashMap<String, List<PlcRegulationEO>>();
        /// 报价方案
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcSolution.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return resultMap;
        }
        if (!(o instanceof Collection)) {
            return resultMap;
        }

        List<Role> roleList = (List<Role>) o;
        List<PlcRegulationEO> plcRegulationCoinsList = new ArrayList<PlcRegulationEO>();
        List<PlcRegulationEO> plcRegulationLinkList = new ArrayList<PlcRegulationEO>();
        try {
            for (Role r : roleList) {
                //
                Object plcCoinsOb = r.find("R:" + ReservedRoleKind.plcCoins.name());

                if (plcCoinsOb == null) {
                    continue;
                }
                if (!(plcCoinsOb instanceof Collection)) {
                    continue;
                }

                List<Role> plcCoinsRoleList = (List<Role>) plcCoinsOb;

                for (Role plcCoinsRole : plcCoinsRoleList) {

                    Object plcCoinsBasicInformationOb = plcCoinsRole
                            .find("R:" + ReservedRoleKind.plcCoinsBasicInformation.name());
                    if (plcCoinsBasicInformationOb == null) {
                        continue;
                    }
                    if (!(plcCoinsBasicInformationOb instanceof Collection)) {
                        continue;
                    }
                    List<Role> plcCoinsBasicInformationList = (List<Role>) plcCoinsBasicInformationOb;

                    for (Role plcCoinsBasicInformationRole : plcCoinsBasicInformationList) {
                        // 共保信息
                        Object plcRegulationObRole = plcCoinsBasicInformationRole
                                .find("R:" + ReservedRoleKind.plcRegulation.name());
                        if (plcRegulationObRole != null && plcRegulationObRole instanceof Collection) {
                            List<Role> regulationList = (List<Role>) plcRegulationObRole;
                            for (Role regulationRole : regulationList) {
                                PlcRegulationEO regulation = (PlcRegulationEO) regulationRole.getFixedActual();
                                // BeanUtils.populate(regulation,
                                // regulationRole.getProperty());
                                plcRegulationCoinsList.add(regulation);
                            }
                        }
                    }
                    Object plcLinkBasicInformatOb = plcCoinsRole
                            .find("R:" + ReservedRoleKind.plcLinkBasicInformat.name());
                    // 联保信息
                    if (plcLinkBasicInformatOb == null || (!(plcLinkBasicInformatOb instanceof Collection))) {
                        continue;
                    }
                    List<Role> plcLinkBasicInformatRoleList = (List<Role>) plcLinkBasicInformatOb;
                    for (Role plcLinkBasicInformatRole : plcLinkBasicInformatRoleList) {
                        if (plcLinkBasicInformatRole == null) {
                            continue;
                        }
                        Object plcRegulationLinkObRole = plcLinkBasicInformatRole
                                .find("R:" + ReservedRoleKind.plcRegulation.name());
                        if (plcRegulationLinkObRole != null && plcRegulationLinkObRole instanceof Collection) {
                            List<Role> regulationLinkList = (List<Role>) plcRegulationLinkObRole;
                            for (Role plcRegulationLinkRole : regulationLinkList) {
                                PlcRegulationEO regulation = (PlcRegulationEO) plcRegulationLinkRole.getFixedActual();
                                // BeanUtils.populate(regulation,
                                // plcRegulationLinkRole.getProperty());
                                plcRegulationLinkList.add(regulation);
                            }
                        }
                    }

                }
            }
            resultMap.put("plcLinkRegulation", plcRegulationLinkList);
            resultMap.put("plcCoinsRegulation", plcRegulationCoinsList);
        } catch (Exception ex) {
            logger.error("format property to PlcRegulationEO error", ex);
        }
        return resultMap;
    }

    /**
     * @return plcAddressList
     * @Description: 获取地址信息
     */
    @SuppressWarnings({ "unchecked" })
    public List<PlcAddressEO> getPlcAddress() {

        Role role = bs.getRole();

        if (role == null) {
            return null;
        }
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcAddress.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return null;
        }
        if (!(o instanceof Collection)) {
            return null;
        }
        List<PlcAddressEO> plcAddressList = new ArrayList<PlcAddressEO>();

        List<Role> roleList = (List<Role>) o;
        for (Role r : roleList) {
            try {
                PlcAddressEO plcAddress = (PlcAddressEO) r.getFixedActual();
                // BeanUtils.populate(plcAddress, r.getProperty());
                plcAddressList.add(plcAddress);
            } catch (Exception ex) {
                logger.error("format property to plcaddress error", ex);
            }
        }
        return plcAddressList;
    }

    /**
     * @return planList
     * @Description: 获取缴费计划集合
     */
    @SuppressWarnings("unchecked")
    public List<PlcPlanEO> getPlcPlans() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlcPlanEO> planList = new ArrayList<>();
        // 获取报价方案
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcSolution.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return planList;
        }
        if (!(o instanceof Collection)) {
            return planList;
        }
        List<Role> plcSolutionList = (List<Role>) o;
        try {
            for (Role plcSolutionRole : plcSolutionList) {
                if (!("1".equals(plcSolutionRole.getValue("selectFlag")))
                        && CommonUtil.checkProductCode(getPlcMain().getProductCode())) {
                    // 车险不是选中的方案不传收付
                    if (!(getPlcMain().getProductCode().equals("0507"))) {
                        continue;
                    }
                }
                // 缴费计划
                Object planObj = plcSolutionRole.find("R:" + ReservedRoleKind.plcPlan.name());
                if (planObj == null) {
                    continue;
                }
                if (planObj instanceof Role) {
                    Role actRole = (Role) o;
                    Object obj = convertChildRoleToObject(actRole, ReservedRoleKind.plcPlan.name(), PlcPlanEO.class);
                    PlcPlanEO plan = (PlcPlanEO) obj;
                    planList.add(plan);
                } else if (planObj instanceof Collection) {
                    List<Role> actRoleList = (List<Role>) planObj;
                    for (Role r : actRoleList) {
                        PlcPlanEO plan = (PlcPlanEO) r.getFixedActual();
                        // BeanUtils.populate(plan, r.getProperty());
                        planList.add(plan);
                    }
                }
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlcPlanEO error:", e);
            }
        }
        return planList;
    }

    /**
     * @return plcPlanList
     * @Description: 获取缴费计划集合
     */
    @SuppressWarnings("unchecked")
    public Map<String, List<PlcPlanEO>> getPlcPlan() {
        Map<String, List<PlcPlanEO>> resultMap = new HashMap<String, List<PlcPlanEO>>();
        Role role = bs.getRole();
        if (null == role) {
            return null;
        }
        plcPlanRoleMap = new HashMap<String, Role>();
        List<PlcPlanEO> plcPlanList = new ArrayList<>();
        String plcPlanPath = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcSolution.name());// 缴费计划在报价方案Role中
        Object o = role.find(StartPosition.R.name() + ":" + plcPlanPath);
        if (null == o) {
            return resultMap;
        }
        if (!(o instanceof Collection)) {
            return resultMap;
        }
        try {
            List<Role> plcSolutionRoleList = (List<Role>) o;
            for (Role plcSolutionRole : plcSolutionRoleList) {
                Object obj = plcSolutionRole.find(StartPosition.R.name() + ":" + ReservedRoleKind.plcPlan.name());
                if (null == obj) {
                    continue;
                }
                if (obj instanceof Role) {
                    Role plcPlanRole = (Role) obj;
                    PlcPlanEO plcPlanEO = (PlcPlanEO) plcPlanRole.getFixedActual();
                    // BeanUtils.populate(plcPlanEO,
                    // plcPlanRole.getProperty());//
                    plcPlanList.add(plcPlanEO);
                    plcPlanRoleMap.put(String.valueOf(plcPlanRole.getId()), plcPlanRole);
                } else if (obj instanceof Collection) {
                    List<Role> plcPlanRoles = (List<Role>) obj;
                    for (Role plcPlanRole : plcPlanRoles) {
                        PlcPlanEO plcPlanEO = (PlcPlanEO) plcPlanRole.getFixedActual();
                        // BeanUtils.populate(plcPlanEO,
                        // plcPlanRole.getProperty());
                        plcPlanList.add(plcPlanEO);
                        plcPlanRoleMap.put(String.valueOf(plcPlanRole.getId()), plcPlanRole);
                    }
                }

            }
            resultMap.put(ReservedRoleKind.plcPlan.name(), plcPlanList);
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlcPlanEO error:" + e);
            }
        }
        return resultMap;
    }
    
    /**
     * 获取选中的方案
     *
     * @param rootRole
     *            保单信息
     * @return 方案信息
     */
    private Role selectPlcSolutioan(Role rootRole) {
        List<Role> plcSolutionList = rootRole.findChildren(Role.class, ReservedRoleKind.plcSolution.name());
        Role plcSolution = plcSolutionList.get(0);
        for (Role solution : plcSolutionList) {
            String selectFlag = String.valueOf(solution.getValue("selectFlag"));
            if ("1".equals(selectFlag)) {
                plcSolution = solution;
            }
        }
        return plcSolution;
    }
    

    /**
     * @return commissiondetailList
     * @Description: 获取手续费集合
     */
    @SuppressWarnings("unchecked")
    public List<PlcCommissiondetailEO> getPlcCommissiondetails() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlcCommissiondetailEO> commissiondetailList = new ArrayList<>();
        // 获取选中报价方案
        Role plcSolutionRole = this.selectPlcSolutioan(role);
        if (plcSolutionRole == null) {
            return commissiondetailList;
        }
        try {
            // 拆分手续费信息
            Object commissiondetailObj = plcSolutionRole.find("R:" + ReservedRoleKind.plcCommissionDetail.name());
            if (commissiondetailObj instanceof Role) {
                Role actRole = (Role) commissiondetailObj;
                PlcCommissiondetailEO commissiondetail = (PlcCommissiondetailEO) actRole.getFixedActual();
                commissiondetailList.add(commissiondetail);
            } else if (commissiondetailObj instanceof Collection) {
                List<Role> actRoleList = (List<Role>) commissiondetailObj;
                for (Role r : actRoleList) {
                    PlcCommissiondetailEO commissiondetail = (PlcCommissiondetailEO) r.getFixedActual();
                    commissiondetailList.add(commissiondetail);
                }
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlcCommissiondetailEO error:" + e);
            }
        }
        return commissiondetailList;
    }

    /**
     * @return resultMap
     * @Description: 获取 联保基本信息&共保基本信息 集合
     */
    @SuppressWarnings("unchecked")
    public Map<String, List<PlcCoinsinformationEO>> getPlcCoins() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        plcCoinsRoleMap = new HashMap<String, Role>();
        Map<String, List<PlcCoinsinformationEO>> resultMap = new HashMap<String, List<PlcCoinsinformationEO>>();
        // 获取报价方案
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcSolution.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return resultMap;
        }
        if (!(o instanceof Collection)) {
            return resultMap;
        }
        List<Role> plcSolutionRoleList = (List<Role>) o;
        try {
            List<PlcCoinsinformationEO> plcLinkList = new ArrayList<>();
            List<PlcCoinsinformationEO> plcCoinsList = new ArrayList<>();
            // 获取联共保信息
            for (Role plcSolutionRole : plcSolutionRoleList) {
                Object plcCoinsObj = plcSolutionRole.find("R:" + ReservedRoleKind.plcCoins.name());
                if (plcCoinsObj == null) {
                    continue;
                }
                List<Role> plcCoinsRoleList = (List<Role>) plcCoinsObj;
                for (Role plcCoinsRole : plcCoinsRoleList) {
                    // 联保基本信息
                    Object plcLinkBasicInformationObj = plcCoinsRole
                            .find("R:" + ReservedRoleKind.plcLinkBasicInformat.name());                
                    if (plcLinkBasicInformationObj != null) {
                        if (plcLinkBasicInformationObj instanceof Role) {
                            Role plcLinkBasicInformationRole = (Role) plcLinkBasicInformationObj;
                            PlcCoinsinformationEO plcLink = (PlcCoinsinformationEO) plcLinkBasicInformationRole
                                    .getFixedActual();
                            //fujun
                            plcLink.setCreateUserId(role.getEntity().getCreateUserId());
                            // BeanUtils.populate(plcLink,
                            // plcLinkBasicInformationRole.getProperty());
                            plcLinkList.add(plcLink);
                            plcCoinsRoleMap.put(String.valueOf(plcLinkBasicInformationRole.getId()),
                                    plcLinkBasicInformationRole);
                        } else if (plcLinkBasicInformationObj instanceof Collection) {
                            List<Role> plcLinkBasicInformationRoleList = (List<Role>) plcLinkBasicInformationObj;
                            for (Role plcLinkRole : plcLinkBasicInformationRoleList) {
                                PlcCoinsinformationEO plcLink = (PlcCoinsinformationEO) plcLinkRole.getFixedActual();
                                //fujun
                                plcLink.setCreateUserId(role.getEntity().getCreateUserId());
                                // BeanUtils.populate(plcLink,
                                // plcLinkRole.getProperty());
                                plcLinkList.add(plcLink);
                                plcCoinsRoleMap.put(String.valueOf(plcLinkRole.getId()), plcLinkRole);
                            }
                        }
                    }
                    // 共保基本信息
                    Object plcCoinsBasicInformationObj = plcCoinsRole
                            .find("R:" + ReservedRoleKind.plcCoinsBasicInformation.name());
                    if (plcCoinsBasicInformationObj != null) {
                        if (plcCoinsBasicInformationObj instanceof Role) {
                            Role plcCoinsBasicInformationRole = (Role) plcCoinsBasicInformationObj;
                            PlcCoinsinformationEO plcCoins = (PlcCoinsinformationEO) plcCoinsBasicInformationRole
                                    .getFixedActual();
                            // BeanUtils.populate(plcCoins,
                            // plcCoinsBasicInformationRole.getProperty());
                            plcCoinsList.add(plcCoins);
                            plcCoinsRoleMap.put(String.valueOf(plcCoinsBasicInformationRole.getId()),
                                    plcCoinsBasicInformationRole);
                        } else if (plcCoinsBasicInformationObj instanceof Collection) {
                            List<Role> list = (List<Role>) plcCoinsBasicInformationObj;
                            for (Role plcCoinsInformationRole : list) {
                                PlcCoinsinformationEO plcCoins = (PlcCoinsinformationEO) plcCoinsInformationRole
                                        .getFixedActual();
                                // BeanUtils.populate(plcCoins,
                                // plcCoinsInformationRole.getProperty());
                                plcCoinsList.add(plcCoins);
                                plcCoinsRoleMap.put(String.valueOf(plcCoinsInformationRole.getId()),
                                        plcCoinsInformationRole);
                            }
                        }
                    }
                }
            }
            resultMap.put(ReservedRoleKind.plcLinkBasicInformat.name(), plcLinkList);
            resultMap.put(ReservedRoleKind.plcCoinsBasicInformation.name(), plcCoinsList);
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlcCoinsinformationEO error:" + e);
            }
        }
        return resultMap;
    }

    /**
     * @return resultMap
     * @Description: 获取 联保 销售信息
     */
    @SuppressWarnings("unchecked")
    public Map<String, List<PlcSalesEO>> getPlcCoinsSale() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        plcCoinsRoleMap = new HashMap<String, Role>();
        Map<String, List<PlcSalesEO>> resultMap = new HashMap<String, List<PlcSalesEO>>();
        // 获取报价方案
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcSolution.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return resultMap;
        }
        if (!(o instanceof Collection)) {
            return resultMap;
        }
        List<Role> plcSolutionRoleList = (List<Role>) o;
        try {
            List<PlcSalesEO> plcLinkList = new ArrayList<>();
            // 获取联共保信息
            for (Role plcSolutionRole : plcSolutionRoleList) {
                Object plcCoinsObj = plcSolutionRole.find("R:" + ReservedRoleKind.plcCoins.name());
                if (plcCoinsObj == null) {
                    continue;
                }
                List<Role> plcCoinsRoleList = (List<Role>) plcCoinsObj;
                for (Role plcCoinsRole : plcCoinsRoleList) {
                    // 联保基本信息
                    Object plcLinkBasicInformationObj = plcCoinsRole
                            .find("R:" + ReservedRoleKind.plcCoinsSale.name());                
                    if (plcLinkBasicInformationObj != null) {
                        if (plcLinkBasicInformationObj instanceof Role) {
                            Role plcLinkBasicInformationRole = (Role) plcLinkBasicInformationObj;
                            PlcSalesEO plcLink = (PlcSalesEO) plcLinkBasicInformationRole
                                    .getFixedActual();
                            //fujun
                            plcLink.setCreateUserId(role.getEntity().getCreateUserId());
                            // BeanUtils.populate(plcLink,
                            // plcLinkBasicInformationRole.getProperty());
                            plcLinkList.add(plcLink);
                            plcCoinsRoleMap.put(String.valueOf(plcLinkBasicInformationRole.getId()),
                                    plcLinkBasicInformationRole);
                        } else if (plcLinkBasicInformationObj instanceof Collection) {
                            List<Role> plcLinkBasicInformationRoleList = (List<Role>) plcLinkBasicInformationObj;
                            for (Role plcLinkRole : plcLinkBasicInformationRoleList) {
                                PlcSalesEO plcLink = (PlcSalesEO) plcLinkRole.getFixedActual();
                                //fujun
                                plcLink.setCreateUserId(role.getEntity().getCreateUserId());
                                // BeanUtils.populate(plcLink,
                                // plcLinkRole.getProperty());
                                plcLinkList.add(plcLink);
                                plcCoinsRoleMap.put(String.valueOf(plcLinkRole.getId()), plcLinkRole);
                            }
                        }
                    }
                }
            }
            resultMap.put(ReservedRoleKind.plcCoinsSale.name(), plcLinkList);
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlcCoinsinformationEO error:" + e);
            }
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return resultMap;
    }
    
    /**
     * @return resultList
     * @Description: 获取 联共保手续费集合
     */
    @SuppressWarnings("unchecked")
    public Map<String, List<PlcCoinscommissionEO>> getCoinscommissionMap() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        Map<String, List<PlcCoinscommissionEO>> resultMap = new HashMap<String, List<PlcCoinscommissionEO>>();
        // 获取报价方案
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcSolution.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return resultMap;
        }
        if (!(o instanceof Collection)) {
            return resultMap;
        }
        List<Role> plcSolutionRoleList = (List<Role>) o;
        try {
            // 获取联共保信息
            List<PlcCoinscommissionEO> plcCoinsList = new ArrayList<>();
            List<PlcCoinscommissionEO> plcLinkList = new ArrayList<>();
            for (Role plcSolutionRole : plcSolutionRoleList) {
                Object plcCoinsObj = plcSolutionRole.find("R:" + ReservedRoleKind.plcCoins.name());
                if (plcCoinsObj == null) {
                    continue;
                }
                List<Role> plcCoinsRoleList = (List<Role>) plcCoinsObj;
                for (Role plcCoinsRole : plcCoinsRoleList) {
                    // 共保手续费
                    Object coinsCommissionObj = plcCoinsRole.find("R:" + ReservedRoleKind.plcCoinsCommission.name());
                    if (coinsCommissionObj != null) {
                        if (coinsCommissionObj instanceof Role) {
                            Role commissionRole = (Role) coinsCommissionObj;
                            PlcCoinscommissionEO eo = (PlcCoinscommissionEO) commissionRole.getFixedActual();
                            // BeanUtils.populate(eo,
                            // commissionRole.getProperty());
                            plcCoinsList.add(eo);
                        } else if (coinsCommissionObj instanceof Collection) {
                            List<Role> commissionRoleList = (List<Role>) coinsCommissionObj;
                            for (Role rr : commissionRoleList) {
                                PlcCoinscommissionEO eo = (PlcCoinscommissionEO) rr.getFixedActual();
                                // BeanUtils.populate(eo, rr.getProperty());
                                plcCoinsList.add(eo);
                            }
                        }
                    }

                    // 联保手续费
                    Object linkCommissionObj = plcCoinsRole.find("R:" + ReservedRoleKind.plcLinkCommission.name());
                    if (linkCommissionObj != null) {
                        if (linkCommissionObj instanceof Role) {
                            Role commissionRole = (Role) linkCommissionObj;
                            PlcCoinscommissionEO eo = (PlcCoinscommissionEO) commissionRole.getFixedActual();
                            // BeanUtils.populate(eo,
                            // commissionRole.getProperty());
                            plcLinkList.add(eo);
                        } else if (linkCommissionObj instanceof Collection) {
                            List<Role> commissionRoleList = (List<Role>) linkCommissionObj;
                            for (Role rr : commissionRoleList) {
                                PlcCoinscommissionEO eo = (PlcCoinscommissionEO) rr.getFixedActual();
                                // BeanUtils.populate(eo, rr.getProperty());
                                plcLinkList.add(eo);
                            }
                        }
                    }
                }
            }
            resultMap.put(ReservedRoleKind.plcLinkCommission.name(), plcLinkList);
            resultMap.put(ReservedRoleKind.plcCoinsCommission.name(), plcCoinsList);
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlcCoinscommissionEO error:" + e);
            }
        }
        return resultMap;
    }

    /**
     * @return resultList
     * @Description: 获取 联共保手续费集合
     */
    @SuppressWarnings("unchecked")
    public List<PlcCoinscommissionEO> getCoinscommissions() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlcCoinscommissionEO> resultList = new ArrayList<>();
        // 获取报价方案
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcSolution.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return resultList;
        }
        if (!(o instanceof Collection)) {
            return resultList;
        }
        List<Role> plcSolutionRoleList = (List<Role>) o;
        try {
            // 获取联共保信息
            for (Role plcSolutionRole : plcSolutionRoleList) {
                Object plcCoinsObj = plcSolutionRole.find("R:" + ReservedRoleKind.plcCoins.name());
                if (plcCoinsObj == null) {
                    continue;
                }
                List<Role> plcCoinsRoleList = (List<Role>) plcCoinsObj;
                for (Role plcCoinsRole : plcCoinsRoleList) {
                    // 共保手续费
                    Object coinsCommissionObj = plcCoinsRole.find("R:" + ReservedRoleKind.plcCoinsCommission.name());
                    if (coinsCommissionObj != null) {
                        if (coinsCommissionObj instanceof Role) {
                            Role commissionRole = (Role) coinsCommissionObj;
                            PlcCoinscommissionEO eo = (PlcCoinscommissionEO) commissionRole.getFixedActual();
                            // BeanUtils.populate(eo,
                            // commissionRole.getProperty());
                            resultList.add(eo);
                        } else if (coinsCommissionObj instanceof Collection) {
                            List<Role> commissionRoleList = (List<Role>) coinsCommissionObj;
                            for (Role rr : commissionRoleList) {
                                PlcCoinscommissionEO eo = (PlcCoinscommissionEO) rr.getFixedActual();
                                // BeanUtils.populate(eo, rr.getProperty());
                                resultList.add(eo);
                            }
                        }
                    }

                    // 联保手续费
                    Object linkCommissionObj = plcCoinsRole.find("R:" + ReservedRoleKind.plcLinkCommission.name());
                    if (linkCommissionObj != null) {
                        if (linkCommissionObj instanceof Role) {
                            Role commissionRole = (Role) linkCommissionObj;
                            PlcCoinscommissionEO eo = (PlcCoinscommissionEO) commissionRole.getFixedActual();
                            // BeanUtils.populate(eo,
                            // commissionRole.getProperty());
                            resultList.add(eo);
                        } else if (linkCommissionObj instanceof Collection) {
                            List<Role> commissionRoleList = (List<Role>) linkCommissionObj;
                            for (Role rr : commissionRoleList) {
                                PlcCoinscommissionEO eo = (PlcCoinscommissionEO) rr.getFixedActual();
                                // BeanUtils.populate(eo, rr.getProperty());
                                resultList.add(eo);
                            }
                        }
                    }
                }
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlcCoinscommissionEO error:" + e);
            }
        }
        return resultList;
    }

    /**
     * @return plcPrintInformationList
     * @Description: 获取打印信息
     */
    @SuppressWarnings("unchecked")
    public List<PlcPrintInformationEO> getPlcPrintInformation() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        // 获取打印信息
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcPrintInformation.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (!(o instanceof Collection)) {
            return null;
        }
        List<PlcPrintInformationEO> plcPrintInformationList = new ArrayList<PlcPrintInformationEO>();

        List<Role> roles = (List<Role>) o;
        for (Role r : roles) {
            try {
                PlcPrintInformationEO plcPrintInformationEO = (PlcPrintInformationEO) r.getFixedActual();
                // BeanUtils.populate(plcPrintInformationEO, r.getProperty());
                plcPrintInformationList.add(plcPrintInformationEO);
            } catch (Exception e) {
                logger.error("format property to plcaddress error", e);
            }
        }
        return plcPrintInformationList;
    }

    /**
     * @return plcSaleList
     * @Description: 获取业务归属信息
     */
    @SuppressWarnings("unchecked")
    public List<PlcSalesEO> getPlcSales() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlcSalesEO> resultList = new ArrayList<>();
        // 获取业务归属role的路径
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcSales.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return resultList;
        }
        if (!(o instanceof Collection)) {
            return resultList;
        }
        List<Role> plcSalesRoleList = (List<Role>) o;
        try {
            for (Role r : plcSalesRoleList) {
                PlcSalesEO pse = (PlcSalesEO) r.getFixedActual();
                // BeanUtils.populate(pse, r.getProperty());
                resultList.add(pse);
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlcSalesEO error:" + e);
            }
        }
        return resultList;
    }

    /**
     * @return resultList
     * @Description: 获取特别约定
     */
    @SuppressWarnings("unchecked")
    public List<PlcEngageEO> getPlcEngages() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlcEngageEO> resultList = new ArrayList<>();
        // 获取报价方案
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcSolution.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return resultList;
        }
        if (!(o instanceof Collection)) {
            return resultList;
        }
        List<Role> plcSolutionRoleList = (List<Role>) o;
        try {
            for (Role plcSolutionRole : plcSolutionRoleList) {
                Object plcEngageObj = plcSolutionRole
                        .find(StartPosition.R.name() + ":" + ReservedRoleKind.plcEngage.name());
                if (plcEngageObj == null) {
                    continue;
                }
                List<Role> plcEngageRoleList = (List<Role>) plcEngageObj;
                for (Role r : plcEngageRoleList) {
                    PlcEngageEO pee = (PlcEngageEO) r.getFixedActual();
                    // BeanUtils.populate(pee, r.getProperty());
                    resultList.add(pee);
                }
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlcEngageEO error:" + e);
            }
        }
        return resultList;
    }

    /**
     * @return resultList
     * @Description: 获取币别汇总信息表
     */
    @SuppressWarnings("unchecked")
    public List<PlcFeeEO> getPlcFees() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlcFeeEO> resultList = new ArrayList<>();
        // 获取报价方案
        String solutionPath = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcSolution.name());
        Object solutionRoleObj = role.find(StartPosition.R.name() + ":" + solutionPath);
        if (solutionRoleObj == null || !(solutionRoleObj instanceof Collection)) {
            return resultList;
        }
        List<Role> solutionRoleList = (List<Role>) solutionRoleObj;
        try {
            for (Role r : solutionRoleList) {
                String feePath = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcFee.name());
                Object feeRoleObj = r.find(StartPosition.R.name() + ":" + feePath);
                if (feeRoleObj == null || !(feeRoleObj instanceof Collection)) {
                    continue;
                }
                List<Role> feeRoleList = (List<Role>) feeRoleObj;
                for (Role feeRole : feeRoleList) {
                    PlcFeeEO feeOb = (PlcFeeEO) feeRole.getFixedActual();
                    // BeanUtils.populate(feeOb, feeRole.getProperty());
                    resultList.add(feeOb);
                }
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlcFeeEO error:" + e);
            }
        }
        return resultList;
    }

    /**
     * @return plpEndorse
     * @Description: 获取批改信息表
     */
    @SuppressWarnings("unchecked")
    public PlpEndorseEO getPlpEndorse() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        PlpEndorseEO plpEndorse = new PlpEndorseEO();
        // 获取批改信息role的路径
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plpEndorse.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return plpEndorse;
        }
        List<Role> rose = (List<Role>) o;
        if (rose.size() <= 0) {
            return plpEndorse;
        }
        Role r = rose.get(0);
        // 将批改费用添加到批改信息部件
        List<PlpCostEO> plpCostEOS = getPlpCosts(r);
        if (plpCostEOS != null) {
            plpEndorse.setPlpCostEOs(plpCostEOS);
        }

        try {
            plpEndorse = (PlpEndorseEO) r.getFixedActual();
            // BeanUtils.populate(plpEndorse, r.getProperty());
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlpEndorseEO error:" + e);
            }
        }
        return plpEndorse;
    }

    /**
     * @return resultList
     * @Description: 获取批文信息表
     */
    @SuppressWarnings("unchecked")
    public List<PlpEndorsecontentEO> getPlpEndorsecontents() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlpEndorsecontentEO> resultList = new ArrayList<>();
        // 获取批改信息
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plpEndorse.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return resultList;
        }
        if (!(o instanceof Collection)) {
            return resultList;
        }
        List<Role> plpEndorseRole = (List<Role>) o;
        if (plpEndorseRole.size() <= 0) {
            return resultList;
        }
        Role rr = plpEndorseRole.get(0);
        try {
            Object plpEndorsecontentObj = rr
                    .find(StartPosition.R.name() + ":" + ReservedRoleKind.plpEndorseContent.name());
            if (plpEndorsecontentObj == null) {
                return resultList;
            }
            List<Role> plpEndorsecontentRoleList = (List<Role>) plpEndorsecontentObj;
            for (Role r : plpEndorsecontentRoleList) {
                PlpEndorsecontentEO plpEndorsecontent = (PlpEndorsecontentEO) r.getFixedActual();
                // BeanUtils.populate(plpEndorsecontent, r.getProperty());
                resultList.add(plpEndorsecontent);
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlcEngageEO error:" + e);
            }
        }
        return resultList;
    }

    /**
     * @return resultList
     * @Description: 获取批改联共保信息
     */
    @SuppressWarnings("unchecked")
    public List<PlpCoinsinformationEO> getplpCoinsInformation() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlpCoinsinformationEO> resultList = new ArrayList<>();
        // 获取批改信息
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plpEndorse.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return resultList;
        }
        if (!(o instanceof Collection)) {
            return resultList;
        }
        List<Role> plpEndorseRole = (List<Role>) o;
        if (plpEndorseRole.size() <= 0) {
            return resultList;
        }
        Role rr = plpEndorseRole.get(0);
        try {
            Object plpCoinsInformationObj = rr
                    .find(StartPosition.R.name() + ":" + ReservedRoleKind.plpCoinsInformation.name());
            if (plpCoinsInformationObj == null) {
                return resultList;
            }
            List<Role> plpCoinsInformationRoleList = (List<Role>) plpCoinsInformationObj;
            for (Role r : plpCoinsInformationRoleList) {
                PlpCoinsinformationEO plpCoinsinformation = (PlpCoinsinformationEO) r.getFixedActual();
                // BeanUtils.populate(plpCoinsinformation, r.getProperty());
                resultList.add(plpCoinsinformation);
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlpCoinsinformationEO error:" + e);
            }
        }
        return resultList;
    }

    /**
     * @Description: 获取批改补贴信息
     * @return resultList 农险批改补贴信息
     */
    public List<PlpRegulationEO> getplpRegulation() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlpRegulationEO> resultList = new ArrayList<>();
        // 获取批改信息
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plpEndorse.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return resultList;
        }
        if (!(o instanceof Collection)) {
            return resultList;
        }
        List<Role> plpEndorseRole = (List<Role>) o;
        if (plpEndorseRole.size() <= 0) {
            return resultList;
        }
        Role rr = plpEndorseRole.get(0);
        try {
            Object plpRegulationObj = rr.find(StartPosition.R.name() + ":" + ReservedRoleKind.plpRegulation.name());
            if (plpRegulationObj == null) {
                return resultList;
            }
            List<Role> plpRegulationRoleList = (List<Role>) plpRegulationObj;
            for (Role r : plpRegulationRoleList) {
                PlpRegulationEO plpRegulation = (PlpRegulationEO) r.getFixedActual();
                // BeanUtils.populate(plpRegulation, r.getProperty());
                resultList.add(plpRegulation);
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlpRegulationEO error:" + e);
            }
        }
        return resultList;
    }

    /**
     * @return resultList
     * @description 获取代理方案信息表
     */
    @SuppressWarnings("unchecked")
    public List<PlcAgentplanEO> getPlcAgentplans() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlcAgentplanEO> resultList = new ArrayList<>();
        // 代理方案信息
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcAgentPlan.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return resultList;
        }
        if (!(o instanceof Collection)) {
            return resultList;
        }
        List<Role> plcAgentplanList = (List<Role>) o;
        try {
            for (Role r : plcAgentplanList) {
                PlcAgentplanEO plcAgebtPlanOb = (PlcAgentplanEO) r.getFixedActual();
                // BeanUtils.populate(plcAgebtPlanOb, r.getProperty());
                resultList.add(plcAgebtPlanOb);
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlcAgentplanEO error:" + e);
            }
        }
        return resultList;
    }

    /**
     * @return resultList
     * @Description: 获取产品销售方案信息
     */
    @SuppressWarnings("unchecked")
    public List<PlcPackageEO> getPlcPackage() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }

        Object plcSolutionObj = role.find(StartPosition.R.name() + ":" + ReservedRoleKind.plcSolution.name());
        List<Role> roleList = (List<Role>) plcSolutionObj;
        List<PlcPackageEO> resultList = new ArrayList<>();
        // 代理方案信息
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcPackage.name());
        Object o = roleList.get(0).find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return resultList;
        }
        if (!(o instanceof Collection)) {
            return resultList;
        }
        List<Role> plcPackageList = (List<Role>) o;
        try {
            for (Role r : plcPackageList) {
                PlcPackageEO plcPackageOb = (PlcPackageEO) r.getFixedActual();
                // BeanUtils.populate(plcPackageOb, r.getProperty());
                resultList.add(plcPackageOb);
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlcAgentplanEO error:" + e);
            }
        }
        return resultList;
    }

    /**
     * @return resultList
     * @Description: 获取报价方案信息
     */
    @SuppressWarnings("unchecked")
    public List<PlcSolutionEO> getPlcSolution() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlcSolutionEO> resultList = new ArrayList<PlcSolutionEO>();
        // 代理方案信息
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcSolution.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return resultList;
        }
        if (!(o instanceof Collection)) {
            return resultList;
        }
        List<Role> plcSolutionEOList = (List<Role>) o;
        try {
            for (Role r : plcSolutionEOList) {
                PlcSolutionEO plcSolutionOb = (PlcSolutionEO) r.getFixedActual();
                // BeanUtils.populate(plcSolutionOb, r.getProperty());
                resultList.add(plcSolutionOb);
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlcAgentplanEO error:" + e);
            }
        }
        return resultList;
    }

    /**
     * @return resultList
     * @Description: 获取房屋标的
     */
    @SuppressWarnings("unchecked")
    public List<PlcHouseEO> getplcHouseList() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        ConcurrentHashMap<String, PlcHouseEO> houseMap = new ConcurrentHashMap<>();
        List<PlcHouseEO> resultList = new ArrayList<>();
        // 获取批改信息role的路径
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcHouse.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return resultList;
        }
        List<Role> rList = (List<Role>) o;
        if (CollectionUtils.isNotEmpty(rList)) {
            try {
                for (Role r : rList) {
                    PlcHouseEO plcHouse = new PlcHouseEO();
                    BeanUtils.copyProperties(plcHouse, r.getProperty());
                    resultList.add(plcHouse);
                    houseMap.put(plcHouse.getItemNo(), plcHouse);
                }
            } catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("format property to PlcHouseEO error:" + e);
                }
            }
        }
        this.setHouseMap(houseMap);
        return resultList;
    }

    /**
     * @return resultList
     * @Description: 获取批改手续费变化量
     */
    @SuppressWarnings("unchecked")
    public List<PlpCommissiondetailEO> getPlpCommissionDetailList() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlpCommissiondetailEO> resultList = new ArrayList<>();
        // 获取批改信息role的路径
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plpEndorse.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return resultList;
        }
        List<Role> rose = (List<Role>) o;
        if (rose.size() <= 0) {
            return resultList;
        }
        Role r = rose.get(0);
        try {
            Object plpEndorsecontentObj = r
                    .find(StartPosition.R.name() + ":" + ReservedRoleKind.plpCommissionDetail.name());
            if (plpEndorsecontentObj == null) {
                return resultList;
            }
            List<Role> roleList = (List<Role>) plpEndorsecontentObj;
            for (Role rr : roleList) {
                PlpCommissiondetailEO resultEo = new PlpCommissiondetailEO();
                BeanUtils.copyProperties(resultEo, rr.getProperty());
                resultList.add(resultEo);
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlpCommissiondetailEO error:" + e);
            }
        }
        return resultList;
    }
    
    /**
     * @return resultList
     * @Description: 获取批改管理费变化量
     */
    @SuppressWarnings("unchecked")
    public List<PlpMgCommissiondetailEO> getPlpMgCommissionDetailList() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlpMgCommissiondetailEO> resultList = new ArrayList<>();
        // 获取批改信息role的路径
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plpEndorse.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return resultList;
        }
        List<Role> rose = (List<Role>) o;
        if (rose.size() <= 0) {
            return resultList;
        }
        Role r = rose.get(0);
        try {
            Object plpEndorsecontentObj = r
                    .find(StartPosition.R.name() + ":" + ReservedRoleKind.plpMgCommissionDetail.name());
            if (plpEndorsecontentObj == null) {
                return resultList;
            }
            List<Role> roleList = (List<Role>) plpEndorsecontentObj;
            for (Role rr : roleList) {
                PlpMgCommissiondetailEO resultEo = new PlpMgCommissiondetailEO();
                BeanUtils.copyProperties(resultEo, rr.getProperty());
                resultList.add(resultEo);
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlpMgCommissiondetailEO error:" + e);
            }
        }
        return resultList;
    }

    /**
     * @return 保单打印数据
     * @Description: 打印保单数据
     */
    public BusinessEntityVO getBusinessEntityVO() {
        BusinessEntityVO businessEntityVO = new BusinessEntityVO();
        PlcMainEO plcMain = getPlcMain();
        List<PlcInsurantEO> plcApplicants = getPlcApplicant();
        List<PlcInsurantEO> plcInsurant = getPlcInsurant();
        List<PlcAddressEO> plcAddress = getPlcAddress();
        List<PlcHouseEO> plcHouses = getplcHouseList();
        List<PlcSolutionEO> plcSolutions = getPlcSolutions();
        List<PlcMainEO> plcMainEOs = new ArrayList<PlcMainEO>();
        plcMainEOs.add(plcMain);
        if (plcMain != null) {
            businessEntityVO.setBusinessOffice(plcMain.getBusinessOfficeName());
            businessEntityVO.setOperateSite(plcMain.getOperateSite());
            businessEntityVO.setSignDate(plcMain.getSignDate());
        }
        businessEntityVO.setPlcMainEOs(plcMainEOs);
        businessEntityVO.setPlcApplicants(plcApplicants);
        businessEntityVO.setPlcInsurants(plcInsurant);
        businessEntityVO.setPlcAddressEOs(plcAddress);
        businessEntityVO.setPlcHouseEOs(plcHouses);
        businessEntityVO.setPlcSolutionEOs(plcSolutions);
        return businessEntityVO;
    }

    /**
     * @return 集合
     * @Description: 投保人信息
     */
    @SuppressWarnings("unchecked")
    public List<PlcInsurantEO> getPlcApplicant() {

        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlcInsurantEO> plcInsurantEOs = new ArrayList<PlcInsurantEO>();
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcApplicant.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        try {
            plcApplicantRoleMap = new ConcurrentHashMap<>();
            List<PlcCustomerEO> plcCustomerEOs = new ArrayList<PlcCustomerEO>();
            List<PlcGrpcustomerEO> plcGrpcustomerEOs = new ArrayList<PlcGrpcustomerEO>();
            if (o instanceof Role) {
                Role actRole = (Role) o;
                // Map<String, Object> propertyMap = actRole.getProperty();
                PlcInsurantEO plcInsurantEO = (PlcInsurantEO)actRole.getFixedActual();
                //BeanUtils.copyProperties(plcInsurantEO, propertyMap);
                String plcApplicantRoleMapKey = new StringBuilder().append(plcInsurantEO.getCustomerName()).append("_")
                        .append(plcInsurantEO.getIdentifyType()).append("_").append(plcInsurantEO.getIdentifyNumber())
                        .toString();
                plcApplicantRoleMap.put(plcApplicantRoleMapKey, actRole);
                Object plcCustomerOb = convertChildRoleToObject(actRole, ReservedRoleKind.plcCustomer.name(),
                        PlcCustomerEO.class);
                plcCustomerEOs.add(plcCustomerOb == null ? null : (PlcCustomerEO) plcCustomerOb);
                plcInsurantEO.setPlcCustomerEOs(plcCustomerEOs);

                Object plcGrpcustomerOb = convertChildRoleToObject(actRole, ReservedRoleKind.plcGrpCustomer.name(),
                        PlcGrpcustomerEO.class);
                plcGrpcustomerEOs.add(plcGrpcustomerOb == null ? null : (PlcGrpcustomerEO) plcGrpcustomerOb);
                plcInsurantEO.setPlcGrpcustomerEOs(plcGrpcustomerEOs);
                plcInsurantEOs.add(plcInsurantEO);

            } else if (o instanceof Collection) {

                List<Role> roleList = (List<Role>) o;

                for (Role r : roleList) {
                    //Map<String, Object> propertyMap = r.getProperty();
                    PlcInsurantEO plcInsurantEO = (PlcInsurantEO)r.getFixedActual();
                    //BeanUtils.copyProperties(plcInsurantEO, propertyMap);
                    String plcApplicantRoleMapKey = new StringBuilder().append(plcInsurantEO.getCustomerName())
                            .append("_").append(plcInsurantEO.getIdentifyType()).append("_")
                            .append(plcInsurantEO.getIdentifyNumber()).toString();
                    plcApplicantRoleMap.put(plcApplicantRoleMapKey, r);
                    Object plcCustomerOb = convertChildRoleToObject(r, ReservedRoleKind.plcCustomer.name(),
                            PlcCustomerEO.class);
                    plcCustomerEOs.add(plcCustomerOb == null ? null : (PlcCustomerEO) plcCustomerOb);
                    plcInsurantEO.setPlcCustomerEOs(plcCustomerEOs);

                    Object plcGrpcustomerOb = convertChildRoleToObject(r, ReservedRoleKind.plcGrpCustomer.name(),
                            PlcGrpcustomerEO.class);
                    plcGrpcustomerEOs.add(plcGrpcustomerOb == null ? null : (PlcGrpcustomerEO) plcGrpcustomerOb);
                    plcInsurantEO.setPlcGrpcustomerEOs(plcGrpcustomerEOs);
                    plcInsurantEOs.add(plcInsurantEO);
                }

            }
        } catch (Exception ex) {
            logger.error("format property to PlcInsurants error", ex);
        }
        return plcInsurantEOs;
    }

    /**
     * @return 集合
     * @Description: 被保人信息
     */
    @SuppressWarnings("unchecked")
    public List<PlcInsurantEO> getPlcInsurant() {

        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlcInsurantEO> plcInsurantEOs = new ArrayList<PlcInsurantEO>();
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcInsurant.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        try {
            plcInsurantRoleMap = new ConcurrentHashMap<>();
            List<PlcCustomerEO> plcCustomerEOs = new ArrayList<PlcCustomerEO>();
            List<PlcGrpcustomerEO> plcGrpcustomerEOs = new ArrayList<PlcGrpcustomerEO>();
            if (o instanceof Role) {
                Role actRole = (Role) o;
                Map<String, Object> propertyMap = actRole.getProperty();
                PlcInsurantEO plcInsurantEO = new PlcInsurantEO();
                BeanUtils.copyProperties(plcInsurantEO, propertyMap);
                String plcInsurantRoleMapKey = new StringBuilder().append(plcInsurantEO.getCustomerName()).append("_")
                        .append(plcInsurantEO.getIdentifyType()).append("_").append(plcInsurantEO.getIdentifyNumber())
                        .toString();
                plcInsurantRoleMap.put(plcInsurantRoleMapKey, actRole);
                Object plcCustomerOb = convertChildRoleToObject(actRole, ReservedRoleKind.plcCustomer.name(),
                        PlcCustomerEO.class);
                plcCustomerEOs.add(plcCustomerOb == null ? null : (PlcCustomerEO) plcCustomerOb);
                plcInsurantEO.setPlcCustomerEOs(plcCustomerEOs);

                Object plcGrpcustomerOb = convertChildRoleToObject(actRole, ReservedRoleKind.plcGrpCustomer.name(),
                        PlcGrpcustomerEO.class);
                plcGrpcustomerEOs.add(plcGrpcustomerOb == null ? null : (PlcGrpcustomerEO) plcGrpcustomerOb);
                plcInsurantEO.setPlcGrpcustomerEOs(plcGrpcustomerEOs);
                plcInsurantEOs.add(plcInsurantEO);

            } else if (o instanceof Collection) {

                List<Role> roleList = (List<Role>) o;

                for (Role r : roleList) {
                    Map<String, Object> propertyMap = r.getProperty();
                    PlcInsurantEO plcInsurantEO = new PlcInsurantEO();
                    BeanUtils.copyProperties(plcInsurantEO, propertyMap);
                    String plcInsurantRoleMapKey = new StringBuilder().append(plcInsurantEO.getCustomerName())
                            .append("_").append(plcInsurantEO.getIdentifyType()).append("_")
                            .append(plcInsurantEO.getIdentifyNumber()).toString();
                    plcInsurantRoleMap.put(plcInsurantRoleMapKey, r);
                    Object plcCustomerOb = convertChildRoleToObject(r, ReservedRoleKind.plcCustomer.name(),
                            PlcCustomerEO.class);
                    plcCustomerEOs.add(plcCustomerOb == null ? null : (PlcCustomerEO) plcCustomerOb);
                    plcInsurantEO.setPlcCustomerEOs(plcCustomerEOs);

                    Object plcGrpcustomerOb = convertChildRoleToObject(r, ReservedRoleKind.plcGrpCustomer.name(),
                            PlcGrpcustomerEO.class);
                    plcGrpcustomerEOs.add(plcGrpcustomerOb == null ? null : (PlcGrpcustomerEO) plcGrpcustomerOb);
                    plcInsurantEO.setPlcGrpcustomerEOs(plcGrpcustomerEOs);
                    plcInsurantEOs.add(plcInsurantEO);
                }

            }
        } catch (Exception ex) {
            logger.error("format property to PlcInsurants error", ex);
        }
        return plcInsurantEOs;
    }

    /**
     * @return 集合
     * @Description: 可售产品信息
     */
    @SuppressWarnings("unchecked")
    public List<PlcAvaProductEO> getPlcAvaProduct() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlcAvaProductEO> plcAvaProductEOs = new ArrayList<PlcAvaProductEO>();
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcAvaProduct.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        try {
            plcInsurantRoleMap = new ConcurrentHashMap<>();
            if (o instanceof Role) {
                Role actRole = (Role) o;
                Map<String, Object> propertyMap = actRole.getProperty();
                PlcAvaProductEO plcAvaProductEO = new PlcAvaProductEO();
                BeanUtils.copyProperties(plcAvaProductEO, propertyMap);
                plcAvaProductEOs.add(plcAvaProductEO);

            } else if (o instanceof Collection) {
                List<Role> roleList = (List<Role>) o;
                for (Role r : roleList) {
                    Map<String, Object> propertyMap = r.getProperty();
                    PlcAvaProductEO plcAvaProductEO = new PlcAvaProductEO();
                    BeanUtils.copyProperties(plcAvaProductEO, propertyMap);
                    plcAvaProductEOs.add(plcAvaProductEO);
                }
            }
        } catch (Exception ex) {
            logger.error("format property to plcAvaProductEOs error", ex);
        }
        return plcAvaProductEOs;
    }

    /**
     * @return 产品信息
     * @Description: 协议产品信息
     */
    @SuppressWarnings("unchecked")
    public String getPlcAvaProductEnum() {
        String sResult = "|";
        List<PlcAvaProductEO> plcAvaProductEOs = getPlcAvaProduct();
        Iterator<PlcAvaProductEO> iterator = plcAvaProductEOs.iterator();
        while (iterator.hasNext()) {
            PlcAvaProductEO plcAvaProductEO = iterator.next();
            sResult += plcAvaProductEO.getProductCode() + "|";
        }
        return sResult;
    }

    /**
     * @return 集合
     * @Description: 公共被保人信息
     */
    @SuppressWarnings("unchecked")
    public List<PlcInsurantEO> getPlcPublicInsurant() {

        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlcInsurantEO> plcPublicInsurantEOs = new ArrayList<PlcInsurantEO>();
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcPublicInsurant.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        try {
            plcInsurantRoleMap = new ConcurrentHashMap<>();
            List<PlcCustomerEO> plcCustomerEOs = new ArrayList<PlcCustomerEO>();
            List<PlcGrpcustomerEO> plcGrpcustomerEOs = new ArrayList<PlcGrpcustomerEO>();
            if (o instanceof Role) {
                Role actRole = (Role) o;
                //Map<String, Object> propertyMap = actRole.getProperty();
                PlcInsurantEO plcInsurantEO = (PlcInsurantEO)actRole.getFixedActual();
                //BeanUtils.copyProperties(plcInsurantEO, propertyMap);
                String plcInsurantRoleMapKey = new StringBuilder().append(plcInsurantEO.getCustomerName()).append("_")
                        .append(plcInsurantEO.getIdentifyType()).append("_").append(plcInsurantEO.getIdentifyNumber())
                        .toString();
                plcInsurantRoleMap.put(plcInsurantRoleMapKey, actRole);
                Object plcCustomerOb = convertChildRoleToObject(actRole, ReservedRoleKind.plcCustomer.name(),
                        PlcCustomerEO.class);
                plcCustomerEOs.add(plcCustomerOb == null ? null : (PlcCustomerEO) plcCustomerOb);
                plcInsurantEO.setPlcCustomerEOs(plcCustomerEOs);

                Object plcGrpcustomerOb = convertChildRoleToObject(actRole, ReservedRoleKind.plcGrpCustomer.name(),
                        PlcGrpcustomerEO.class);
                plcGrpcustomerEOs.add(plcGrpcustomerOb == null ? null : (PlcGrpcustomerEO) plcGrpcustomerOb);
                plcInsurantEO.setPlcGrpcustomerEOs(plcGrpcustomerEOs);
                plcPublicInsurantEOs.add(plcInsurantEO);

            } else if (o instanceof Collection) {

                List<Role> roleList = (List<Role>) o;

                for (Role r : roleList) {
                    //Map<String, Object> propertyMap = r.getProperty();
                    PlcInsurantEO plcInsurantEO = (PlcInsurantEO)r.getFixedActual();
                    //BeanUtils.copyProperties(plcInsurantEO, propertyMap);
                    String plcInsurantRoleMapKey = new StringBuilder().append(plcInsurantEO.getCustomerName())
                            .append("_").append(plcInsurantEO.getIdentifyType()).append("_")
                            .append(plcInsurantEO.getIdentifyNumber()).toString();
                    plcInsurantRoleMap.put(plcInsurantRoleMapKey, r);
                    Object plcCustomerOb = convertChildRoleToObject(r, ReservedRoleKind.plcCustomer.name(),
                            PlcCustomerEO.class);
                    plcCustomerEOs.add(plcCustomerOb == null ? null : (PlcCustomerEO) plcCustomerOb);
                    plcInsurantEO.setPlcCustomerEOs(plcCustomerEOs);

                    Object plcGrpcustomerOb = convertChildRoleToObject(r, ReservedRoleKind.plcGrpCustomer.name(),
                            PlcGrpcustomerEO.class);
                    plcGrpcustomerEOs.add(plcGrpcustomerOb == null ? null : (PlcGrpcustomerEO) plcGrpcustomerOb);
                    plcInsurantEO.setPlcGrpcustomerEOs(plcGrpcustomerEOs);
                    plcPublicInsurantEOs.add(plcInsurantEO);
                }

            }
        } catch (Exception ex) {
            logger.error("format property to PlcInsurants error", ex);
        }
        return plcPublicInsurantEOs;
    }

    /**
     * @return 集合
     *
     * @Description: 报价--->条责标数据处理用于打印数据绑定
     * @author xhj
     */
    @SuppressWarnings("unchecked")
    public List<PlcSolutionEO> getPlcSolutions() {
        // 最后返回数据的处理
        List<PlcSolutionEO> plcSolutionEOs = new ArrayList<PlcSolutionEO>();
        PlcSolutionEO plcSolutionEO = null;
        Role role = bs.getRole();
        if (role == null) {
            return plcSolutionEOs;
        } else {
            String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcSolution.name());
            Object o = role.find(StartPosition.R.name() + ":" + path);
            try {
                if (o instanceof Role) {
                    plcSolutionEO = new PlcSolutionEO();
                    Role actRole = (Role) o;
                    //Map<String, Object> propertyMap = actRole.getProperty();
                    //BeanUtils.copyProperties(plcSolutionEO, propertyMap);
                    plcSolutionEO = (PlcSolutionEO)actRole.getFixedActual();
                    // 获得产品销售方案信息部件
                    List<PlcPackageEO> plcPackageEOs = getPlcPackageEOs(actRole);
                    if (!plcPackageEOs.isEmpty()) {
                        plcSolutionEO.setPlcPackageEOs(plcPackageEOs);
                    }
                    plcSolutionEOs.add(plcSolutionEO);

                    // 获取保单费用，并添加到报价方案信息中

                    List<PlcCostEO> plcCostEOS = getPlcCosts(actRole);
                    if (plcCostEOS != null) {
                        plcSolutionEO.setPlcCostEOs(plcCostEOS);
                    }
                    plcSolutionEOs.add(plcSolutionEO);
                } else if (o instanceof Collection) {
                    List<Role> roleList = (List<Role>) o;
                    for (Role role2 : roleList) {
                        //plcSolutionEO = new PlcSolutionEO();
                        plcSolutionEO = (PlcSolutionEO)role2.getFixedActual();
                        //Map<String, Object> property = role2.getProperty();
                        //BeanUtils.copyProperties(plcSolutionEO, property);
                        // 获得产品销售方案信息部件
                        List<PlcPackageEO> plcPackageEOs = getPlcPackageEOs(role2);
                        if (!plcPackageEOs.isEmpty()) {
                            plcSolutionEO.setPlcPackageEOs(plcPackageEOs);
                        }
                        plcSolutionEOs.add(plcSolutionEO);

                        // 获取保单费用，并添加到报价方案信息中

                        List<PlcCostEO> plcCostEOS = getPlcCosts(role2);
                        if (plcCostEOS != null) {
                            plcSolutionEO.setPlcCostEOs(plcCostEOS);
                        }
                        plcSolutionEOs.add(plcSolutionEO);
                    }
                }
            } catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("format property to PlcPackageEO error:" + e);
                }
            }
        }
        return plcSolutionEOs;
    }

    /**
     * @param role
     *            父节点部件
     * @return 集合
     * @Description: 获得条责标信息
     * @author xhj
     */
    private List<PlcClauseitemEO> getPlcClauseItems(Role role) {
        List<PlcClauseitemEO> plcClauseitemEOs = new ArrayList<PlcClauseitemEO>();
        PlcClauseitemEO plcClauseitemEO = null;
        try {
            Object plcClauseItemOb = convertChildRole(role, ReservedRoleKind.plcClauseItem.name());
            if (plcClauseItemOb != null) {
                if (plcClauseItemOb instanceof Role) {
                    plcClauseitemEO = new PlcClauseitemEO();
                    Role plcClauseItemRole = (Role) plcClauseItemOb;
                    plcClauseitemEO = (PlcClauseitemEO)plcClauseItemRole.getFixedActual();
                    //Map<String, Object> plcClauseItemPropertyMap = plcClauseItemRole.getProperty();
                    //BeanUtils.copyProperties(plcClauseitemEO, plcClauseItemPropertyMap);
                    plcClauseitemEOs.add(plcClauseitemEO);
                } else if (plcClauseItemOb instanceof Collection) {
                    List<Role> plcClauseItemRoleList = (List<Role>) plcClauseItemOb;
                    for (Role plcClauseIterole : plcClauseItemRoleList) {
                        plcClauseitemEO = new PlcClauseitemEO();
                        plcClauseitemEO = (PlcClauseitemEO)plcClauseIterole.getFixedActual();
                        // Map<String, Object> plcClauseItemPropertyMap =
                        // plcClauseIterole.getProperty();
                        // BeanUtils.copyProperties(plcClauseitemEO,
                        // plcClauseItemPropertyMap);
                        plcClauseitemEOs.add(plcClauseitemEO);
                    }
                }
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlcClauseitemEO error:" + e);
            }
        }
        return plcClauseitemEOs;
    }

    /**
     * @param role
     *            父节点部件
     * @return 集合
     * @Description: 获得保单费用
     * @author xhj
     */
    private List<PlcCostEO> getPlcCosts(Role role) {
        List<PlcCostEO> plcCostEOs = new ArrayList<PlcCostEO>();
        PlcCostEO plcCostEO = null;
        try {
            Object plcCostOb = convertChildRole(role, ReservedRoleKind.plcCost.name());
            if (plcCostOb != null) {
                if (plcCostOb instanceof Role) {
                    plcCostEO = new PlcCostEO();
                    Role plcCostRole = (Role) plcCostOb;
                    Map<String, Object> plcCostPropertyMap = plcCostRole.getProperty();
                    BeanUtils.copyProperties(plcCostEO, plcCostPropertyMap);
                    plcCostEOs.add(plcCostEO);
                } else if (plcCostOb instanceof Collection) {
                    List<Role> plcCostRoleList = (List<Role>) plcCostOb;
                    for (Role plcCostIterole : plcCostRoleList) {
                        plcCostEO = new PlcCostEO();
                        Map<String, Object> plcCostPropertyMap = plcCostIterole.getProperty();
                        BeanUtils.copyProperties(plcCostEO, plcCostPropertyMap);
                        plcCostEOs.add(plcCostEO);
                    }
                }
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlcCostEO error:" + e);
            }
        }
        return plcCostEOs;
    }

    /**
     * @param role
     *            父节点部件
     * @return 集合
     * @Description: 获得批改费用
     * @author xhj
     */
    private List<PlpCostEO> getPlpCosts(Role role) {
        List<PlpCostEO> plpCostEOs = new ArrayList<PlpCostEO>();
        PlpCostEO plpCostEO = null;
        try {
            Object plpCostOb = convertChildRole(role, ReservedRoleKind.plpCost.name());
            if (plpCostOb != null) {
                if (plpCostOb instanceof Role) {
                    Role plpCostRole = (Role) plpCostOb;
                    plpCostEO = (PlpCostEO) plpCostRole.getFixedActual();
                    // Map<String, Object> plpCostPropertyMap =
                    // plpCostRole.getProperty();
                    // BeanUtils.copyProperties(plpCostEO, plpCostPropertyMap);
                    plpCostEOs.add(plpCostEO);
                } else if (plpCostOb instanceof Collection) {
                    List<Role> plpCostRoleList = (List<Role>) plpCostOb;
                    for (Role plpCostIterole : plpCostRoleList) {
                        plpCostEO = (PlpCostEO) plpCostIterole.getFixedActual();
                        // Map<String, Object> plpCostPropertyMap =
                        // plpCostIterole.getProperty();
                        // BeanUtils.copyProperties(plpCostEO,
                        // plpCostPropertyMap);
                        plpCostEOs.add(plpCostEO);
                    }
                }
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlpCostEO error:" + e);
            }
        }
        return plpCostEOs;
    }

    /**
     * @param role
     *            父节点role
     * @return 集合
     * @Description: 获得附加条款信息
     * @author xhj
     */
    private List<PlcClauseEO> getPlcAccessoryClauseEOs(Role role) {
        List<PlcClauseEO> plcAccessoryClauseEOs = new ArrayList<PlcClauseEO>();
        PlcClauseEO plcAccessoryClauseEO = null;
        StringBuffer sf = new StringBuffer();
        Object plcAccessoryClauseOb = convertChildRole(role, ReservedRoleKind.plcAccessoryClause.name());
        try {
            if (plcAccessoryClauseOb != null) {
                if (plcAccessoryClauseOb instanceof Role) {
                    Role plcAccessoryClauseRole = (Role) plcAccessoryClauseOb;
                    plcAccessoryClauseEO = (PlcClauseEO) plcAccessoryClauseRole.getFixedActual();
                    // Map<String, Object> plcAccessoryClausePropertyMap =
                    // plcAccessoryClauseRole.getProperty();
                    // BeanUtils.copyProperties(plcAccessoryClauseEO,
                    // plcAccessoryClausePropertyMap);

                    if (plcAccessoryClauseEO != null) {
                        String clauseName = plcAccessoryClauseEO.getClauseName();
                        if (StringUtils.isNotBlank(clauseName)) {
                            sf.append("《").append(clauseName).append("》");
                            plcAccessoryClauseEO.setAccessoryClauseName(sf.toString());
                        }
                    }

                    List<PlcClauseitemEO> plcClauseItems = getPlcClauseItems(plcAccessoryClauseRole);
                    if (!plcClauseItems.isEmpty()) {
                        plcAccessoryClauseEO.setPlcClauseitemEOs(plcClauseItems);
                    }
                    plcAccessoryClauseEOs.add(plcAccessoryClauseEO);
                } else if (plcAccessoryClauseOb instanceof Collection) {
                    List<Role> plcAccessoryClauseRoleList = (List<Role>) plcAccessoryClauseOb;
                    for (Role plcAccessoryClauseRole : plcAccessoryClauseRoleList) {
                        plcAccessoryClauseEO = (PlcClauseEO) plcAccessoryClauseRole.getFixedActual();
                        // Map<String, Object> plcAccessoryClausePropertyMap =
                        // plcAccessoryClauseRole.getProperty();
                        // BeanUtils.copyProperties(plcAccessoryClauseEO,
                        // plcAccessoryClausePropertyMap);

                        if (plcAccessoryClauseEO != null) {
                            String clauseName = plcAccessoryClauseEO.getClauseName();
                            if (StringUtils.isNotBlank(clauseName)) {
                                sf.append("《").append(clauseName).append("》    ");
                            }
                        }

                        List<PlcClauseitemEO> plcClauseItems = getPlcClauseItems(plcAccessoryClauseRole);
                        if (!plcClauseItems.isEmpty()) {
                            plcAccessoryClauseEO.setPlcClauseitemEOs(plcClauseItems);
                        }
                        plcAccessoryClauseEOs.add(plcAccessoryClauseEO);
                    }
                    for (PlcClauseEO plcAccessoryClause : plcAccessoryClauseEOs) {
                        if (StringUtils.isNoneBlank(sf)) {
                            plcAccessoryClause.setAccessoryClauseName(sf.toString());
                        }
                    }
                }
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlcClauseEO error:" + e);
            }
        }
        return plcAccessoryClauseEOs;
    }

    /**
     * @param role
     *            父节点role
     * @return 集合
     * @Description: 获得主条款信息
     * @author xhj
     */
    private List<PlcClauseEO> getPlcMainCaluses(Role role) {
        List<PlcClauseEO> plcMainClauseEOs = new ArrayList<PlcClauseEO>();
        PlcClauseEO plcMainClauseEO = null;
        StringBuffer sf = new StringBuffer();
        StringBuffer str = new StringBuffer();
        try {
            Object plcMainClauseOb = convertChildRole(role, ReservedRoleKind.plcMainClause.name());
            // 主条款信息不为空，把数据放到plcPackageEO中
            if (plcMainClauseOb != null) {
                if (plcMainClauseOb instanceof Role) {
                    Role plcMainClauseRole = (Role) plcMainClauseOb;
                    plcMainClauseEO = (PlcClauseEO) plcMainClauseRole.getFixedActual();
                    // Map<String, Object> plcClausePropertyMap =
                    // plcMainClauseRole.getProperty();
                    // BeanUtils.copyProperties(plcMainClauseEO,
                    // plcClausePropertyMap);// 拿到部件下的property
                    if (plcMainClauseEO != null) {
                        String clauseName = plcMainClauseEO.getClauseName();
                        if (StringUtils.isNotBlank(clauseName)) {
                            sf.append("《").append(clauseName).append("》");
                            plcMainClauseEO.setMainClauseName(sf.toString());
                        }
                    }

                    // 拿主条款下的部件
                    // 条责标信息部件
                    List<PlcClauseitemEO> plcClauseItems = getPlcClauseItems(plcMainClauseRole);
                    if (!plcClauseItems.isEmpty()) {
                        plcMainClauseEO.setPlcClauseitemEOs(plcClauseItems);
                    }
                    // 附加条款信息部件
                    List<PlcClauseEO> plcAccessoryClauseEOs = getPlcAccessoryClauseEOs(plcMainClauseRole);
                    if (!plcAccessoryClauseEOs.isEmpty()) {
                        str.append(plcAccessoryClauseEOs.get(0).getAccessoryClauseName());
                        if (StringUtils.isNotBlank(str)) {
                            plcMainClauseEO.setAccessoryClauseName(str.toString());
                        }
                        plcMainClauseEO.setPlcAccessoryClauseEO(plcAccessoryClauseEOs);
                    }
                    plcMainClauseEOs.add(plcMainClauseEO);
                } else if (plcMainClauseOb instanceof Collection) {
                    List<Role> plcMainClauseList = (List<Role>) plcMainClauseOb;
                    for (Role plcMainClauseRole : plcMainClauseList) {
                        plcMainClauseEO = (PlcClauseEO) plcMainClauseRole.getFixedActual();
                        // Map<String, Object> plcClausePropertyMap =
                        // plcMainClauseRole.getProperty();
                        // BeanUtils.copyProperties(plcMainClauseEO,
                        // plcClausePropertyMap);

                        if (plcMainClauseEO != null) {
                            String clauseName = plcMainClauseEO.getClauseName();
                            if (StringUtils.isNotBlank(clauseName)) {
                                sf.append("《").append(clauseName).append("》    ");
                            }
                        }
                        // 拿主条款下的部件
                        // 条责标信息部件
                        List<PlcClauseitemEO> plcClauseItems = getPlcClauseItems(plcMainClauseRole);
                        if (!plcClauseItems.isEmpty()) {
                            plcMainClauseEO.setPlcClauseitemEOs(plcClauseItems);
                        }
                        // 附加条款信息部件
                        List<PlcClauseEO> plcAccessoryClauseEOs = getPlcAccessoryClauseEOs(plcMainClauseRole);
                        if (!plcAccessoryClauseEOs.isEmpty()) {
                            str.append(plcAccessoryClauseEOs.get(0).getAccessoryClauseName());
                            plcMainClauseEO.setPlcAccessoryClauseEO(plcAccessoryClauseEOs);
                        }
                        plcMainClauseEOs.add(plcMainClauseEO);
                    }
                    for (PlcClauseEO plcMainClause : plcMainClauseEOs) {
                        if (StringUtils.isNoneBlank(sf)) {
                            plcMainClause.setMainClauseName(sf.toString());
                        }
                        if (StringUtils.isNoneBlank(str)) {
                            plcMainClause.setAccessoryClauseName(str.toString());
                        }
                    }
                }
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlcClauseEO error:" + e);
            }
        }
        return plcMainClauseEOs;
    }

    /**
     * @param role
     *            父节点role
     * @return 集合
     * @Description: 获得销售方案信息
     * @author xhj
     */
    private List<PlcPackageEO> getPlcPackageEOs(Role role) {
        List<PlcPackageEO> plcPackageEOs = new ArrayList<PlcPackageEO>();
        PlcPackageEO plcPackageEO = null;
        try {
            // 获得产品销售方案信息部件
            Object plcPackageOb = convertChildRole(role, ReservedRoleKind.plcPackage.name());
            // 销售方案信息不为空，把数据放到plcSolutionEO中
            if (plcPackageOb != null) {
                if (plcPackageOb instanceof Role) {
                    Role plcPackageRole = (Role) plcPackageOb;
                    plcPackageEO = (PlcPackageEO) plcPackageRole.getFixedActual();
                    // Map<String, Object> plcPackagePropertyMap =
                    // plcPackageRole.getProperty();
                    // BeanUtils.copyProperties(plcPackageEO,
                    // plcPackagePropertyMap);

                    // 获得主条款信息部件
                    List<PlcClauseEO> plcMainCaluses = getPlcMainCaluses(plcPackageRole);
                    if (!plcMainCaluses.isEmpty()) {
                        plcPackageEO.setPlcMainClauseEOs(plcMainCaluses);
                    }
                    plcPackageEOs.add(plcPackageEO);
                } else if (plcPackageOb instanceof Collection) {
                    List<Role> plcPackageRoleList = (List<Role>) plcPackageOb;
                    for (Role plcPackageRole : plcPackageRoleList) {
                        plcPackageEO = (PlcPackageEO) plcPackageRole.getFixedActual();
                        // Map<String, Object> plcPackagePropertyMap =
                        // plcPackageRole.getProperty();
                        // BeanUtils.copyProperties(plcPackageEO,
                        // plcPackagePropertyMap);

                        // 主条款信息不为空，把数据放到plcPackageEO中
                        List<PlcClauseEO> plcMainCaluses = getPlcMainCaluses(plcPackageRole);
                        if (!plcMainCaluses.isEmpty()) {
                            plcPackageEO.setPlcMainClauseEOs(plcMainCaluses);
                        }
                        plcPackageEOs.add(plcPackageEO);
                    }
                }
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlcClauseEO error:" + e);
            }
        }
        return plcPackageEOs;
    }

    /**
     * @param role
     *            父节点role
     * @param kind
     *            路径
     * @return 集合
     * @Description: 获取特约数据集合
     */
    @SuppressWarnings("unused")
    private List<PlcEngageEO> getPlcEngageEOs(Role role, String kind) {

        List<PlcEngageEO> plcEngageEOs = new ArrayList<PlcEngageEO>();
        PlcEngageEO plcEngageEO = null;
        StringBuffer sf = null;
        try {
            // 获得特别约定信息部件
            Object plcEngageOb = convertChildRole(role, ReservedRoleKind.plcEngage.name());
            // 特别约定信息不为空，把数据放到plcSolutionEO中
            if (plcEngageOb != null) {
                if (plcEngageOb instanceof Role) {
                    sf = new StringBuffer();
                    Role plcEngageRole = (Role) plcEngageOb;
                    plcEngageEO = (PlcEngageEO) plcEngageRole.getFixedActual();
                    // Map<String, Object> plcPackagePropertyMap =
                    // plcEngageRole.getProperty();
                    // BeanUtils.copyProperties(plcEngageEO,
                    // plcPackagePropertyMap);
                    String serialNo = plcEngageEO.getSerialNo();
                    String especialClauses = plcEngageEO.getEspecialClauses();
                    if (StringUtils.isNoneBlank(serialNo) && StringUtils.isNoneBlank(especialClauses)) {
                        sf.append(serialNo).append("、").append(especialClauses);
                    }
                    if (StringUtils.isNotBlank(sf)) {
                        plcEngageEO.setEspecialClause(sf.toString());
                    }
                    plcEngageEOs.add(plcEngageEO);
                } else if (plcEngageOb instanceof Collection) {
                    List<Role> plcEngageRoleList = (List<Role>) plcEngageOb;
                    for (Role plcEngageRole : plcEngageRoleList) {
                        plcEngageEO = (PlcEngageEO) plcEngageRole.getFixedActual();
                        // Map<String, Object> plcPackagePropertyMap =
                        // plcEngageRole.getProperty();
                        // BeanUtils.copyProperties(plcEngageEO,
                        // plcPackagePropertyMap);
                        String serialNo = plcEngageEO.getSerialNo();
                        String especialClauses = plcEngageEO.getEspecialClauses();
                        if (StringUtils.isNoneBlank(serialNo) && StringUtils.isNoneBlank(especialClauses)) {
                            sf.append(serialNo).append("、").append(especialClauses);
                        }
                        if (StringUtils.isNotBlank(sf)) {
                            plcEngageEO.setEspecialClause(sf.toString());
                        }
                        plcEngageEOs.add(plcEngageEO);
                    }
                    for (PlcEngageEO plcEngage : plcEngageEOs) {
                        if (StringUtils.isNotBlank(sf)) {
                            plcEngageEO.setEspecialClause(sf.toString());
                        }
                    }
                }
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlcClauseEO error:" + e);
            }
        }
        return plcEngageEOs;
    }

    /**
     * @return List<PlpEndorsecommissionEO>
     * @Description: 获取批改明细信息
     */
    public List<PlpEndorsecommissionEO> getPlpEndorsecommissionList() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlpEndorsecommissionEO> resultList = new ArrayList<>();
        // 获取批改信息role的路径
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plpEndorse.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return resultList;
        }
        List<Role> rose = (List<Role>) o;
        if (rose.size() <= 0) {
            return resultList;
        }
        Role r = rose.get(0);
        try {
            Object plpEndorsecontentObj = r
                    .find(StartPosition.R.name() + ":" + ReservedRoleKind.plpEndorseCommission.name());
            if (plpEndorsecontentObj == null) {
                return resultList;
            }
            List<Role> roleList = (List<Role>) plpEndorsecontentObj;
            for (Role rr : roleList) {
                PlpEndorsecommissionEO resultEo = (PlpEndorsecommissionEO) rr.getFixedActual();
                // BeanUtils.copyProperties(resultEo, rr.getProperty());
                resultList.add(resultEo);
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlpEndorsecommissionEO error:" + e);
            }
        }
        return resultList;
    }

    /**
     * @return List<PlpPayeeaccountEO>
     * @Description: 获取保单领款人信息部件
     */
    public List<PlpPayeeaccountEO> getPlpPayeeAccountList() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlpPayeeaccountEO> resultList = new ArrayList<>();
        // 获取批改信息role的路径
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plpEndorse.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return resultList;
        }
        List<Role> rose = (List<Role>) o;
        if (rose.size() <= 0) {
            return resultList;
        }
        Role r = rose.get(0);
        try {
            Object plpEndorsecontentObj = r
                    .find(StartPosition.R.name() + ":" + ReservedRoleKind.plpPayeeAccount.name());
            if (plpEndorsecontentObj == null) {
                return resultList;
            }
            List<Role> roleList = (List<Role>) plpEndorsecontentObj;
            for (Role rr : roleList) {
                PlpPayeeaccountEO resultEo = (PlpPayeeaccountEO) rr.getFixedActual();
                // BeanUtils.copyProperties(resultEo, rr.getProperty());
                resultList.add(resultEo);
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlpPayeeaccountEO error:" + e);
            }
        }
        return resultList;
    }

    /**
     * @return List<PlcAvaProductVO> 返回类型
     * @Title: getAllAvaProductIncludeAcceptPurchaseClauseItemList
     * @Description: 获取协议下的产品信息，包含产品下的承保方案、投保方案、条款、条责标
     */
    public List<PlcAvaProductVO> getAllAvaProductIncludeAcceptPurchaseClauseItemList() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }

        try {
            // 产品集合
            List<PlcAvaProductVO> avaProductList = new ArrayList<PlcAvaProductVO>();

            // 协议下的产品
            List<Role> avaProductRoleList = role.findChildren(Role.class, ReservedRoleKind.plcAvaProduct.name());

            for (Role avaProductRole : avaProductRoleList) {

                // 拷贝协议下产品的属性信息
                PlcAvaProductVO plcAvaProductVO = new PlcAvaProductVO(); // VO不能用getFixedActual
                BeanUtils.copyProperties(plcAvaProductVO, avaProductRole.getFixedActual());

                // 协议下的承保方案
                List<Role> agrAcceptRoleList = avaProductRole.findChildren(Role.class,
                        ReservedRoleKind.plcAgrAccept.name());
                List<PlcAgrAcceptVO> agrAcceptList = new ArrayList<PlcAgrAcceptVO>();
                plcAvaProductVO.setPlcAgrAcceptList(agrAcceptList);

                for (Role agrAcceptRole : agrAcceptRoleList) {

                    // 拷贝协议下的承保方案信息
                    PlcAgrAcceptVO plcAgrAcceptVO = new PlcAgrAcceptVO(); // VO不能用getFixedActual
                    BeanUtils.copyProperties(plcAgrAcceptVO, agrAcceptRole.getFixedActual());

                    agrAcceptList.add(plcAgrAcceptVO);

                    // 协议下的投保方案
                    List<Role> agrPurchaseRoleList = agrAcceptRole.findChildren(Role.class,
                            ReservedRoleKind.plcAgrPurchase.name());
                    List<PlcAgrPurchaseVO> lcAgrPurchaseList = new ArrayList<PlcAgrPurchaseVO>();
                    plcAgrAcceptVO.setPlcAgrPurchaseList(lcAgrPurchaseList);

                    for (Role agrPurchaseRole : agrPurchaseRoleList) {

                        // 拷贝协议下的投保方案信息
                        PlcAgrPurchaseVO plcAgrPurchaseVO = new PlcAgrPurchaseVO();  // VO不能用getFixedActual
                        BeanUtils.copyProperties(plcAgrPurchaseVO, agrPurchaseRole.getFixedActual());

                        lcAgrPurchaseList.add(plcAgrPurchaseVO);

                        // 协议下的主条款
                        List<Role> plcAgrClauseRoleList = agrPurchaseRole.findChildren(Role.class,
                                ReservedRoleKind.plcAgrClause.name());

                        List<PlcAgrClauseVO> plcAgrClauseList = new ArrayList<PlcAgrClauseVO>();
                        plcAgrPurchaseVO.setPlcAgrClauseList(plcAgrClauseList);

                        for (Role agrClause : plcAgrClauseRoleList) {

                            PlcAgrClauseVO plcAgrClause = new PlcAgrClauseVO();  // VO不能用getFixedActual
                            // 协议下主条款信息
                            BeanUtils.copyProperties(plcAgrClause, agrClause.getFixedActual());
                            plcAgrClauseList.add(plcAgrClause);

                            // 协议下的附加条款
                            List<Role> plcAgrAccessaryClauseRoleList = agrClause.findChildren(Role.class,
                                    ReservedRoleKind.plcAgrAccessaryClause.name());

                            List<PlcAgrClauseVO> plcAgrAccessaryClauseList = new ArrayList<PlcAgrClauseVO>();
                            plcAgrClause.setPlcAgrAccessaryClauseList(plcAgrAccessaryClauseList);

                            for (Role plcAgrAccessaryClauseRole : plcAgrAccessaryClauseRoleList) {
                                // 拷贝协议下附加条款信息
                                PlcAgrClauseVO plcAgrAccessaryClauseVO = new PlcAgrClauseVO();  // VO不能用getFixedActual
                                BeanUtils.copyProperties(plcAgrAccessaryClauseVO,plcAgrAccessaryClauseRole.getProperty());
                                plcAgrAccessaryClauseList.add(plcAgrAccessaryClauseVO);

                                List<Role> plcAgrClauseItemRoleList = plcAgrAccessaryClauseRole.findChildren(Role.class,
                                        ReservedRoleKind.plcAgrClauseItem.name());

                                List<PlcAgrClauseItemVO> plcAgrClauseItemList = new ArrayList<PlcAgrClauseItemVO>();
                                plcAgrAccessaryClauseVO.setPlcAgrClauseItemList(plcAgrClauseItemList);

                                for (Role r : plcAgrClauseItemRoleList) {

                                    // 拷贝附加条款下的条责表信息
                                    PlcAgrClauseItemVO plcAgrClauseItemVO = new PlcAgrClauseItemVO();  // VO不能用getFixedActual
                                    BeanUtils.copyProperties(plcAgrClauseItemVO, r.getFixedActual());
                                    plcAgrClauseItemList.add(plcAgrClauseItemVO);
                                }

                            }
                            List<PlcAgrClauseItemVO> plcAgrClauseItemList = new ArrayList<PlcAgrClauseItemVO>();
                            plcAgrClause.setPlcAgrClauseItemList(plcAgrClauseItemList);

                            List<Role> plcAgrClauseItemRoleList = agrClause.findChildren(Role.class,
                                    ReservedRoleKind.plcAgrClauseItem.name());

                            for (Role r : plcAgrClauseItemRoleList) {

                                // 拷贝主条款下的条责标信息
                                PlcAgrClauseItemVO plcAgrClauseItemVO = new PlcAgrClauseItemVO(); // VO不能用getFixedActual
                                BeanUtils.copyProperties(plcAgrClauseItemVO, r.getFixedActual());
                                plcAgrClauseItemList.add(plcAgrClauseItemVO);
                            }
                        }
                    }
                }
                avaProductList.add(plcAvaProductVO);
            }
            Collections.sort(avaProductList);
            return avaProductList;

        } catch (Exception ex) {

            if (logger.isErrorEnabled()) {
                logger.error("获取协议下产品信息失败", ex);
            }
            return null;
        }
    }


    /**
     * @return List<PlcAvaProductVO> 返回类型
     * @Title: getAllAvaProductIncludeAcceptPurchaseClauseItemList
     * @Description: 获取产品下的产品信息，包含产品下的承保方案、投保方案、条款、条责标
     */
    public List<PlcAvaProductVO> getAllProductIncludeSolutionList() {
        Role role = bs.getRole();
        List<Role> actualRoleList = new ArrayList<Role>();
        actualRoleList.add(role);
        if (role == null) {
            return null;
        }
        try {
            // 产品集合
            List<PlcAvaProductVO> avaProductList = new ArrayList<PlcAvaProductVO>();
            // 产品
            for (Role actualRole : actualRoleList) {
                // 拷贝协议下产品的属性信息
                PlcAvaProductVO plcAvaProductVO = new PlcAvaProductVO(); // VO不能用getFixedActual
                BeanUtils.copyProperties(plcAvaProductVO, actualRole.getFixedActual());
                // 协议下的承保方案
                List<Role> plcSolutionRoleList = actualRole.findChildren(Role.class,
                        ReservedRoleKind.plcSolution.name());
                List<PlcAgrAcceptVO> agrAcceptList = new ArrayList<PlcAgrAcceptVO>();
                plcAvaProductVO.setPlcAgrAcceptList(agrAcceptList);
                for (Role plcSolutionRole : plcSolutionRoleList) {
                    // 拷贝协议下的承保方案信息
                    PlcAgrAcceptVO plcAgrAcceptVO = new PlcAgrAcceptVO(); // VO不能用getFixedActual
                    BeanUtils.copyProperties(plcAgrAcceptVO, plcSolutionRole.getFixedActual());
                    agrAcceptList.add(plcAgrAcceptVO);
                    // 协议下的投保方案
                    List<Role> plcPackageRoleList = plcSolutionRole.findChildren(Role.class,
                            ReservedRoleKind.plcPackage.name());
                    List<PlcAgrPurchaseVO> lcAgrPurchaseList = new ArrayList<PlcAgrPurchaseVO>();
                    plcAgrAcceptVO.setPlcAgrPurchaseList(lcAgrPurchaseList);
                    for (Role plcPackageRole : plcPackageRoleList) {
                        // 拷贝协议下的投保方案信息
                        PlcAgrPurchaseVO plcAgrPurchaseVO = new PlcAgrPurchaseVO();  // VO不能用getFixedActual
                        BeanUtils.copyProperties(plcAgrPurchaseVO, plcPackageRole.getFixedActual());
                        lcAgrPurchaseList.add(plcAgrPurchaseVO);
                        // 协议下的主条款
                        List<Role> plcMainClauseRoleList = plcPackageRole.findChildren(Role.class,
                                ReservedRoleKind.plcMainClause.name());
                        List<PlcAgrClauseVO> plcAgrClauseList = new ArrayList<PlcAgrClauseVO>();
                        plcAgrPurchaseVO.setPlcAgrClauseList(plcAgrClauseList);
                        for (Role plcMainClause : plcMainClauseRoleList) {
                            PlcAgrClauseVO plcAgrClause = new PlcAgrClauseVO();  // VO不能用getFixedActual
                            // 协议下主条款信息
                            BeanUtils.copyProperties(plcAgrClause, plcMainClause.getFixedActual());
                            plcAgrClauseList.add(plcAgrClause);
                            // 协议下的附加条款
                            List<Role> plcAccessoryClauseRoleList = plcMainClause.findChildren(Role.class,
                                    ReservedRoleKind.plcAccessoryClause.name());
                            List<PlcAgrClauseVO> plcAgrAccessaryClauseList = new ArrayList<PlcAgrClauseVO>();
                            plcAgrClause.setPlcAgrAccessaryClauseList(plcAgrAccessaryClauseList);
                            for (Role plcAccessoryClauseRole : plcAccessoryClauseRoleList) {
                                // 拷贝协议下附加条款信息
                                PlcAgrClauseVO plcAgrAccessaryClauseVO = new PlcAgrClauseVO();  // VO不能用getFixedActual
                                BeanUtils.copyProperties(plcAgrAccessaryClauseVO, plcAccessoryClauseRole.getProperty());
                                plcAgrAccessaryClauseList.add(plcAgrAccessaryClauseVO);
                                List<Role> plcClauseItemRoleList = plcAccessoryClauseRole.findChildren(Role.class,
                                        ReservedRoleKind.plcClauseItem.name());
                                List<PlcAgrClauseItemVO> plcAgrClauseItemList = new ArrayList<PlcAgrClauseItemVO>();
                                plcAgrAccessaryClauseVO.setPlcAgrClauseItemList(plcAgrClauseItemList);
                                for (Role r : plcClauseItemRoleList) {

                                    // 拷贝附加条款下的条责表信息
                                    PlcAgrClauseItemVO plcAgrClauseItemVO = new PlcAgrClauseItemVO();  // VO不能用getFixedActual
                                    BeanUtils.copyProperties(plcAgrClauseItemVO, r.getFixedActual());
                                    plcAgrClauseItemList.add(plcAgrClauseItemVO);
                                }
                            }
                            List<PlcAgrClauseItemVO> plcAgrClauseItemList = new ArrayList<PlcAgrClauseItemVO>();
                            plcAgrClause.setPlcAgrClauseItemList(plcAgrClauseItemList);
                            List<Role> plcMainClauseAccessoryClauseRoleList = plcMainClause.findChildren(Role.class,
                                    ReservedRoleKind.plcAccessoryClause.name());
                            for (Role r : plcMainClauseAccessoryClauseRoleList) {
                                // 拷贝主条款下的条责标信息
                                PlcAgrClauseItemVO plcAgrClauseItemVO = new PlcAgrClauseItemVO(); // VO不能用getFixedActual
                                BeanUtils.copyProperties(plcAgrClauseItemVO, r.getFixedActual());
                                plcAgrClauseItemList.add(plcAgrClauseItemVO);
                            }
                        }
                    }
                }
                avaProductList.add(plcAvaProductVO);
            }
            Collections.sort(avaProductList);
            return avaProductList;
        } catch (Exception ex) {
            if (logger.isErrorEnabled()) {
                logger.error("获取产品信息失败", ex);
            }
            return null;
        }
    }

    /**
     * @param role
     *            父部件
     * @param kind
     *            子部件路径
     * @return 子部件对象
     * @Description: 拿子部件
     */
    public Object convertChildRole(Role role, String kind) {
        Object v = null;
        Map<String, Object> childRoleMap = role.findChildrenRole();
        for (Entry<String, Object> entry : childRoleMap.entrySet()) {
            if (entry.getKey().equalsIgnoreCase(kind)) {
                v = entry.getValue();
            }
        }
        return v;
    }

    /**
     * @return plcClauseList
     *
     * @Description: 获取系数信息
     */
    @SuppressWarnings({ "unchecked" })
    public PlcRationEO getPlcRation() {
        Role role = bs.getRole();
        PlcRationEO plcRation = new PlcRationEO();
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcSolution.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return null;
        }
        if (!(o instanceof Collection)) {
            return null;
        }
        try {
            List<Role> plcSolutionRoleList = (List<Role>) o;
            for (Role plcSolutionRole : plcSolutionRoleList) {
                Object plcRationObj = plcSolutionRole
                        .find(StartPosition.R.name() + ":" + ReservedRoleKind.PlcRation.name());
                Role plcRationRole = null;
                if (plcRationObj == null) {
                    return null;
                }
                if (plcRationObj instanceof Role) {
                    plcRationRole = (Role) plcRationObj;
                } else if (plcRationObj instanceof Collection) {
                    List<Role> plcRationRoleList = (List<Role>) plcRationObj;
                    plcRationRole = plcRationRoleList.get(0);
                }
                PlcRationEO plcRationEO = (PlcRationEO) plcRationRole.getFixedActual();
                // BeanUtils.copyProperties(plcRationEO,
                // plcRationRole.getProperty());
                plcRation = plcRationEO;
                break;
            }
        } catch (Exception ex) {
            logger.error("format property to plcRationEO error");
            return null;
        }
        return plcRation;
    }

    /**
     * 
     * @Description: 获取车辆标信息
     * @return 车辆信息
     *
     */
    public PlcCarEO getPlcCar05() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcCar05.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);

        Role plcCarRole = null;

        if (o instanceof Role) {
            plcCarRole = (Role) o;

        } else if (o instanceof Collection) {
            List<Role> plcCarRoleList = (List<Role>) o;
            if (plcCarRoleList != null && plcCarRoleList.size() > 0) {
                plcCarRole = plcCarRoleList.get(0);
            }
        }
        try {
            if (null == plcCarRole) {
                return null;
            }
            PlcCarEO plcCarEO = (PlcCarEO) plcCarRole.getFixedActual();
            // BeanUtils.copyProperties(plcCarEO, plcCarRole.getProperty());
            return plcCarEO;
        } catch (Exception ex) {
            logger.error("format property to PlcCarEO error");
            return null;
        }
    }

    /**
     * 
     * @Description: 获取车船税信息
     * @return 车船税信息
     *
     */
    public PlcCarShipTaxEO getPlcCarShipTax() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcCarShipTax.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);

        Role plcCarShipTaxRole = null;

        if (o instanceof Role) {
            plcCarShipTaxRole = (Role) o;

        } else if (o instanceof Collection) {
            List<Role> plcCarShipTaxRoleList = (List<Role>) o;
            if (plcCarShipTaxRoleList == null || plcCarShipTaxRoleList.isEmpty()) {
                return null; /// 商业险时无车船税信息
            }
            plcCarShipTaxRole = plcCarShipTaxRoleList.get(0);
        }
        try {
            PlcCarShipTaxEO plcCarShipTax = (PlcCarShipTaxEO) plcCarShipTaxRole.getFixedActual();
            // BeanUtils.copyProperties(plcCarShipTax,
            // plcCarShipTaxRole.getProperty());
            return plcCarShipTax;
        } catch (Exception ex) {
            logger.error("format property to PlcCarShipTaxEO error");
            return null;
        }
    }

    /**
     * 获取车主信息（车险用）
     * 
     * @Description: 获取车主信息
     * @return 车主信息
     */
    public List<PlcInsurantEO> getPlcCarowners() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlcInsurantEO> plcInsurantEOs = new ArrayList<PlcInsurantEO>();
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcCarowners.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        try {
            plcInsurantRoleMap = new ConcurrentHashMap<>();
            List<PlcCustomerEO> plcCustomerEOs = new ArrayList<PlcCustomerEO>();
            List<PlcGrpcustomerEO> plcGrpcustomerEOs = new ArrayList<PlcGrpcustomerEO>();
            if (o instanceof Role) {
                Role actRole = (Role) o;
                // Map<String, Object> propertyMap = actRole.getProperty();
                PlcInsurantEO plcInsurantEO = (PlcInsurantEO) actRole.getFixedActual();
                // BeanUtils.copyProperties(plcInsurantEO, propertyMap);
                String plcInsurantRoleMapKey = new StringBuilder().append(plcInsurantEO.getCustomerName()).append("_")
                        .append(plcInsurantEO.getIdentifyType()).append("_").append(plcInsurantEO.getIdentifyNumber())
                        .toString();
                plcInsurantRoleMap.put(plcInsurantRoleMapKey, actRole);
                Object plcCustomerOb = convertChildRoleToObject(actRole, ReservedRoleKind.plcCustomer.name(),
                        PlcCustomerEO.class);
                plcCustomerEOs.add(plcCustomerOb == null ? null : (PlcCustomerEO) plcCustomerOb);
                plcInsurantEO.setPlcCustomerEOs(plcCustomerEOs);
                Object plcGrpcustomerOb = convertChildRoleToObject(actRole, ReservedRoleKind.plcGrpCustomer.name(),
                        PlcGrpcustomerEO.class);
                plcGrpcustomerEOs.add(plcGrpcustomerOb == null ? null : (PlcGrpcustomerEO) plcGrpcustomerOb);
                plcInsurantEO.setPlcGrpcustomerEOs(plcGrpcustomerEOs);
                plcInsurantEOs.add(plcInsurantEO);

            } else if (o instanceof Collection) {

                List<Role> roleList = (List<Role>) o;

                for (Role r : roleList) {
                    // Map<String, Object> propertyMap = r.getProperty();
                    PlcInsurantEO plcInsurantEO = (PlcInsurantEO) r.getFixedActual();
                    // BeanUtils.copyProperties(plcInsurantEO, propertyMap);
                    String plcInsurantRoleMapKey = new StringBuilder().append(plcInsurantEO.getCustomerName())
                            .append("_").append(plcInsurantEO.getIdentifyType()).append("_")
                            .append(plcInsurantEO.getIdentifyNumber()).toString();
                    plcInsurantRoleMap.put(plcInsurantRoleMapKey, r);
                    Object plcCustomerOb = convertChildRoleToObject(r, ReservedRoleKind.plcCustomer.name(),
                            PlcCustomerEO.class);
                    plcCustomerEOs.add(plcCustomerOb == null ? null : (PlcCustomerEO) plcCustomerOb);
                    plcInsurantEO.setPlcCustomerEOs(plcCustomerEOs);

                    Object plcGrpcustomerOb = convertChildRoleToObject(r, ReservedRoleKind.plcGrpCustomer.name(),
                            PlcGrpcustomerEO.class);
                    plcGrpcustomerEOs.add(plcGrpcustomerOb == null ? null : (PlcGrpcustomerEO) plcGrpcustomerOb);
                    plcInsurantEO.setPlcGrpcustomerEOs(plcGrpcustomerEOs);
                    plcInsurantEOs.add(plcInsurantEO);
                }

            }
        } catch (Exception ex) {
            logger.error("format property to PlcInsurants error");
        }
        return plcInsurantEOs;
    }

    /**
     * @return plcDevice
     *
     * @Description: 获取新增设备标的信息
     */
    @SuppressWarnings({ "unchecked" })
    public List<PlcDeviceEO> getPlcDevice() {
        List<PlcDeviceEO> plcDeviceEOList = new ArrayList<PlcDeviceEO>();
        Role role = bs.getRole();
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcDevice.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return null;
        }
        if (!(o instanceof Collection)) {
            return null;
        }
        try {
            List<Role> plcDeviceRoleList = (List<Role>) o;
            for (Role plcDeviceRole : plcDeviceRoleList) {
                /*
                 * Object plcDeviceObj = plcMainRole
                 * .find(StartPosition.R.name() + ":" +
                 * ReservedRoleKind.plcDevice.name()); Role plcDeviceRole =
                 * null; if (plcDeviceObj == null) { return null; } if
                 * (plcDeviceObj instanceof Role) { plcDeviceRole = (Role)
                 * plcDeviceObj; } else if (plcDeviceObj instanceof Collection)
                 * { List<Role> plcDeviceObjList = (List<Role>) plcDeviceObj;
                 * plcDeviceRole = plcDeviceObjList.get(0); }
                 */
                PlcDeviceEO plcDeviceEO = (PlcDeviceEO) plcDeviceRole.getFixedActual();
                // BeanUtils.copyProperties(plcDeviceEO,
                // plcDeviceRole.getProperty());
                plcDeviceEOList.add(plcDeviceEO);
            }
        } catch (Exception ex) {
            logger.error("format property to plcDeviceEO error");
            return null;
        }
        return plcDeviceEOList;
    }

    public BusinessEntity getBs() {
        return bs;
    }

    public Map<String, Role> getPlcCoinsRoleMap() {
        return plcCoinsRoleMap;
    }

    public void setPlcCoinsRoleMap(Map<String, Role> plcCoinsRoleMap) {
        this.plcCoinsRoleMap = plcCoinsRoleMap;
    }

    public Map<String, Role> getPlcApplicantRoleMap() {
        return plcApplicantRoleMap;
    }

    public void setPlcApplicantRoleMap(Map<String, Role> plcApplicantRoleMap) {
        this.plcApplicantRoleMap = plcApplicantRoleMap;
    }

    public Map<String, Role> getPlcInsurantRoleMap() {
        return plcInsurantRoleMap;
    }

    public void setPlcInsurantRoleMap(Map<String, Role> plcInsurantRoleMap) {
        this.plcInsurantRoleMap = plcInsurantRoleMap;
    }

    /**
     * 条款的内部信息类
     *
     * @author slj
     */
    public class ClauseItemInfo implements Serializable {

        /**
         * @Fields serialVersionUID
         */
        private static final long serialVersionUID = -1334526674300153397L;

        /**
         * 险别个数
         */
        private Integer clauseNumber = 0;

        /**
         * 主险险别个数
         */
        private Integer mainClauseNumber = 0;

        /**
         * 附加险险别个数
         */
        private Integer accessoryClauseNumber = 0;

        /**
         * 主险总保额
         */
        private BigDecimal mainTotalAmount = BigDecimal.ZERO;

        /**
         * 主险总保费
         */
        private BigDecimal mainTotalPremium = BigDecimal.ZERO;

        /**
         * 附加险总保额
         */
        private BigDecimal accessoryTotalAmount = BigDecimal.ZERO;

        /**
         * 主险总每人保额
         */
        private BigDecimal mainTotalUnitAmount = BigDecimal.ZERO;

        /**
         * 附加险总每人保额
         */
        private BigDecimal accessoryTotalUnitAmount = BigDecimal.ZERO;

        public Integer getClauseNumber() {
            return clauseNumber;
        }

        public void setClauseNumber(Integer clauseNumber) {
            this.clauseNumber = clauseNumber;
        }

        public Integer getMainClauseNumber() {
            return mainClauseNumber;
        }

        public void setMainClauseNumber(Integer mainClauseNumber) {
            this.mainClauseNumber = mainClauseNumber;
        }

        public Integer getAccessoryClauseNumber() {
            return accessoryClauseNumber;
        }

        public void setAccessoryClauseNumber(Integer accessoryClauseNumber) {
            this.accessoryClauseNumber = accessoryClauseNumber;
        }

        public BigDecimal getMainTotalAmount() {
            return mainTotalAmount;
        }

        public BigDecimal getMainTotalPremium() {
            return mainTotalPremium;
        }

        public void setMainTotalPremium(BigDecimal mainTotalPremium) {
            this.mainTotalPremium = mainTotalPremium;
        }

        public void setMainTotalAmount(BigDecimal mainTotalAmount) {
            this.mainTotalAmount = mainTotalAmount;
        }

        public BigDecimal getAccessoryTotalAmount() {
            return accessoryTotalAmount;
        }

        public void setAccessoryTotalAmount(BigDecimal accessoryTotalAmount) {
            this.accessoryTotalAmount = accessoryTotalAmount;
        }

        public BigDecimal getMainTotalUnitAmount() {
            return mainTotalUnitAmount;
        }

        public void setMainTotalUnitAmount(BigDecimal mainTotalUnitAmount) {
            this.mainTotalUnitAmount = mainTotalUnitAmount;
        }

        public BigDecimal getAccessoryTotalUnitAmount() {
            return accessoryTotalUnitAmount;
        }

        public void setAccessoryTotalUnitAmount(BigDecimal accessoryTotalUnitAmount) {
            this.accessoryTotalUnitAmount = accessoryTotalUnitAmount;
        }
    }

    /**
     * 获取条款信息
     *
     * @return clauseItemInfo
     */
    public ClauseItemInfo getClauseItemInfo() {
        this.getPlcClauseItem();
        return clauseItemInfo;
    }

    public void setClauseItemInfo(ClauseItemInfo clauseItemInfo) {
        this.clauseItemInfo = clauseItemInfo;
    }

    public Map<String, Role> getPlcPlanRoleMap() {
        return plcPlanRoleMap;
    }

    public void setPlcPlanRoleMap(Map<String, Role> plcPlanRoleMap) {
        this.plcPlanRoleMap = plcPlanRoleMap;
    }

    /**
     * @return 被保险人|投保人|受益人|团单下拿这些Role的数据
     */
    public PlcInsurantEO getPlcInsurantOfGroup() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        PlcInsurantEO plcInsurantEO = new PlcInsurantEO();
        try {
            plcInsurantRoleMap = new ConcurrentHashMap<>();
            List<PlcCustomerEO> plcCustomerEOs = new ArrayList<PlcCustomerEO>();
            List<PlcGrpcustomerEO> plcGrpcustomerEOs = new ArrayList<PlcGrpcustomerEO>();
            List<PlcClauseitemEO> plcClauseItem = new ArrayList<PlcClauseitemEO>();
            plcInsurantEO = (PlcInsurantEO) role.getFixedActual();
            // Map<String, Object> propertyMap = role.getProperty();
            // BeanUtils.copyProperties(plcInsurantEO, propertyMap);
            String plcInsurantRoleMapKey = new StringBuilder().append(plcInsurantEO.getCustomerName()).append("_")
                    .append(plcInsurantEO.getIdentifyType()).append("_").append(plcInsurantEO.getIdentifyNumber())
                    .toString();
            plcInsurantRoleMap.put(plcInsurantRoleMapKey, role);
            Object plcCustomerOb = convertChildRoleToObject(role, ReservedRoleKind.plcCustomer.name(),
                    PlcCustomerEO.class);
            plcCustomerEOs.add(plcCustomerOb == null ? null : (PlcCustomerEO) plcCustomerOb);
            plcInsurantEO.setPlcCustomerEOs(plcCustomerEOs);

            Object plcGrpcustomerOb = convertChildRoleToObject(role, ReservedRoleKind.plcGrpCustomer.name(),
                    PlcGrpcustomerEO.class);
            plcGrpcustomerEOs.add(plcGrpcustomerOb == null ? null : (PlcGrpcustomerEO) plcGrpcustomerOb);
            plcInsurantEO.setPlcGrpcustomerEOs(plcGrpcustomerEOs);

            Object plcClauseItemOb = convertChildRoleToObject(role, ReservedRoleKind.plcClauseItem.name(),
                    PlcClauseitemEO.class);
            if (plcClauseItemOb instanceof Collection) {
                plcClauseItem.addAll(plcClauseItemOb == null ? null : (List) plcClauseItemOb);
            } else {
                plcClauseItem.add((PlcClauseitemEO) plcClauseItemOb);
            }
            plcInsurantEO.setPlcClauseItems(plcClauseItem);

        } catch (Exception ex) {
            logger.error("format property to PlcInsurants error");
        }
        return plcInsurantEO;
    }

    /**
     * @return PlcAgrConfigurationEO
     */
    public PlcAgrConfigurationEO getPlcAgrConfigurationEO() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        PlcAgrConfigurationEO result = null;
        try {
            result = (PlcAgrConfigurationEO) role.getFixedActual();
            // Map<String, Object> propertyMap = role.getProperty();
            // BeanUtils.copyProperties(result, propertyMap);
            Object plcAgrConfigurationEO = convertChildRoleToObject(role, ReservedRoleKind.plcAgrConfiguration.name(),
                    PlcAgrConfigurationEO.class);
            result = (PlcAgrConfigurationEO) plcAgrConfigurationEO;
        } catch (Exception e) {
            logger.error("format property to PlcAgrConfigurationEO error");
        }

        return result;
    }

    /**
     * 获取被保险人信息
     *
     * @return List<ProductCustomerEntity>
     */
    public List<ProductCustomerEntity> getInsurantListNew() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<ProductCustomerEntity> customerEntityList = new ArrayList<ProductCustomerEntity>();
        Map<String, Object> propertyMap = role.getProperty();
        ProductCustomerEntity productCustomerEntity = new ProductCustomerEntity();
        try {
            BeanUtils.copyProperties(productCustomerEntity, propertyMap);
            Object plcCustomerOb = convertChildRoleToObject(role, ReservedRoleKind.plcCustomer.name(),
                    PlcCustomerEO.class);
            productCustomerEntity.setPlcCustomerEO(plcCustomerOb == null ? null : (PlcCustomerEO) plcCustomerOb);
            Object plcGrpcustomerOb = convertChildRoleToObject(role, ReservedRoleKind.plcGrpCustomer.name(),
                    PlcGrpcustomerEO.class);
            productCustomerEntity
                    .setPlcGrpcustomerEO(plcGrpcustomerOb == null ? null : (PlcGrpcustomerEO) plcGrpcustomerOb);
            customerEntityList.add(productCustomerEntity);
        } catch (Exception e) {
            logger.error("getInsurantListNew error");
        }
        return customerEntityList;
    }

    /**
     * @Fields plcCarRoleMap : 车辆信息的Role的集合
     */
    private Map<String, Role> plcCarRoleMap;

    /**
     * @return 车辆Role团单信息
     */
    public PlcCarEO getPlcCarOfGroup() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        PlcCarEO plcCarEO = new PlcCarEO();
        try {
            plcCarRoleMap = new ConcurrentHashMap<>();
            // car下面没有role了
            plcCarEO = (PlcCarEO) role.getFixedActual();
            // Map<String, Object> propertyMap = role.getProperty();
            // BeanUtils.copyProperties(plcCarEO, propertyMap);
            // 车牌号标识
            String plcCarRoleMapKey = new StringBuilder().append(plcCarEO.getLicensePlateNo()).toString();
            plcCarRoleMap.put(plcCarRoleMapKey, role);

        } catch (Exception ex) {
            logger.error("format property to PlcCars error");
        }

        return plcCarEO;

    }

    /**
     * 获得联供保信息
     *
     * @return 返回联供保基本信息
     */
    public List<PlcCoinsinformationEO> getPlcCoinsInformation() {
        List<PlcCoinsinformationEO> plcCoinsInformations = new ArrayList<PlcCoinsinformationEO>();
        PlcCoinsinformationEO plcCoinsInformationEO;
        Role role = bs.getRole();
        try {
            // 共保信息
            Object o = role.find(StartPosition.R.name() + ":"
                    + ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcCoinsBasicInformation.name()));
            if (o != null) {
                if (o instanceof Role) {
                    Role r = (Role) o;
                    plcCoinsInformationEO = (PlcCoinsinformationEO) r.getFixedActual();
                    // BeanUtils.copyProperties(plcCoinsInformationEO,
                    // r.getProperty());
                    plcCoinsInformations.add(plcCoinsInformationEO);
                }
                if (o instanceof List) {
                    List<Role> actRoles = (List<Role>) o;
                    for (Role role2 : actRoles) {
                        plcCoinsInformationEO = (PlcCoinsinformationEO) role2.getFixedActual();
                        // BeanUtils.copyProperties(plcCoinsInformationEO,
                        // role2.getProperty());
                        plcCoinsInformations.add(plcCoinsInformationEO);
                    }
                }
            }

            // 联保信息
            Object ob = role.find(StartPosition.R.name() + ":"
                    + ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcLinkBasicInformat.name()));
            if (ob != null) {
                if (ob instanceof Role) {
                    Role r = (Role) ob;
                    plcCoinsInformationEO = (PlcCoinsinformationEO) r.getFixedActual();
                    // BeanUtils.copyProperties(plcCoinsInformationEO,
                    // r.getProperty());
                    plcCoinsInformations.add(plcCoinsInformationEO);
                }
                if (ob instanceof List) {
                    List<Role> actRoles = (List<Role>) ob;
                    for (Role role2 : actRoles) {
                        plcCoinsInformationEO = (PlcCoinsinformationEO) role2.getFixedActual();
                        // BeanUtils.copyProperties(plcCoinsInformationEO,
                        // role2.getProperty());
                        plcCoinsInformations.add(plcCoinsInformationEO);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return plcCoinsInformations;
    }

    /**
     * @return commissiondetailList
     * @Description: 车险获取管理费集合
     */
    @SuppressWarnings("unchecked")
    public List<PlcMgCommissiondetailEO> getplcMgCommissiondetails() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlcMgCommissiondetailEO> plcMgCommissiondetailList = new ArrayList<>();
        // 获取报价方案
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcSolution.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return plcMgCommissiondetailList;
        }
        if (!(o instanceof Collection)) {
            return plcMgCommissiondetailList;
        }
        List<Role> plcSolutionList = (List<Role>) o;
        try {
            for (Role plcSolutionRole : plcSolutionList) {
                // 拆分管理费信息
                Object commissiondetailObj = plcSolutionRole.find("R:" + ReservedRoleKind.plcMgCommissiondetail.name());
                if (commissiondetailObj == null) {
                    continue;
                }
                if (commissiondetailObj instanceof Role) {
                    Role actRole = (Role) o;
                    PlcMgCommissiondetailEO commissiondetail = (PlcMgCommissiondetailEO) actRole.getFixedActual();
                    // BeanUtils.populate(commissiondetail,
                    // actRole.getProperty());
                    plcMgCommissiondetailList.add(commissiondetail);
                } else if (commissiondetailObj instanceof Collection) {
                    List<Role> actRoleList = (List<Role>) commissiondetailObj;
                    for (Role r : actRoleList) {
                        PlcMgCommissiondetailEO commissiondetail = (PlcMgCommissiondetailEO) r.getFixedActual();
                        // BeanUtils.populate(commissiondetail,
                        // r.getProperty());
                        plcMgCommissiondetailList.add(commissiondetail);
                    }
                }
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlcCommissiondetailEO error:" + e);
            }
        }
        return plcMgCommissiondetailList;
    }
    
    /**
     * 获取代办人信息（车险用）
     * 
     * @Description: 获取代办人信息
     * @return 代办人信息
     */
    public List<PlcInsurantEO> getPlcProcurator() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<PlcInsurantEO> plcInsurantEOs = new ArrayList<PlcInsurantEO>();
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcProcurator.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        try {
            plcInsurantRoleMap = new ConcurrentHashMap<>();
            List<PlcCustomerEO> plcCustomerEOs = new ArrayList<PlcCustomerEO>();
            List<PlcGrpcustomerEO> plcGrpcustomerEOs = new ArrayList<PlcGrpcustomerEO>();
            if (o instanceof Role) {
                Role actRole = (Role) o;
                // Map<String, Object> propertyMap = actRole.getProperty();
                PlcInsurantEO plcInsurantEO = (PlcInsurantEO) actRole.getFixedActual();
                // BeanUtils.copyProperties(plcInsurantEO, propertyMap);
                String plcInsurantRoleMapKey = new StringBuilder().append(plcInsurantEO.getCustomerName()).append("_")
                        .append(plcInsurantEO.getIdentifyType()).append("_").append(plcInsurantEO.getIdentifyNumber())
                        .toString();
                plcInsurantRoleMap.put(plcInsurantRoleMapKey, actRole);
                Object plcCustomerOb = convertChildRoleToObject(actRole, ReservedRoleKind.plcCustomer.name(),
                        PlcCustomerEO.class);
                plcCustomerEOs.add(plcCustomerOb == null ? null : (PlcCustomerEO) plcCustomerOb);
                plcInsurantEO.setPlcCustomerEOs(plcCustomerEOs);
                Object plcGrpcustomerOb = convertChildRoleToObject(actRole, ReservedRoleKind.plcGrpCustomer.name(),
                        PlcGrpcustomerEO.class);
                plcGrpcustomerEOs.add(plcGrpcustomerOb == null ? null : (PlcGrpcustomerEO) plcGrpcustomerOb);
                plcInsurantEO.setPlcGrpcustomerEOs(plcGrpcustomerEOs);
                plcInsurantEOs.add(plcInsurantEO);

            } else if (o instanceof Collection) {

                List<Role> roleList = (List<Role>) o;

                for (Role r : roleList) {
                    // Map<String, Object> propertyMap = r.getProperty();
                    PlcInsurantEO plcInsurantEO = (PlcInsurantEO) r.getFixedActual();
                    // BeanUtils.copyProperties(plcInsurantEO, propertyMap);
                    String plcInsurantRoleMapKey = new StringBuilder().append(plcInsurantEO.getCustomerName())
                            .append("_").append(plcInsurantEO.getIdentifyType()).append("_")
                            .append(plcInsurantEO.getIdentifyNumber()).toString();
                    plcInsurantRoleMap.put(plcInsurantRoleMapKey, r);
                    Object plcCustomerOb = convertChildRoleToObject(r, ReservedRoleKind.plcCustomer.name(),
                            PlcCustomerEO.class);
                    plcCustomerEOs.add(plcCustomerOb == null ? null : (PlcCustomerEO) plcCustomerOb);
                    plcInsurantEO.setPlcCustomerEOs(plcCustomerEOs);

                    Object plcGrpcustomerOb = convertChildRoleToObject(r, ReservedRoleKind.plcGrpCustomer.name(),
                            PlcGrpcustomerEO.class);
                    plcGrpcustomerEOs.add(plcGrpcustomerOb == null ? null : (PlcGrpcustomerEO) plcGrpcustomerOb);
                    plcInsurantEO.setPlcGrpcustomerEOs(plcGrpcustomerEOs);
                    plcInsurantEOs.add(plcInsurantEO);
                }

            }
        } catch (Exception ex) {
            logger.error("format property to PlcInsurants error");
        }
        return plcInsurantEOs;
    }
    
    
    /**
     * @return resultList
     * @Description: 获取产品销售方案role信息
     */
    @SuppressWarnings("unchecked")
    public List<Role> getPlcPackageRole() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }

        Object plcSolutionObj = role.find(StartPosition.R.name() + ":" + ReservedRoleKind.plcSolution.name());
        List<Role> roleList = (List<Role>) plcSolutionObj;
        List<Role> resultList = new ArrayList<>();
        // 代理方案信息
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcPackage.name());
        Object o = roleList.get(0).find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return resultList;
        }
        if (!(o instanceof Collection)) {
            return resultList;
        }
        List<Role> plcPackageList = (List<Role>) o;
        try {
            for (Role r : plcPackageList) {
                resultList.add(r);
            }
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("format property to PlcAgentplanEO error:" + e);
            }
        }
        return resultList;
    }
    
    /**
     * @return plcClauseList
     * @Description: 获取条款Role
     */
    @SuppressWarnings({ "unchecked" })
    public List<Role> getPlcClauseRoles() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<Role> plcClauseList = new ArrayList<Role>();
        /// 报价方案
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcSolution.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return plcClauseList;
        }
        if (o instanceof Collection) {
            List<Role> roleList = (List<Role>) o;
            for (Role r : roleList) {
                // 承保方案
                Object plcPackageOb = r.find("R:" + ReservedRoleKind.plcPackage.name());

                if (plcPackageOb == null) {
                    continue;
                }
                if (plcPackageOb instanceof Collection) {

                    List<Role> plcPackageRoleList = (List<Role>) plcPackageOb;

                    for (Role plcPackageRole : plcPackageRoleList) {

                        Object mainClauseOb = plcPackageRole.find("R:" + ReservedRoleKind.plcMainClause.name());
                        if (mainClauseOb == null) {
                            continue;
                        }
                        if (mainClauseOb instanceof Collection) {

                            List<Role> mainRoleList = (List<Role>) mainClauseOb;

                            try {
                                for (Role mainRole : mainRoleList) {
                                    // 主条款
                                    plcClauseList.add(mainRole);
                                    Object plcAccessoryClauseOb = mainRole
                                            .find("R:" + ReservedRoleKind.plcAccessoryClause.name());
                                    // 附加条款
                                    if (plcAccessoryClauseOb == null) {
                                        continue;
                                    }
                                    if (plcAccessoryClauseOb instanceof Collection) {
                                        List<Role> plcAccessoryClauseRoleList = (List<Role>) plcAccessoryClauseOb;

                                        for (Role accessoryRole : plcAccessoryClauseRoleList) {
                                            if (accessoryRole == null) {
                                                continue;
                                            }
                                            plcClauseList.add(accessoryRole);
                                        }
                                    }
                                }
                            } catch (Exception ex) {
                                logger.error("format property to PlcClauseEO error", ex);
                            }

                        }
                    }
                }
            }
        }
        return plcClauseList;
    }

    /**
     * @return plcRespondent
     * @Description: 获取被申请人信息
     */
    @SuppressWarnings({"unchecked"})
    public List<ProductCustomerEntity> getPlcRespondent() {
        Role role = bs.getRole();
        if (role == null) {
            return null;
        }
        List<ProductCustomerEntity> customerEntityList = new ArrayList<ProductCustomerEntity>();
        String path = ReservedRoleKind.plcRespondent.name();
        List<Role> roleList = role.findChildren(Role.class, path);
        try {
            for (Role r : roleList) {
                PlcInsurantEO eo = (PlcInsurantEO) r.getFixedActual();
                ProductCustomerEntity productCustomerEntity = new ProductCustomerEntity();
                CarPlatBeanUtils.copy(eo, productCustomerEntity);
                Object plcCustomerOb = convertChildRoleToObject(r, ReservedRoleKind.plcCustomer.name(),
                        PlcCustomerEO.class);
                productCustomerEntity
                        .setPlcCustomerEO(plcCustomerOb == null ? null : (PlcCustomerEO) plcCustomerOb);
                Object plcGrpcustomerOb = convertChildRoleToObject(r, ReservedRoleKind.plcGrpCustomer.name(),
                        PlcGrpcustomerEO.class);
                productCustomerEntity
                        .setPlcGrpcustomerEO(plcGrpcustomerOb == null ? null : (PlcGrpcustomerEO) plcGrpcustomerOb);
                customerEntityList.add(productCustomerEntity);
            }
        } catch (Exception ex) {
            logger.error("format property to PlcInsurants error", ex);
        }
        return customerEntityList;
    }
    
    /**
     * @return plcCarCharger
     *
     * @Description: 获取充电桩设备信息
     */
    @SuppressWarnings({ "unchecked" })
    public List<PlcCarChargerEO> getPlcCarCharger() {
        List<PlcCarChargerEO> plcCarChargerEOList = new ArrayList<PlcCarChargerEO>();
        Role role = bs.getRole();
        String path = ContractSpecActualConstant.kindPathMap.get(ReservedRoleKind.plcCarCharger.name());
        Object o = role.find(StartPosition.R.name() + ":" + path);
        if (o == null) {
            return null;
        }
        if (!(o instanceof Collection)) {
            return null;
        }
        try {
            List<Role> plcCarChargerRoleList = (List<Role>) o;
            for (Role plcCarChargerRole : plcCarChargerRoleList) {
                PlcCarChargerEO plcCarChargerEO = (PlcCarChargerEO) plcCarChargerRole.getFixedActual();
                // BeanUtils.copyProperties(plcDeviceEO,
                // plcDeviceRole.getProperty());
                plcCarChargerEOList.add(plcCarChargerEO);
            }
        } catch (Exception ex) {
            logger.error("format property to PlcCarChargerEO error");
            return null;
        }
        return plcCarChargerEOList;
    }

    /**
     * 获取协议下条款
     * @param plcAgrAcceptRole plcAgrAcceptRole
     * @return List<Role>
     */
    public List<Role> getPlcAvaProductClauseRole(Role plcAgrAcceptRole) {
        if (plcAgrAcceptRole == null) {
            return null;
        }
        List<Role> plcAvaProductClauseRoleList = new ArrayList<Role>();
        
        // 协议下的投保方案
        List<Role> agrPurchaseRoleList = plcAgrAcceptRole.findChildren(Role.class,
                ReservedRoleKind.plcAgrPurchase.name());

        if (CollectionUtil.isNotEmpty(agrPurchaseRoleList)) {
            
            for (Role agrPurchaseRole : agrPurchaseRoleList) {
                // 协议下的主条款
                List<Role> plcAgrClauseRoleList = agrPurchaseRole.findChildren(Role.class,
                        ReservedRoleKind.plcAgrClause.name());
                
                if (CollectionUtil.isNotEmpty(plcAgrClauseRoleList)) {
                    
                    plcAvaProductClauseRoleList.addAll(plcAgrClauseRoleList);
                    
                    for (Role agrClause : plcAgrClauseRoleList) {
                        
                        // 协议下的附加条款
                        List<Role> plcAgrAccessaryClauseRoleList = agrClause.findChildren(Role.class,
                                ReservedRoleKind.plcAgrAccessaryClause.name());
                        
                        if (CollectionUtil.isNotEmpty(plcAgrAccessaryClauseRoleList)) {
                            
                            plcAvaProductClauseRoleList.addAll(plcAgrAccessaryClauseRoleList);
                            
                        }
                    }
                }
            }
        }
        return plcAvaProductClauseRoleList;
    }

    /**
     * @return tisPlanList
     * @Description: 获取Tis缴费计划集合
     */
    @SuppressWarnings("unchecked")
    public List<PlcTisPlanEO> getPlcTisPlans(Role plcTisTotutionRole) {
        if (plcTisTotutionRole == null) {
            return null;
        }
        List<PlcTisPlanEO> planList = new ArrayList<>();
        // Tis信息下缴费计划
        List<Role> tisPlanRoleList = plcTisTotutionRole.findChildren(Role.class,
                "plcTisPlan");
        try {
            for (Role tisPlanRole : tisPlanRoleList) {
                PlcTisPlanEO plcTisPlanEO = (PlcTisPlanEO) tisPlanRole.getFixedActual();
                planList.add(plcTisPlanEO);
            }
        } catch (Exception ex) {
            logger.error("format property to PlcTisPlanEO error");
            return null;
        }
        return planList;
    }
}
