-- ZB_DM_CAR_HB  ZB_DM_承保车险合并



-- ZB_DM_QDBF_CAR/ZB_DM_车险今日签单保费
-- key:allcarqbbf/日期
-- 1、日期:核保日期或者核批完成日期(yyyyMMdd)
-- 2、车险

--  总公司
insert into ZB_DM.ZB_DM_REDIS.SET_DECIMAL
select
    CONCAT(
        'allcarqdbf/'
        ,s1.`uwConclueDate`
    )                                       as `key`
    ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from ZB_ODS.ZB_ODS_KAFKA.CBDATA s1
where s1.`COMNAME` is not null
  and s1.`uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
  and left(s1.risk,2) ='05'
group by
    s1.`uwConclueDate`
;

-- 分公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
        'provcarqdbf/'
        ,s1.`uwConclueDate`
    )                                       as `key`
    ,s1.`LEVEL1COMCODE`                     as `hkey`
    ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from ZB_ODS.ZB_ODS_KAFKA.CBDATA s1
where s1.`COMNAME` is not null
  and s1.`uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
  and left(s1.risk,2) ='05'
group by
     s1.`uwConclueDate`
    ,s1.`LEVEL1COMCODE`
;

-- 中支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'citycarqdbf/'
        ,s1.`uwConclueDate`
        )                                    as `key`
     ,s1.`LEVEL2COMCODE`                     as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from ZB_ODS.ZB_ODS_KAFKA.CBDATA s1
where s1.`COMNAME` is not null
  and s1.`uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
  and left(s1.risk,2) ='05'
group by
    s1.`uwConclueDate`
    ,s1.`LEVEL2COMCODE`
;


-- 县支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'countycarqdbf/'
        ,s1.`uwConclueDate`
        )                                    as `key`
     ,s1.`LEVEL3COMCODE`                     as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from ZB_ODS.ZB_ODS_KAFKA.CBDATA s1
where s1.`COMNAME` is not null
  and s1.`uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
  and left(s1.risk,2) ='05'
group by
    s1.`uwConclueDate`
    ,s1.`LEVEL3COMCODE`
;


-- 团队
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'teamcarqdbf/'
        ,s1.`uwConclueDate`
        )                                     as `key`
     ,s1.`LEVEL4COMCODE`                      as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))   as `val`
from ZB_ODS.ZB_ODS_KAFKA.CBDATA s1
where s1.`COMNAME` is not null
  and s1.`uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
  and left(s1.risk,2) ='05'
group by
    s1.`uwConclueDate`
    ,s1.`LEVEL4COMCODE`
;


-- ZB_DM_CXCBDD ZB_DM_车险承保大单
-- bigcbd/日期
-- 核保或者核批时间在今天，按照保费或者未决赔款排序，取前10，车险riskcode 05开头，其他为非车，

-- 总公司
insert into ZB_DM.ZB_DM_REDIS.SET_VARCHAR
select
    CONCAT(
            'bigcbd/'
        ,s1.`uwConclueDate`
        )                      as `key`
     ,CastToJsonArrayUDF(
        listagg(concat(
                        'com'      ,':'  ,`com`      ,','
                    ,'comname'  ,':'  ,`comname`  ,','
                    ,'risk'     ,':'  ,`risk`     ,','
                    ,'riskname' ,':'  ,`riskname` ,','
                    ,'chnl'     ,':'  ,`chnl`     ,','
                    ,'chnlname' ,':'  ,`chnlname` ,','
                    ,'cost'     ,':'  ,`cost`     ,','
                    ,'no'       ,':'  ,`no`
                    ),';')
    )                      as `val`
from (
         select
             *
         from(
                 select
                     d1.`uwConclueDate`                      as `uwConclueDate`
                      ,d1.`LEVEL1COMCODE`                     as `com`
                      ,d1.`LEVEL1COMDESC`                     as `comname`
                      ,d1.`risk`                              as `risk`
                      ,d1.`riskname`                          as `riskname`
                      ,d1.`chnl`                              as `chnl`
                      ,d1.`chnlname`                          as `chnlname`
                      ,cast(d1.`cost` as varchar)             as `cost`
                      ,d1.`no`                                as `no`
                      ,ROW_NUMBER() OVER(PARTITION BY d1.`uwConclueDate` ORDER BY d1.`cost` DESC) as rownum
                 from ZB_ODS.ZB_ODS_KAFKA.CBDATA d1
                 where d1.`COMNAME` is not null
                   and d1.`uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
                   and left(d1.risk,2) ='05'
             ) c1
         where c1.rownum <= 20
     ) s1
group by
    s1.`uwConclueDate`
;



-- 分公司
insert into ZB_DM.ZB_DM_REDIS.SET_VARCHAR
select
    CONCAT(
            'bigccitybd/'
        ,s1.`uwConclueDate`
        ,'/',s1.`group_com`
        )                      as `key`
     ,CastToJsonArrayUDF(
        listagg(concat(
                        'com'      ,':'  ,`com`      ,','
                    ,'comname'  ,':'  ,`comname`  ,','
                    ,'city'     ,':'  ,`city`     ,','
                    ,'cityname' ,':'  ,`cityname` ,','
                    ,'risk'     ,':'  ,`risk`     ,','
                    ,'riskname' ,':'  ,`riskname` ,','
                    ,'chnl'     ,':'  ,`chnl`     ,','
                    ,'chnlname' ,':'  ,`chnlname` ,','
                    ,'cost'     ,':'  , `cost`    ,','
                    ,'no'       ,':'  ,`no`
                    ),';')
    )                      as `val`
from (
         select
             *
         from (
                  select
                      d1.`uwConclueDate`                     as `uwConclueDate`
                       ,d1.`LEVEL1COMCODE`                     as `group_com`
                       ,d1.`LEVEL1COMCODE`                     as `com`
                       ,d1.`LEVEL1COMDESC`                     as `comname`
                       ,d1.`LEVEL2COMCODE`                     as `city`
                       ,d1.`LEVEL2COMDESC`                     as `cityname`
                       ,d1.`risk`                              as `risk`
                       ,d1.`riskname`                          as `riskname`
                       ,d1.`chnl`                              as `chnl`
                       ,d1.`chnlname`                          as `chnlname`
                       ,cast(d1.`cost` as varchar)             as `cost`
                       ,d1.`no`                                as `no`
                       ,ROW_NUMBER() OVER(PARTITION BY d1.`LEVEL1COMCODE`,d1.`uwConclueDate` ORDER BY d1.`cost` DESC) as rownum
                  from ZB_ODS.ZB_ODS_KAFKA.CBDATA d1
                  where d1.`COMNAME` is not null
                    and d1.`uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
                    and left(d1.risk,2) ='05'
              ) c1
         where c1.rownum <= 20
     ) s1
group by
    s1.`uwConclueDate`
       ,s1.`group_com`
;


-- 中支
insert into ZB_DM.ZB_DM_REDIS.SET_VARCHAR
select
    CONCAT(
            'bigccountrybd/'
        ,s1.`uwConclueDate`
        ,'/',s1.`group_com`
        )                      as `key`
     ,CastToJsonArrayUDF(
        listagg(concat(
                        'com'         ,':'  ,`com`         ,','
                    ,'comname'     ,':'  ,`comname`     ,','
                    ,'city'        ,':'  ,`city`        ,','
                    ,'cityname'    ,':'  ,`cityname`    ,','
                    ,'country'     ,':'  ,`country`     ,','
                    ,'countryname' ,':'  ,`countryname` ,','
                    ,'risk'        ,':'  ,`risk`        ,','
                    ,'riskname'    ,':'  ,`riskname`    ,','
                    ,'chnl'        ,':'  ,`chnl`        ,','
                    ,'chnlname'    ,':'  ,`chnlname`    ,','
                    ,'cost'        ,':'  ,cast(`cost` as varchar) ,','
                    ,'no'          ,':'  ,`no`
                    ),';')
    )                         as `val`
from (
         select
             *
         from (
                  select
                      d1.`uwConclueDate`                     as `uwConclueDate`
                       ,d1.`LEVEL2COMCODE`                     as `group_com`
                       ,d1.`LEVEL1COMCODE`                     as `com`
                       ,d1.`LEVEL1COMDESC`                     as `comname`
                       ,d1.`LEVEL2COMCODE`                     as `city`
                       ,d1.`LEVEL2COMDESC`                     as `cityname`
                       ,d1.`LEVEL3COMCODE`                     as `country`
                       ,d1.`LEVEL3COMDESC`                     as `countryname`
                       ,d1.`risk`                              as `risk`
                       ,d1.`riskname`                          as `riskname`
                       ,d1.`chnl`                              as `chnl`
                       ,d1.`chnlname`                          as `chnlname`
                       ,cast(d1.`cost` as varchar)             as `cost`
                       ,d1.`no`                                as `no`
                       ,ROW_NUMBER() OVER(PARTITION BY d1.`LEVEL2COMCODE`,d1.`uwConclueDate` ORDER BY d1.`cost` DESC) as rownum
                  from ZB_ODS.ZB_ODS_KAFKA.CBDATA d1
                  where d1.`COMNAME` is not null
                    and d1.`uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
                    and left(d1.risk,2) ='05'
              ) c1
         where c1.rownum <= 20
     ) s1
group by
    s1.`uwConclueDate`
       ,s1.`group_com`
;