-- ZB_DM_JRQDBF_HB_NEW ZB_DM_今日签单合并_NEW

-- step1：
-- 团队汇总
CREATE TEMPORARY VIEW VIEW_ZB_DM_JRQDBF_HB_TUANDUI AS
select
     a1.`uwConclueDate`                                                as `uwConclueDate`
    ,a1.`LEVEL1COMCODE`                                                as `LEVEL1COMCODE`
    ,a1.`LEVEL2COMCODE`                                                as `LEVEL2COMCODE`
    ,a1.`LEVEL3COMCODE`                                                as `LEVEL3COMCODE`
    ,a1.`LEVEL4COMCODE`                                                as `LEVEL4COMCODE`
    ,a1.`startTime`                                                    as `startTime`
    ,a1.`cost` + if(t1.cost is null ,0,cast(t1.cost as decimal(18,2))) as `cost`
from (
    SELECT
           s1.`uwConclueDate`                     as `uwConclueDate`
         , s1.`LEVEL1COMCODE`                     as `LEVEL1COMCODE`
         , s1.`LEVEL2COMCODE`                     as `LEVEL2COMCODE`
         , s1.`LEVEL3COMCODE`                     as `LEVEL3COMCODE`
         , s1.`LEVEL4COMCODE`                     as `LEVEL4COMCODE`
         , s1.`startTime`                         as `startTime`
         , sum(cast(s1.`cost` as DECIMAL(18, 2))) as `cost`
         , max(s1.proctime)                       as proctime
    from ZB_ODS.ZB_ODS_KAFKA.CBDATA s1
    where
      s1.`COMNAME` is not null
    and s1.`uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
    and LongTimeToStringUDF(s1.log_time,'yyyyMMdd HH') = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd HH')
    group by
        s1.`uwConclueDate`
        , s1.`LEVEL1COMCODE`
        , s1.`LEVEL2COMCODE`
        , s1.`LEVEL3COMCODE`
        , s1.`LEVEL4COMCODE`
        , s1.`startTime`
)a1
left join ZB_DM.ZB_DM_MYSQL.TEAM_ALL for system_time as of a1.proctime as t1
              on  a1.`uwConclueDate`  = t1.`uwConclueDate`
              and a1.`LEVEL4COMCODE`  = t1.`LEVEL4COMCODE`
              and a1.`startTime`      = t1.`startTime`

;

-- ZB_DM_JRQDBF ZB_DM_今日签单保费
-- key:allqdbf/日期
-- 1、日期:核保日期或者核批完成日期(yyyyMMdd)

-- 总公司 
insert into ZB_DM.ZB_DM_REDIS.SET_DECIMAL
select
    CONCAT(
            'allqdbf/'
        ,s1.`uwConclueDate`
        )                                      as `key`
     ,sum(cast(s1.`cost` as DECIMAL(18,2))) as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1

group by
    s1.`uwConclueDate`
;

-- 分公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'provqdbf/'
        ,s1.`uwConclueDate`
        )                                      as `key`
     ,s1.`LEVEL1COMCODE`                    as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2))) as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
group by
    s1.`uwConclueDate`
    ,s1.`LEVEL1COMCODE`
;


-- 中支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'cityqdbf/'
        ,s1.`uwConclueDate`
        )                                     as `key`
     ,s1.`LEVEL2COMCODE`                      as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))   as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
group by
    s1.`uwConclueDate`
    ,s1.`LEVEL2COMCODE`
;

-- 县支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'countryqdbf/'
        ,s1.`uwConclueDate`
        )                                     as `key`
     ,s1.`LEVEL3COMCODE`                      as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))   as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
group by
    s1.`uwConclueDate`
    ,s1.`LEVEL3COMCODE`
;

-- 团队
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'teamqdbf/'
        ,s1.`uwConclueDate`
        )                                   as `key`
     ,s1.`LEVEL4COMCODE`                    as `hkey`
     ,cast(s1.`cost` as DECIMAL(18,2))      as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
;




-- ZB_DM_JRQDJNQBBF ZB_DM_今日签单今年待起保保费
-- key:allqbbf/日期
-- 1、日期:核保日期或者核批完成日期(yyyyMMdd)
-- 2、起保时间小于等于当年

-- 总公司
insert into ZB_DM.ZB_DM_REDIS.SET_DECIMAL
select
    CONCAT(
            'allqbbf/'
        ,s1.`uwConclueDate`
        )                                       as `key`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
where left(s1.`startTime`,4) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyy')
group by
    s1.`uwConclueDate`
;

-- 分公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'provqbbf/'
        ,s1.`uwConclueDate`
        )                                       as `key`
     ,s1.`LEVEL1COMCODE`                     as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
where left(s1.`startTime`,4) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyy')
group by
    s1.`uwConclueDate`
   ,s1.`LEVEL1COMCODE`
;

-- 中支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'cityqbbf/'
        ,s1.`uwConclueDate`
        )                                    as `key`
     ,s1.`LEVEL2COMCODE`                     as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
where left(s1.`startTime`,4) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyy')
group by
    s1.`uwConclueDate`
    ,s1.`LEVEL2COMCODE`
;


-- 县支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'countryqbbf/'
        ,s1.`uwConclueDate`
        )                                    as `key`
     ,s1.`LEVEL3COMCODE`                     as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
where left(s1.`startTime`,4) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyy')
group by
    s1.`uwConclueDate`
    ,s1.`LEVEL3COMCODE`
;


-- 团队
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'teamqbbf/'
        ,s1.`uwConclueDate`
        )                                    as `key`
     ,s1.`LEVEL4COMCODE`                     as `hkey`
     ,cast(s1.`cost` as DECIMAL(18,2))       as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
where left(s1.`startTime`,4) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyy')

;



-- ZB_DM_JRQDJDMQBBF ZB_DM_今日签单季度末待起保保费
-- key:allquarterqdbf
-- 1、日期:核保日期或者核批完成日期(yyyyMMdd)
-- 2、起保时间小于等于当季度

--  总公司
insert into ZB_DM.ZB_DM_REDIS.SET_DECIMAL
select
    CONCAT(
            'allquarterqdbf/'
        ,s1.`uwConclueDate`
        )                                       as `key`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
-- 核保时间在今天并且起保时间的月份小于等于季度。
where CASE WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('01','02','03') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'03')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('04','05','06') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'06')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('07','08','09') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'09')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('10','11','12') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'12')
           END
group by
    s1.`uwConclueDate`
;

-- 分公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'provquarterqdbf/'
        ,s1.`uwConclueDate`
        )                                       as `key`
     ,s1.`LEVEL1COMCODE`                     as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
-- 核保时间在今天并且起保时间的月份小于等于季度。
where CASE WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('01','02','03') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'03')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('04','05','06') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'06')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('07','08','09') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'09')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('10','11','12') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'12')
           END
group by
     s1.`uwConclueDate`
    ,s1.`LEVEL1COMCODE`
;

-- 中支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'cityquarterqdbf/'
        ,s1.`uwConclueDate`
        )                                    as `key`
     ,s1.`LEVEL2COMCODE`                     as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
-- 核保时间在今天并且起保时间的月份小于等于季度。
where CASE WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('01','02','03') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'03')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('04','05','06') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'06')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('07','08','09') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'09')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('10','11','12') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'12')
           END
group by
    s1.`uwConclueDate`
    ,s1.`LEVEL2COMCODE`
;


-- 县支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'countyquarterqdbf/'
        ,s1.`uwConclueDate`
        )                                    as `key`
     ,s1.`LEVEL3COMCODE`                     as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
-- 核保时间在今天并且起保时间的月份小于等于季度。
where CASE WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('01','02','03') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'03')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('04','05','06') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'06')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('07','08','09') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'09')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('10','11','12') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'12')
           END
group by
    s1.`uwConclueDate`
    ,s1.`LEVEL3COMCODE`
;


-- 团队
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'teamquarterqdbf/'
        ,s1.`uwConclueDate`
        )                                as `key`
     ,s1.`LEVEL4COMCODE`                 as `hkey`
     ,cast(s1.`cost` as DECIMAL(18,2))   as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
-- 核保时间在今天并且起保时间的月份小于等于季度。
where CASE WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('01','02','03') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'03')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('04','05','06') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'06')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('07','08','09') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'09')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('10','11','12') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'12')
           END
;



-- ZB_DM_JRQDYDQQBBF ZB_DM_今日签单月底前起保保费
-- key:allmonthqbbf/日期
-- 1、日期:核保日期或者核批完成日期(yyyyMMdd)
-- 2、起保时间小于等于当月

--  总公司
insert into ZB_DM.ZB_DM_REDIS.SET_DECIMAL
select
    CONCAT(
            'allmonthqbbf/'
        ,s1.`uwConclueDate`
        )                                       as `key`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
where left(s1.`startTime`,6) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyyMM')
group by
    s1.`uwConclueDate`
;

-- 分公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'provmonthqbbf/'
        ,s1.`uwConclueDate`
        )                                       as `key`
     ,s1.`LEVEL1COMCODE`                     as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
where left(s1.`startTime`,6) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyyMM')
group by
    s1.`uwConclueDate`
    ,s1.`LEVEL1COMCODE`
;

-- 中支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'citymonthqbbf/'
        ,s1.`uwConclueDate`
        )                                    as `key`
     ,s1.`LEVEL2COMCODE`                     as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
where left(s1.`startTime`,6) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyyMM')
group by
    s1.`uwConclueDate`
    ,s1.`LEVEL2COMCODE`
;


-- 县支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'countrymonthqbbf/'
        ,s1.`uwConclueDate`
        )                                    as `key`
     ,s1.`LEVEL3COMCODE`                     as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
where left(s1.`startTime`,6) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyyMM')
group by
    s1.`uwConclueDate`
    ,s1.`LEVEL3COMCODE`
;


-- 团队
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'teammonthqbbf/'
        ,s1.`uwConclueDate`
        )                                as `key`
     ,s1.`LEVEL4COMCODE`                 as `hkey`
     ,cast(s1.`cost` as DECIMAL(18,2))   as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
where left(s1.`startTime`,6) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyyMM')

;



-- ZB_DM_JRQDJRQBBF ZB_DM_今日签单今日待起保保费
-- key:alldayqdbf/日期
-- 1、日期:核保日期或者核批完成日期(yyyyMMdd)
-- 2、起保时间小于等于当日

-- 总公司
insert into ZB_DM.ZB_DM_REDIS.SET_DECIMAL
select
    CONCAT(
            'alldayqdbf/'
        ,s1.`uwConclueDate`
        )                                       as `key`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
where left(s1.`startTime`,8) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
group by
    s1.`uwConclueDate`
;

-- 分公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'provdayqdbf/'
        ,s1.`uwConclueDate`
        )                                       as `key`
     ,s1.`LEVEL1COMCODE`                     as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
where left(s1.`startTime`,8) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
group by
    s1.`uwConclueDate`
    ,s1.`LEVEL1COMCODE`
;

-- 中支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'citydayqdbf/'
        ,s1.`uwConclueDate`
        )                                    as `key`
     ,s1.`LEVEL2COMCODE`                     as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
where left(s1.`startTime`,8) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
group by
    s1.`uwConclueDate`
    ,s1.`LEVEL2COMCODE`
;


-- 县支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'countrydayqdbf/'
        ,s1.`uwConclueDate`
        )                                    as `key`
     ,s1.`LEVEL3COMCODE`                     as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
where left(s1.`startTime`,8) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
group by
    s1.`uwConclueDate`
    ,s1.`LEVEL3COMCODE`
;


-- 团队
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'teamdayqdbf/'
        ,s1.`uwConclueDate`
        )                                    as `key`
     ,s1.`LEVEL4COMCODE`                     as `hkey`
     ,cast(s1.`cost` as DECIMAL(18,2))       as `val`
from VIEW_ZB_DM_JRQDBF_HB_TUANDUI s1
where left(s1.`startTime`,8) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')

;



