-- ZB_DM_FQDBF_HB_NEW ZB_DM_分渠道保费合并_NEW


-- step1：
-- 团队汇总
CREATE TEMPORARY VIEW VIEW_ZB_DM_FQDBF_HB_NEW_TUANDUI AS 
SELECT 
     a1.`uwConclueDate`                                                as `uwConclueDate`
    ,a1.`LEVEL1COMCODE`                                                as `LEVEL1COMCODE`
    ,a1.`LEVEL2COMCODE`                                                as `LEVEL2COMCODE`                 
    ,a1.`LEVEL3COMCODE`                                                as `LEVEL3COMCODE`                 
    ,a1.`LEVEL4COMCODE`                                                as `LEVEL4COMCODE`
    ,a1.`startTime`                                                    as `startTime`
    ,a1.`chnl`                                                         as `chnl`
    ,a1.`cost` + if(t1.cost is null ,0,cast(t1.cost as decimal(18,2))) as `cost`
from (
         SELECT
               s1.`uwConclueDate`                     as `uwConclueDate`
             , s1.`LEVEL1COMCODE`                     as `LEVEL1COMCODE`
             , s1.`LEVEL2COMCODE`                     as `LEVEL2COMCODE`
             , s1.`LEVEL3COMCODE`                     as `LEVEL3COMCODE`
             , s1.`LEVEL4COMCODE`                     as `LEVEL4COMCODE`
             , s1.`startTime`                         as `startTime`
             , s1.`chnl`                              as `chnl`
             , sum(cast(s1.`cost` as DECIMAL(18, 2))) as `cost`
             , max(s1.proctime)                       as proctime
         from ZB_ODS.ZB_ODS_KAFKA.CBDATA s1
         where
             s1.`COMNAME` is not null
           and s1.`uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
           and left(s1.`startTime`,4) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyy')
           and LongTimeToStringUDF(s1.log_time,'yyyyMMdd HH') = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd HH')
         group by
             s1.`uwConclueDate`
             , s1.`LEVEL1COMCODE`
             , s1.`LEVEL2COMCODE`
             , s1.`LEVEL3COMCODE`
             , s1.`LEVEL4COMCODE`
             , s1.`startTime`
             , s1.`chnl`
     ) a1
left join ZB_DM.ZB_DM_MYSQL.TEAM_CHNL for system_time as of a1.proctime as t1
       on a1.`uwConclueDate` = t1.`uwConclueDate`
      and a1.`LEVEL4COMCODE` = t1.`LEVEL4COMCODE`
      and a1.`startTime`     = t1.`startTime`
      and a1.`chnl`          = t1.`chnl`   
;

-- ZB_DM_FQDBF ZB_DM_分渠道保费
-- chnlbf/日期/00000000	渠道代码
-- 1、日期:核保日期或者核批完成日期(yyyyMMdd)
-- 2、起保时间小于等于当年

-- 总公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select 
    CONCAT(
        'chnlbf/'
        ,s1.`uwConclueDate`
        ,'/00000000'
    )                                       as `key` 
    ,s1.`chnl`                              as `hkey` 
    ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val` 
from VIEW_ZB_DM_FQDBF_HB_NEW_TUANDUI s1
group by
     s1.`uwConclueDate` 
     ,s1.`chnl`

;

-- 分公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select 
    CONCAT(
        'chnlbf/'
        ,s1.`uwConclueDate`
        ,'/',s1.`LEVEL1COMCODE`
    )                                       as `key`   
    ,s1.`chnl`                              as `hkey` 
    ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val` 
from VIEW_ZB_DM_FQDBF_HB_NEW_TUANDUI s1
group by 
    s1.`uwConclueDate` 
    ,s1.`chnl`
    ,s1.`LEVEL1COMCODE`
;


-- 中支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'citychnlbf/'
        ,s1.`uwConclueDate`
        ,'/',s1.`LEVEL2COMCODE`
        )                                    as `key`
     ,s1.`chnl`                              as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_FQDBF_HB_NEW_TUANDUI s1
group by
    s1.`uwConclueDate`
    ,s1.`chnl`
    ,s1.`LEVEL2COMCODE`
;



-- 县支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'countrychnlbf/'
        ,s1.`uwConclueDate`
        ,'/',s1.`LEVEL3COMCODE`
        )                                    as `key`
     ,s1.`chnl`                              as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_FQDBF_HB_NEW_TUANDUI s1
group by
    s1.`uwConclueDate`
    ,s1.`chnl`
    ,s1.`LEVEL3COMCODE`
;



-- 团队
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'teamchnlbf/'
        ,s1.`uwConclueDate`
        ,'/',s1.`LEVEL4COMCODE`
        )                               as `key`
     ,s1.`chnl`                         as `hkey`
     ,cast(s1.`cost` as DECIMAL(18,2))  as `val`
from VIEW_ZB_DM_FQDBF_HB_NEW_TUANDUI s1
;