-- ZB_DM_FXLBF_HB_NEW ZB_DM_分险类保费合并_NEW


-- step1：
-- 团队汇总
CREATE TEMPORARY VIEW VIEW_ZB_DM_FXLBF_HB_NEW_TUANDUI AS 
SELECT 
     a1.`uwConclueDate`                    as `uwConclueDate`
    ,a1.`classcode`                        as `classcode`
    ,a1.`LEVEL1COMCODE`                    as `LEVEL1COMCODE`                 
    ,a1.`LEVEL2COMCODE`                    as `LEVEL2COMCODE`                 
    ,a1.`LEVEL3COMCODE`                    as `LEVEL3COMCODE`                 
    ,a1.`LEVEL4COMCODE`                    as `LEVEL4COMCODE` 
    ,a1.`startTime`                        as `startTime`
    ,a1.`cost` + if(t1.cost is null ,0,cast(t1.cost as decimal(18,2))) as `cost`
from (
         SELECT
               s1.`uwConclueDate`                     as `uwConclueDate`
             , s1.`classcode`                         as `classcode`
             , s1.`LEVEL1COMCODE`                     as `LEVEL1COMCODE`
             , s1.`LEVEL2COMCODE`                     as `LEVEL2COMCODE`
             , s1.`LEVEL3COMCODE`                     as `LEVEL3COMCODE`
             , s1.`LEVEL4COMCODE`                     as `LEVEL4COMCODE`
             , s1.`startTime`                         as `startTime`
             , sum(cast(s1.`cost` as DECIMAL(18, 2))) as `cost`
             , max(s1.proctime)                       as proctime
         from ZB_ODS.ZB_ODS_KAFKA.CBDATA s1
         where
             s1.`COMNAME` is not null
           and s1.`uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
           and left(s1.`startTime`,4) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyy')
           and LongTimeToStringUDF(s1.log_time,'yyyyMMdd HH') = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd HH')
         group by
             s1.`uwConclueDate`
             , s1.`classcode`
             , s1.`LEVEL1COMCODE`
             , s1.`LEVEL2COMCODE`
             , s1.`LEVEL3COMCODE`
             , s1.`LEVEL4COMCODE`
             , s1.`startTime`
     ) a1
left join ZB_DM.ZB_DM_MYSQL.TEAM_CLASSCODE for system_time as of a1.proctime as t1
       on a1.`uwConclueDate` = t1.`uwConclueDate`
      and a1.`LEVEL4COMCODE` = t1.`LEVEL4COMCODE`
      and a1.`startTime`     = t1.`startTime`
      and a1.`classcode`     = t1.`classcode`
;

-- ZB_DM_FXLBF ZB_DM_分险类保费
-- allxlbf/日期	险类代码
-- 1、日期:核保日期或者核批完成日期(yyyyMMdd)
-- 2、起保时间小于等于当年

--总公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select 
    CONCAT(
        'allxlbf/'
        ,s1.`uwConclueDate`
    )                                       as `key` 
    ,s1.`classcode`                         as `hkey`
    ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val` 
from VIEW_ZB_DM_FXLBF_HB_NEW_TUANDUI s1
group by 
    s1.`uwConclueDate`
    ,s1.`classcode`

;

-- 分公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select 
    CONCAT(
        'provxlbf/'
        ,s1.`uwConclueDate`
        ,'/',s1.`LEVEL1COMCODE`
    )                                       as `key`  
    ,s1.`classcode`                         as `hkey` 
    ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val` 
from VIEW_ZB_DM_FXLBF_HB_NEW_TUANDUI s1
group by 
    s1.`uwConclueDate`
    ,s1.`classcode`
    ,s1.`LEVEL1COMCODE`
;

-- 中支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'cityxlbf/'
        ,s1.`uwConclueDate`
        ,'/',s1.`LEVEL2COMCODE`
        )                                    as `key`
     ,s1.`classcode`                         as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_FXLBF_HB_NEW_TUANDUI s1
group by
    s1.`uwConclueDate`
    ,s1.`classcode`
    ,s1.`LEVEL2COMCODE`
;

-- 县支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'countryxlbf/'
        ,s1.`uwConclueDate`
        ,'/',s1.`LEVEL3COMCODE`
        )                                    as `key`
     ,s1.`classcode`                         as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_FXLBF_HB_NEW_TUANDUI s1
group by
    s1.`uwConclueDate`
    ,s1.`classcode`
    ,s1.`LEVEL3COMCODE`
;

-- 团队
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'teamxlbf/'
        ,s1.`uwConclueDate`
        ,'/',s1.`LEVEL4COMCODE`
        )                               as `key`
     ,s1.`classcode`                    as `hkey`
     ,cast(s1.`cost` as DECIMAL(18,2))  as `val`
from VIEW_ZB_DM_FXLBF_HB_NEW_TUANDUI s1

;