-- ZB_DM_TEAM_RISK ZB_DM_团队汇总结果_险种



-- step1：
-- 团队汇总
INSERT INTO ZB_DM.ZB_DM_MYSQL.TEAM_RISK
select
    a1.`uwConclueDate`                                                    as `uwConclueDate`
    , a1.`LEVEL1COMCODE`                                                  as `LEVEL1COMCODE`
    , a1.`LEVEL2COMCODE`                                                  as `LEVEL2COMCODE`
    , a1.`LEVEL3COMCODE`                                                  as `LEVEL3COMCODE`
    , a1.`LEVEL4COMCODE`                                                  as `LEVEL4COMCODE`
    , a1.`startTime`                                                      as `startTime`
    , a1.`risk`                                                           as `risk`
    , cast (a1.`cost`+ if(t1.cost is null ,0,cast(t1.cost as decimal(18,2)))as varchar )      as `cost`
    , a1.`log_time`                                                       as `log_time`

from (
    SELECT
           s1.`uwConclueDate`                                                               as `uwConclueDate`
         , s1.`LEVEL1COMCODE`                                                               as `LEVEL1COMCODE`
         , s1.`LEVEL2COMCODE`                                                               as `LEVEL2COMCODE`
         , s1.`LEVEL3COMCODE`                                                               as `LEVEL3COMCODE`
         , s1.`LEVEL4COMCODE`                                                               as `LEVEL4COMCODE`
         , s1.`startTime`                                                                   as `startTime`
         , s1.`risk`                                                                        as `risk`
         , sum(cast(s1.`cost` as DECIMAL(18, 2)))                                           as `cost`
         , cast (DateTimeToLongUDF(tumble_end(s1.row_time, interval '1' hour) ) as varchar) as `log_time`
         , max(s1.proctime)                                                                 as proctime
    from ZB_ODS.ZB_ODS_KAFKA.CBDATA s1
    where
          `COMNAME` is not null
        and LEFT(`uwConclueDate`,8) = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
    group by
        s1.`uwConclueDate`
        , s1.`LEVEL1COMCODE`
        , s1.`LEVEL2COMCODE`
        , s1.`LEVEL3COMCODE`
        , s1.`LEVEL4COMCODE`
        , s1.`startTime`
        , s1.`risk`
        , tumble(s1.row_time, interval '1' hour)
)a1
left join ZB_DM.ZB_DM_MYSQL.TEAM_RISK for system_time as of a1.proctime as t1
              on  a1.`uwConclueDate`  = t1.`uwConclueDate`
              and a1.`LEVEL4COMCODE`  = t1.`LEVEL4COMCODE`
              and a1.`startTime`      = t1.`startTime`
              and a1.`risk`           = t1.`risk`

;


