-- ZB_DM_FYWLYBFNDQQB ZB_DM_分业务来源年底前起保保费
-- key:allywlybf/日期
-- 1、日期:核保日期或者核批完成日期(yyyyMMdd)
-- 2、起保时间小于等于当年

-- step1：
-- 团队汇总
CREATE TEMPORARY VIEW VIEW_ZB_DM_FYWLYBFNDQQB_TUANDUI AS 
SELECT 
     s1.`uwConclueDate`                    as `uwConclueDate`
    ,s1.`businessNatureCode`               as `businessNatureCode`
    ,s1.`LEVEL1COMCODE`                    as `LEVEL1COMCODE`                 
    ,s1.`LEVEL2COMCODE`                    as `LEVEL2COMCODE`                 
    ,s1.`LEVEL3COMCODE`                    as `LEVEL3COMCODE`                 
    ,s1.`LEVEL4COMCODE`                    as `LEVEL4COMCODE`
    ,s1.`startTime`                        as `startTime`
    ,sum(cast(s1.`cost` as DECIMAL(18,2))) as `cost`
from (
         select
             *
              ,ROW_NUMBER() OVER(PARTITION BY `no`,`COMCODE`,`cost` ORDER BY `uwConclueDate` DESC) as rownum
         from ZB_ODS.ZB_ODS_KAFKA.CBDATA
         where
             `COMNAME` is not null
           and `uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
     ) s1
where s1.rownum = 1
group by
    s1.`uwConclueDate`
    ,s1.`businessNatureCode`                     
    ,s1.`LEVEL1COMCODE`                     
    ,s1.`LEVEL2COMCODE`                     
    ,s1.`LEVEL3COMCODE`                     
    ,s1.`LEVEL4COMCODE`
    ,s1.`startTime`
;


-- ZB_DM_FYWLYBFNDQQB ZB_DM_分业务来源年底前起保保费
-- key:allywlybf/日期
-- 1、日期:核保日期或者核批完成日期(yyyyMMdd)
-- 2、起保时间小于等于当年

-- 总公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select 
    CONCAT(
        'allywlybf/'
        ,s1.`uwConclueDate`
    )                                       as `key`
    ,s1.`businessNatureCode`                as `hkey`
    ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val` 
from VIEW_ZB_DM_FYWLYBFNDQQB_TUANDUI s1
where left(s1.`startTime`,4) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyy')
group by 
    s1.`uwConclueDate`
    ,s1.`businessNatureCode`
;

-- 分公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select 
    CONCAT(
        'provywlybf/'
        ,s1.`uwConclueDate`
        ,'/'
        ,s1.`LEVEL1COMCODE`
    )                                       as `key`
    ,s1.`businessNatureCode`                as `hkey` 
    ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val` 
from VIEW_ZB_DM_FYWLYBFNDQQB_TUANDUI s1
where left(s1.`startTime`,4) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyy')
group by 
    s1.`uwConclueDate`
    ,s1.`businessNatureCode`
    ,s1.`LEVEL1COMCODE` 
;


-- 中支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'cityywlybf/'
        ,s1.`uwConclueDate`
        ,'/'
        ,s1.`LEVEL2COMCODE`
    )                                        as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_FYWLYBFNDQQB_TUANDUI s1
where left(s1.`startTime`,4) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyy')
group by
    s1.`uwConclueDate`
    ,s1.`businessNatureCode`
    ,s1.`LEVEL2COMCODE`
;


-- 县支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'countryywlybf/'
        ,s1.`uwConclueDate`
        ,'/'
        ,s1.`LEVEL3COMCODE`
     )                                       as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_FYWLYBFNDQQB_TUANDUI s1
where left(s1.`startTime`,4) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyy')
group by
    s1.`uwConclueDate`
    ,s1.`businessNatureCode`
    ,s1.`LEVEL3COMCODE`
;


-- 团队
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'teamywlybf/'
        ,s1.`uwConclueDate`
        ,'/'
        ,s1.`LEVEL4COMCODE`
     )                                       as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,cast(s1.`cost` as DECIMAL(18,2))       as `val`
from VIEW_ZB_DM_FYWLYBFNDQQB_TUANDUI s1
where left(s1.`startTime`,4) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyy')

;