-- SET_DECIMAL_CHECK  SET格式DECIMAL数值存储核对

insert into ZB_DM.ZB_CK_RESULT.ZB_CK
select
     case when s1.`key` is null then concat(s2.`key`,DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMddHHmmss'))
          else concat(s1.`key`,DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMddHHmmss')
          end                                      AS id
     ,s1.`key`                                     AS current_key
     ,s1.`val`                                     AS current_val
     ,s2.`key`                                     AS actual_key
     ,s2.`val`                                     AS actual_val
    ,cast (s1.`val` as decimal (18,2)) - cast (s2.`val` as decimal (18,2))  AS poorVal
    ,case when (cast (s1.`val` as decimal (18,2)) - cast (s2.`val` as decimal (18,2))) = 0 then '是'
          else '否'
          end                                      AS ifSign
from ZB_ODS.ZB_DM_REDIS.SET_DECIMAL s1
full outer join ZB_ODS.ZB_DM_REDIS_PRD.SET_DECIMAL s2 on s1.`key` = s2.`key`
where case when s1.`key` is null then SPLIT_INDEX(s2.`key`,'/',1) = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
           when s1.`key` is not null then SPLIT_INDEX(s1.`key`,'/',1) = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
           end
  AND case when s1.`key` is null then s2.`key` regexp'allqdbf/|allcarqdbf/|allnocarqdbf/|allqbbf/|allmonthqbbf/|allmonthqbbf/|allquarterqdbf/|xxzbf/' ||
                                                     'xxzbf/|xxzbf/'
           else s1.`key` regexp'allqdbf/|allcarqdbf/|allnocarqdbf/|allqbbf/|allmonthqbbf/|allmonthqbbf/|allquarterqdbf/|xxzbf/' ||
                               'xxzbf/|xxzbf/'
           end
;