-- ODS_ENDOR ODS_批单业务数据
insert into ODS.ODS_KAFKA_FIRSTHAND.ENDOR  -- topic MQENDOR
select
	endorseNo                   ,                  -- 1 批单号
	businessOffice              ,                  -- 新核心车险批单-保单归属机构代码
	productCode                 ,                  -- 新核心车险批单-险种代码
    businessNatureCode          ,                  -- 新核心车险批单-业务来源
	channelType                 ,					-- 5 渠道类型
	uwConclueDate               ,                  -- 6 核批完成时间
	plpEndorse                  ,
    recordClerkCode             ,               -- 14 归属业务员ID
	recordClerkName             ,               -- 15 归属业务员名称
	businessChannelCode         ,               -- 27 新核心车险批单-清分后渠道
	businessChannelName         ,               -- 28 业务渠道名
    newPolicyFlag               ,               -- 20 新核心车险批单-新保标识 1:是，0：否
	autoTransrenewFlag          ,               -- 21 新核心车险批单-自动续保标识 1:是，4：跨险种自动续保，0：否
	transferPolicyFlag          ,               -- 22 新核心车险批单-转保标识1:是，0：否
	transrenewFlag              ,                -- 23 新核心车险批单-续保标识 1:是，4：跨险种续保，0：否
	policyCreatDate             ,                -- 新核心车险批单-核保通过时间
    plcSolution                 ,
	policyNo                    ,                -- 新核心车险批单-保单号
	businessOfficeName          ,                -- 新核心车险批单-保单归属机构名称
	startTime                   ,                -- 新核心车险批单-起保时间
	endTime                     ,                -- 新核心车险批单-终保时间
	netPremium                  ,                -- 新核心车险批单-不含税保费
	premium                     ,               -- 新核心车险批单-含税保费
	plcCar05                    ,
	plcApplicant                ,
	plcPublicInsurant           ,
	saleaman                    ,                -- 新核心车险批单-代理机构代码
	saleamanName                ,                -- 新核心车险批单-代理机构名称
	policySort                  ,                -- 新核心车险批单-保单种类
    sigAndStaExchangeRate       ,				 -- 8 到人民币汇率 除了粤港车，车险没有存汇率，模型默认0
	DATE_FORMAT(LOCALTIMESTAMP,'yyyy-MM-dd HH:mm:ss')      as log_time , -- 加工平台处理数据时间

    signDate                    ,                       -- 指标新增_保单统计日期
    endorseTime                 ,                       -- 指标新增_批单计算起保时间
    mainSalesmanCode            ,                       -- 指标新增_归属业务员ID
    mainSalesmanName            ,                       -- 指标新增_归属业务员名称
    coinsCode                   ,                       -- 指标新增_共保标识代码 0 非共保  1，主共，2从共,车险无共保，仅有联保
    coinsLinkCode               ,                       -- 指标新增_联保标志代码 0 非联保  3，主联，4从联
    actualId                    ,                        -- 指标新增_唯一标识需验证
    businessNo                                          -- 业务单号
from ODS.SOURCE_RMQ_ENDOR_PRD.ENDOR
;


-- 记录消费数据总量
insert into ODS.ODS_REDIS.SET_VARCHAR
select
    CONCAT('MQ_ENDOR/', LEFT(DataAccEndorUDF( date_time,'get'),10)) as `key` ,
    DataAccEndorUDF( date_time,'get')         as val
from (
    select
        DATE_FORMAT(LOCALTIMESTAMP,'yyyy-MM-dd HH:mm:ss')   as date_time -- 批单累加器 yyyy-MM-dd:num
    from ODS.SOURCE_RMQ_ENDOR_PRD.ENDOR
    -- 在select与where条件中同时调用该参数 acc，会执行两次UDF函数 ,所以通过定义函数记录该参数 DataAccEndorLogUDF
    where LEFT(DataAccEndorUDF( DATE_FORMAT(LOCALTIMESTAMP,'yyyy-MM-dd HH:mm:ss'),'set'),10) <> 'xxxx-xx-xx' -- 将该参数保留
) s1

;



