-- RZ_DM_RUNSTATUS RZ_DM_访问次数

-- RUNSTATUS_URL RZ_DM_访问次数按地址统计
insert into RZ_DM.RZ_DM_KAFKA.RUNSTATUS_URL
select
    s1.applicationName                                                      as `applicationname`
     ,s1.agentId                                                              as `agentid`
     ,s1.endPoint                                                             as `endpoint`
     ,s1.rpc                                                                  as `rpc`
     ,DATE_FORMAT(tumble_end(s1.row_time, interval '1' minute) ,'yyyy-MM-dd HH:mm:ss')     as `time`
     ,cast(AVG(cast(s1.elapsed as decimal(18,2)) )        as varchar)                      as `averageelapsed`
     ,cast(sum(1)                                         as varchar)                      as `total`
     ,cast(sum(if(s1.status = '200',1,0))                 as varchar)                      as `suctotal`
     ,cast(sum(if(s1.status = '200' is not true,1,0))     as varchar)                      as `errortotal`
     ,cast(DateTimeToLongUDF(tumble_start(s1.row_time, interval '1' minute) ) as varchar)  as `createtime`
from RZ_ODS.RZ_ODS_KAFKA.RZDATA s1
where
    UPPER(RIGHT(s1.`rpc`,3)) not in ('.JS')
    and UPPER(RIGHT(s1.`rpc`,4)) not in ('.JPG','.ICO','.CSS','.TTF','.PNG','.PNG','.JPG','.TXT','.MP4','.MP3','.PDF','.DWR')
    and UPPER(RIGHT(s1.`rpc`,5)) not in ('.JSON','.HTML','.LESS','.JPEG')
    and UPPER(RIGHT(s1.`rpc`,6)) not in ('.WOFF2')
group by
    s1.applicationName
    ,s1.agentId
    ,s1.endPoint
    ,s1.rpc
    ,tumble(s1.row_time, interval '1' minute)
;


-- RUNSTATUS_AGENTID RZ_DM_访问次数按应用统计
insert into RZ_DM.RZ_DM_KAFKA.RUNSTATUS_AGENTID
select
    s1.applicationName                                                        as `applicationname`
     ,s1.agentId                                                              as `agentid`
     ,DATE_FORMAT(tumble_end(s1.row_time, interval '1' minute) ,'yyyy-MM-dd HH:mm:ss')     as `time`
     ,cast(AVG(cast(s1.elapsed as decimal(18,2)) )        as varchar)                      as `averageelapsed`
     ,cast(sum(1)                                         as varchar)                      as `total`
     ,cast(sum(if(s1.status = '200',1,0))                 as varchar)                      as `suctotal`
     ,cast(sum(if(s1.status = '200' is not true,1,0))     as varchar)                      as `errortotal`
     ,cast(DateTimeToLongUDF(tumble_start(s1.row_time, interval '1' minute) ) as varchar)  as `createtime`
from RZ_ODS.RZ_ODS_KAFKA.RZDATA s1
group by
    s1.applicationName
    ,s1.agentId
    ,tumble(s1.row_time, interval '1' minute)
;


-- RUNSTATUS_APP RZ_DM_访问次数按集群统计
insert into RZ_DM.RZ_DM_KAFKA.RUNSTATUS_APP
select
    s1.applicationName                                                      as `applicationname`
     ,DATE_FORMAT(tumble_end(s1.row_time, interval '1' minute) ,'yyyy-MM-dd HH:mm:ss')     as `time`
     ,cast(AVG(cast(s1.elapsed as decimal(18,2)) )        as varchar)                      as `averageelapsed`
     ,cast(sum(1)                                         as varchar)                      as `total`
     ,cast(sum(if(s1.status = '200',1,0))                 as varchar)                      as `suctotal`
     ,cast(sum(if(s1.status = '200' is not true,1,0))     as varchar)                      as `errortotal`
     ,cast(DateTimeToLongUDF(tumble_start(s1.row_time, interval '1' minute) ) as varchar)  as `createtime`
from RZ_ODS.RZ_ODS_KAFKA.RZDATA s1
group by
    s1.applicationName
    ,tumble(s1.row_time, interval '1' minute)
;

