-- ZB_CK_CHECK_REALTIME ZB_CK_实时和统计日增量检验

insert into ZB_CK.ZB_CK_ORACLE_ANAQUERY.CHECK_REALTIME
select
 DATE_FORMAT(TIMESTAMPADD(day,-1,LOCALTIMESTAMP),'yyyyMMdd')                                              as signDate
,cast(sum(1)                                                                            as decimal(18,0)) as ysqdsl    -- 原始签单数量
,cast(sum(if(LEFT(s1.productCode,2) = '05',1,0))                                        as decimal(18,0)) as cxqdsl    -- 车险签单数量
,cast(0                                                                                 as decimal(18,0)) as jcqdsl    -- 军车签单数量
,cast(sum(if(LEFT(s1.productCode,2) <>'05' and LEFT(s1.productCode,1) <> '3',1,0))      as decimal(18,0)) as fcfnqdsl  -- 非车非农签单数量
,cast(sum(if(LEFT(s1.productCode,1) = '3',1,0))                                         as decimal(18,0)) as nxqdsl    -- 农险签单数量
,cast(sum(s1.cost)/10000                                                                as decimal(18,2)) as ysqdbf    -- 原始签单保费(万)
,cast(sum(if(LEFT(s1.productCode,2) = '05',s1.cost,0) ) /10000                          as decimal(18,2)) as cxqdbf    -- 车险签单保费(万)
,cast(0                                                                                 as decimal(18,2)) as jcqdbf    -- 军车签单保费(万)
,cast(sum(if(LEFT(s1.productCode,2) <>'05' and LEFT(s1.productCode,1) <> '3',s1.cost,0))/10000 as decimal(18,2)) as fcfnqdbf  -- 非车非农签单保费(万)
    ,cast(sum(if(LEFT(s1.productCode,1) = '3',s1.cost,0)) /10000                                   as decimal(18,2)) as nxqdbf    -- 农险签单保费(万)
,DATE_FORMAT(LOCALTIMESTAMP,'yyyy-MM-dd HH:mm:ss')                                                        as log_time
from(
    select
         policyNo
        ,businessNo
        ,businessOffice
        ,signDate
        ,productCode
        ,coinsCode
        ,cast(cast(netPremium as decimal(30,4))
               * cast(sigAndStaExchangeRate as decimal(30,4))
               *(
                   case
                       when coinsCode = '0' then (
                           case
                               when coinsLinkCode = '0' then 1  -- 非共保非联保
                               else cast(LinkCoinsRate as decimal(30,4)) /100    -- 纯联保
                           end
                       )
                       else (
                           case
                               when coinsLinkCode = '0' then cast(CoinsCoinsRate as decimal(30,4)) /100 -- 纯共保
                               else (
                                       cast(CoinsCoinsRate as decimal(30,4)) /100
                                    )* (
                                       cast(LinkCoinsRate as decimal(30,4)) /100
                                    )  -- 即联又共
                           end
                       )
                   end
               )
        as decimal (30,4))                                                  as `cost`               -- 不含税保费
        ,ROW_NUMBER() OVER(PARTITION BY COALESCE(policyNo,businessNo) ,businessOffice,netPremium ORDER BY signDate DESC)   as rownum
    from ZB_CK.ZB_CK_MYSQL.KAFKA_POLICY
    where signDate = DATE_FORMAT(TIMESTAMPADD(DAY,-1,LOCALTIMESTAMP),'yyyyMMdd')
    and (
        LEFT(COALESCE(policyNo,businessNo) ,2) = '66'
        or
        LEFT(COALESCE(policyNo,businessNo) ,1) = '8'
        )
) s1
where s1.rownum = 1
;