SELECT CAST('1******************************\n          ' ||
            TO_CHAR(TO_DATE(TO_CHAR(TRUNC(DATE), 'yyyy-MM-DD'),
                            'YYYY-MM-DD') - 1,
                    'YYYY-MM-DD') ||
            '\n    实时和统计日增量检验\n****************************** \n(新核心)实时-统计' AS
            VARCHAR(1000)) AS CONTENT
  FROM PCDEVW.CD_CLASS
 GROUP BY 1
UNION ALL
SELECT '2原始签单数量差异(件):\n' || TRIM(A."原始签单数量") || '-' || TRIM(B."原始签单数量") || '=' ||
       TO_CHAR(A."原始签单数量" - B."原始签单数量") || '\n' || '车险签单数量差异(件):\n' ||
       TRIM(A."车险签单数量") || '-' || TRIM(B."车险签单数量") || '=' ||
       TO_CHAR(A."车险签单数量" - B."车险签单数量") || '\n' || '其中军车签单数量差异(件):\n' ||
       TRIM(A."军车签单数量") || '-' || TRIM(B."军车签单数量") || '=' ||
       TO_CHAR(A."军车签单数量" - B."军车签单数量") || '\n' || '非车非农签单数量差异(件):\n' ||
       TRIM(A."非车非农签单数量") || '-' || TRIM(B."非车非农签单数量") || '=' ||
       TO_CHAR(A."非车非农签单数量" - B."非车非农签单数量") || '\n' || '农险签单数量差异(件):\n' ||
       TRIM(A."农险签单数量") || '-' || TRIM(B."农险签单数量") || '=' ||
       TO_CHAR(A."农险签单数量" - B."农险签单数量") || '\n'
       
       || '原始签单保费差异(万):\n' || TRIM(A."原始签单保费(万)") || '-' ||
       TRIM(B."原始签单保费(万)") || '=' || TO_CHAR(A."原始签单保费(万)" - B."原始签单保费(万)") || '\n' ||
       '车险签单保费差异(万):\n' || TRIM(A."车险签单保费(万)") || '-' ||
       TRIM(B."车险签单保费(万)") || '=' || TO_CHAR(A."车险签单保费(万)" - B."车险签单保费(万)") || '\n' ||
       '其中军车签单保费差异(万):\n' || TRIM(A."军车签单保费(万)") || '-' ||
       TRIM(B."军车签单保费(万)") || '=' || TO_CHAR(A."军车签单保费(万)" - B."军车签单保费(万)") || '\n' ||
       '非车非农签单保费差异(万):\n' || TRIM(A."非车非农签单保费(万)") || '-' ||
       TRIM(B."非车非农签单保费(万)") || '=' ||
       TO_CHAR(A."非车非农签单保费(万)" - B."非车非农签单保费(万)") || '\n' ||
       '农险签单保费差异(万):\n' || TRIM(A."农险签单保费(万)") || '-' ||
       TRIM(B."农险签单保费(万)") || '=' || TO_CHAR(A."农险签单保费(万)" - B."农险签单保费(万)") || '\n'

  FROM (SELECT '新核心' aa,
               NVL(COUNT(*), 0) "原始签单数量",
               NVL(COUNT(CASE
                           WHEN P1.RISKCODE LIKE '05%' THEN
                            BUSINESSNO
                         END),
                   0) "车险签单数量",
               NVL(COUNT(CASE
                           WHEN P1.RISKCODE LIKE '05%' AND
                                ((SUBSTR(P1.COMCODE, 1, 2) IN ('31', '11') AND
                                P2.LICENSEKINDCODE IN ('81', '82')) OR
                                (SUBSTR(P1.COMCODE, 1, 2) NOT IN ('31', '11') AND
                                P2.LICENSEKINDCODE IN ('31', '32'))) THEN
                            BUSINESSNO
                         END),
                   0) "军车签单数量",
               NVL(COUNT(CASE
                           WHEN P1.RISKCODE NOT LIKE '05%' AND
                                P1.RISKCODE NOT LIKE '3%' THEN
                            BUSINESSNO
                         END),
                   0) "非车非农签单数量",
               NVL(COUNT(CASE
                           WHEN P1.RISKCODE LIKE '3%' THEN
                            BUSINESSNO
                         END),
                   0) "农险签单数量",
               NVL(CAST(SUM(BAOFEI) / 10000 AS NUMBER(18, 2)), 0) "原始签单保费(万)",
               NVL(CAST(SUM(CASE
                              WHEN P1.RISKCODE LIKE '05%' THEN
                               BAOFEI
                            END) / 10000 AS NUMBER(18, 2)),
                   0) "车险签单保费(万)",
               NVL(CAST(SUM(CASE
                              WHEN P1.RISKCODE LIKE '05%' AND
                                   ((SUBSTR(P1.COMCODE, 1, 2) IN ('31', '11') AND
                                   P2.LICENSEKINDCODE IN ('81', '82')) OR
                                   (SUBSTR(P1.COMCODE, 1, 2) NOT IN ('31', '11') AND
                                   P2.LICENSEKINDCODE IN ('31', '32'))) THEN
                               BAOFEI
                            END) / 10000 AS NUMBER(18, 2)),
                   0) "军车签单保费(万)",
               NVL(CAST(SUM(CASE
                              WHEN P1.RISKCODE NOT LIKE '05%' AND
                                   P1.RISKCODE NOT LIKE '3%' THEN
                               BAOFEI
                            END) / 10000 AS NUMBER(18, 2)),
                   0) "非车非农签单保费(万)",
               NVL(CAST(SUM(CASE
                              WHEN P1.RISKCODE LIKE '3%' THEN
                               BAOFEI
                            END) / 10000 AS NUMBER(18, 2)),
                   0) "农险签单保费(万)"
          FROM BASVW.WEB_REALTIME_BUSINESS_INFO P1
          LEFT JOIN PODSVW.ODS_CITEMCAR P2
            ON P1.BUSINESSNO = P2.POLICYNO
         WHERE SUBSTR(P1.UNDERWRITEENDDATE, 1, 10) =
               TO_CHAR(DATE - 1, 'YYYY-MM-DD')
           AND SUBSTR(BUSINESSNO, 1, 2) = '66') a
  LEFT JOIN (SELECT '新核心' aa,
                    NVL(SUM(CASE
                              WHEN P1.RISKCODE LIKE '05%' AND P1.COINSFLAG = '4' THEN
                               0
                              ELSE
                               1
                            END),
                        0) "原始签单数量",
                    NVL(COUNT(CASE
                                WHEN P1.RISKCODE LIKE '05%' AND P1.COINSFLAG <> '4' THEN
                                 P1.POLICYNO
                              END),
                        0) "车险签单数量",
                    NVL(COUNT(CASE
                                WHEN P1.RISKCODE LIKE '05%' AND
                                     ((SUBSTR(P1.COMCODE, 1, 2) IN ('31', '11') AND
                                     P2.LICENSEKINDCODE IN ('81', '82')) OR
                                     (SUBSTR(P1.COMCODE, 1, 2) NOT IN ('31', '11') AND
                                     P2.LICENSEKINDCODE IN ('31', '32'))) THEN
                                 P1.POLICYNO
                              END),
                        0) "军车签单数量",
                    NVL(COUNT(CASE
                                WHEN P1.RISKCODE NOT LIKE '05%' AND
                                     P1.RISKCODE NOT LIKE '3%' THEN
                                 P1.POLICYNO
                              END),
                        0) "非车非农签单数量",
                    NVL(COUNT(CASE
                                WHEN P1.RISKCODE LIKE '3%' THEN
                                 P1.POLICYNO
                              END),
                        0) "农险签单数量",
                    NVL(CAST(SUM(SUMPREMIUM * P1.EXCHRATE * P1.COINSRATE / 100) /
                             10000 AS DECIMAL(18, 2)),
                        0) "原始签单保费(万)",
                    NVL(CAST(SUM(CASE
                                   WHEN P1.RISKCODE LIKE '05%' AND P1.COINSFLAG <> '4' THEN
                                    SUMPREMIUM * P1.EXCHRATE * P1.COINSRATE / 100
                                 END) / 10000 AS NUMBER(18, 2)),
                        0) "车险签单保费(万)",
                    NVL(CAST(SUM(CASE
                                   WHEN P1.RISKCODE LIKE '05%' AND
                                        ((SUBSTR(P1.COMCODE, 1, 2) IN ('31', '11') AND
                                        P2.LICENSEKINDCODE IN ('81', '82')) OR
                                        (SUBSTR(P1.COMCODE, 1, 2) NOT IN ('31', '11') AND
                                        P2.LICENSEKINDCODE IN ('31', '32'))) THEN
                                    SUMPREMIUM * P1.EXCHRATE * P1.COINSRATE / 100
                                 END) / 10000 AS NUMBER(18, 2)),
                        0) "军车签单保费(万)",
                    NVL(CAST(SUM(CASE
                                   WHEN P1.RISKCODE NOT LIKE '05%' AND
                                        P1.RISKCODE NOT LIKE '3%' THEN
                                    SUMPREMIUM * P1.EXCHRATE * P1.COINSRATE / 100
                                 END) / 10000 AS NUMBER(18, 2)),
                        0) "非车非农签单保费(万)",
                    NVL(CAST(SUM(CASE
                                   WHEN P1.RISKCODE LIKE '3%' THEN
                                    SUMPREMIUM * P1.EXCHRATE * P1.COINSRATE / 100
                                 END) / 10000 AS NUMBER(18, 2)),
                        0) "农险签单保费(万)"
               FROM PMIDVW.MID_CMAINORIGIN P1
               LEFT JOIN PODSVW.ODS_CITEMCAR P2
                 ON P1.POLICYNO = P2.POLICYNO
              WHERE TRUNC(P1.UNDERWRITEENDDATE, 'dd') = TRUNC(DATE - 1)
                AND SUBSTR(P1.POLICYNO, 1, 2) = '66') b
    ON a.aa = b.aa
UNION ALL
SELECT '3------------------------------------------------\n(老核心)实时-统计' AS CONTENT
  FROM PCDEVW.CD_CLASS
 GROUP BY 1
UNION ALL
SELECT '4原始签单数量差异(件):\n' || TRIM(A."原始签单数量") || '-' || TRIM(B."原始签单数量") || '=' ||
       TO_CHAR(A."原始签单数量" - B."原始签单数量") || '\n' || '车险签单数量差异(件):\n' ||
       TRIM(A."车险签单数量") || '-' || TRIM(B."车险签单数量") || '=' ||
       TO_CHAR(A."车险签单数量" - B."车险签单数量") || '\n' || '其中军车签单数量差异(件):\n' ||
       TRIM(A."军车签单数量") || '-' || TRIM(B."军车签单数量") || '=' ||
       TO_CHAR(A."军车签单数量" - B."军车签单数量") || '\n' || '非车非农签单数量差异(件):\n' ||
       TRIM(A."非车非农签单数量") || '-' || TRIM(B."非车非农签单数量") || '=' ||
       TO_CHAR(A."非车非农签单数量" - B."非车非农签单数量") || '\n' || '农险签单数量差异(件):\n' ||
       TRIM(A."农险签单数量") || '-' || TRIM(B."农险签单数量") || '=' ||
       TO_CHAR(A."农险签单数量" - B."农险签单数量") || '\n'
       
       || '原始签单保费差异(万):\n' || TRIM(A."原始签单保费(万)") || '-' ||
       TRIM(B."原始签单保费(万)") || '=' || TO_CHAR(A."原始签单保费(万)" - B."原始签单保费(万)") || '\n' ||
       '车险签单保费差异(万):\n' || TRIM(A."车险签单保费(万)") || '-' ||
       TRIM(B."车险签单保费(万)") || '=' || TO_CHAR(A."车险签单保费(万)" - B."车险签单保费(万)") || '\n' ||
       '其中军车签单保费差异(万):\n' || TRIM(A."军车签单保费(万)") || '-' ||
       TRIM(B."军车签单保费(万)") || '=' || TO_CHAR(A."军车签单保费(万)" - B."军车签单保费(万)") || '\n' ||
       '非车非农签单保费差异(万):\n' || TRIM(A."非车非农签单保费(万)") || '-' ||
       TRIM(B."非车非农签单保费(万)") || '=' ||
       TO_CHAR(A."非车非农签单保费(万)" - B."非车非农签单保费(万)") || '\n' ||
       '农险签单保费差异(万):\n' || TRIM(A."农险签单保费(万)") || '-' ||
       TRIM(B."农险签单保费(万)") || '=' || TO_CHAR(A."农险签单保费(万)" - B."农险签单保费(万)") || '\n'
  FROM (SELECT
        
         '老核心' aa,
         NVL(COUNT(*), 0) "原始签单数量",
         NVL(COUNT(CASE
                     WHEN P1.RISKCODE LIKE '05%' THEN
                      BUSINESSNO
                   END),
             0) "车险签单数量",
         NVL(COUNT(CASE
                     WHEN P1.RISKCODE LIKE '05%' AND
                          ((SUBSTR(P1.COMCODE, 1, 2) IN ('31', '11') AND
                          P2.LICENSEKINDCODE IN ('81', '82')) OR
                          (SUBSTR(P1.COMCODE, 1, 2) NOT IN ('31', '11') AND
                          P2.LICENSEKINDCODE IN ('31', '32'))) THEN
                      BUSINESSNO
                   END),
             0) "军车签单数量",
         NVL(COUNT(CASE
                     WHEN P1.RISKCODE NOT LIKE '05%' AND P1.RISKCODE NOT LIKE '3%' THEN
                      BUSINESSNO
                   END),
             0) "非车非农签单数量",
         NVL(COUNT(CASE
                     WHEN P1.RISKCODE LIKE '3%' THEN
                      BUSINESSNO
                   END),
             0) "农险签单数量",
         NVL(CAST(SUM(BAOFEI) / 10000 AS NUMBER(18, 2)), 0) "原始签单保费(万)",
         NVL(CAST(SUM(CASE
                        WHEN P1.RISKCODE LIKE '05%' THEN
                         BAOFEI
                      END) / 10000 AS NUMBER(18, 2)),
             0) "车险签单保费(万)",
         NVL(CAST(SUM(CASE
                        WHEN P1.RISKCODE LIKE '05%' AND
                             ((SUBSTR(P1.COMCODE, 1, 2) IN ('31', '11') AND
                             P2.LICENSEKINDCODE IN ('81', '82')) OR
                             (SUBSTR(P1.COMCODE, 1, 2) NOT IN ('31', '11') AND
                             P2.LICENSEKINDCODE IN ('31', '32'))) THEN
                         BAOFEI
                      END) / 10000 AS NUMBER(18, 2)),
             0) "军车签单保费(万)",
         NVL(CAST(SUM(CASE
                        WHEN P1.RISKCODE NOT LIKE '05%' AND P1.RISKCODE NOT LIKE '3%' THEN
                         BAOFEI
                      END) / 10000 AS NUMBER(18, 2)),
             0) "非车非农签单保费(万)",
         NVL(CAST(SUM(CASE
                        WHEN P1.RISKCODE LIKE '3%' THEN
                         BAOFEI
                      END) / 10000 AS NUMBER(18, 2)),
             0) "农险签单保费(万)"
          FROM BASVW.WEB_REALTIME_BUSINESS_INFO P1
          LEFT JOIN PODSVW.ODS_CITEMCAR P2
            ON P1.BUSINESSNO = P2.POLICYNO
         WHERE SUBSTR(P1.UNDERWRITEENDDATE, 1, 10) =
               TO_CHAR(DATE - 1, 'YYYY-MM-DD')
           AND SUBSTR(BUSINESSNO, 1, 1) = '8') a
  LEFT JOIN (SELECT '老核心' aa,
                    NVL(COUNT(*), 0) "原始签单数量",
                    NVL(COUNT(CASE
                                WHEN P1.RISKCODE LIKE '05%' THEN
                                 P1.POLICYNO
                              END),
                        0) "车险签单数量",
                    NVL(COUNT(CASE
                                WHEN P1.RISKCODE LIKE '05%' AND
                                     ((SUBSTR(P1.COMCODE, 1, 2) IN ('31', '11') AND
                                     P2.LICENSEKINDCODE IN ('81', '82')) OR
                                     (SUBSTR(P1.COMCODE, 1, 2) NOT IN ('31', '11') AND
                                     P2.LICENSEKINDCODE IN ('31', '32'))) THEN
                                 P1.POLICYNO
                              END),
                        0) "军车签单数量",
                    NVL(COUNT(CASE
                                WHEN P1.RISKCODE NOT LIKE '05%' AND
                                     P1.RISKCODE NOT LIKE '3%' THEN
                                 P1.POLICYNO
                              END),
                        0) "非车非农签单数量",
                    NVL(COUNT(CASE
                                WHEN P1.RISKCODE LIKE '3%' THEN
                                 P1.POLICYNO
                              END),
                        0) "农险签单数量",
                    NVL(CAST(SUM(PREMIUM * P1.EXCHRATE * P1.COINSRATE / 100) /
                             10000 AS DECIMAL(18, 2)),
                        0) "原始签单保费(万)",
                    NVL(CAST(SUM(CASE
                                   WHEN P1.RISKCODE LIKE '05%' THEN
                                    PREMIUM * P1.EXCHRATE * P1.COINSRATE / 100
                                 END) / 10000 AS NUMBER(18, 2)),
                        0) "车险签单保费(万)",
                    NVL(CAST(SUM(CASE
                                   WHEN P1.RISKCODE LIKE '05%' AND
                                        ((SUBSTR(P1.COMCODE, 1, 2) IN ('31', '11') AND
                                        P2.LICENSEKINDCODE IN ('81', '82')) OR
                                        (SUBSTR(P1.COMCODE, 1, 2) NOT IN ('31', '11') AND
                                        P2.LICENSEKINDCODE IN ('31', '32'))) THEN
                                    PREMIUM * P1.EXCHRATE * P1.COINSRATE / 100
                                 END) / 10000 AS NUMBER(18, 2)),
                        0) "军车签单保费(万)",
                    NVL(CAST(SUM(CASE
                                   WHEN P1.RISKCODE NOT LIKE '05%' AND
                                        P1.RISKCODE NOT LIKE '3%' THEN
                                    PREMIUM * P1.EXCHRATE * P1.COINSRATE / 100
                                 END) / 10000 AS NUMBER(18, 2)),
                        0) "非车非农签单保费(万)",
                    NVL(CAST(SUM(CASE
                                   WHEN P1.RISKCODE LIKE '3%' THEN
                                    PREMIUM * P1.EXCHRATE * P1.COINSRATE / 100
                                 END) / 10000 AS NUMBER(18, 2)),
                        0) "农险签单保费(万)"
               FROM BASVW.WEB_LIST_CMAINORIGIN P1
               LEFT JOIN PODSVW.ODS_CITEMCAR P2
                 ON P1.POLICYNO = P2.POLICYNO
              WHERE TRUNC(P1.UNDERWRITEENDDATE, 'dd') = TRUNC(DATE - 1)
                AND SUBSTR(P1.POLICYNO, 1, 1) = '8') b
    ON a.aa = b.aa
UNION ALL
SELECT '5******************************' AS CONTENT
  FROM PCDEVW.CD_CLASS
 GROUP BY 1
