-- ZB_DM_GSYWRNQNBFPM ZB_DM_归属业务人员当日签单保费排名

-- allrybf/日期
-- 取TOP20 按代理人当天出单保费和排序


-- 总公司
insert into ZB_DM.ZB_DM_REDIS.SET_VARCHAR
select
    CONCAT(
            'allrybf/'
        ,s1.`uwConclueDate`
        )                      as `key`
     ,CastToJsonArrayUDF(
        listagg(concat(
                     'com'      ,':'  ,`com`      ,','
                    ,'comname'  ,':'  ,`comname`  ,','
                    ,'id'       ,':'  ,`id`       ,','
                    ,'name'     ,':'  ,`name`     ,','
                    ,'cost'     ,':'  ,cast(s1.`cost` AS VARCHAR )
                    ),';')
    )                      as `val`
from (
         select
             *
         from(
                 select
                     d1.`uwConclueDate`                     as `uwConclueDate`
                      ,d1.`LEVEL1COMCODE`                     as `group_com`
                      ,d1.`LEVEL1COMCODE`                     as `com`
                      ,d1.`LEVEL1COMDESC`                     as `comname`
                      ,d1.`id`                                as `id`
                      ,d1.`name`                              as `name`
                      ,d1.`cost`                              as `cost`
                      ,ROW_NUMBER() OVER(PARTITION BY d1.`uwConclueDate` ORDER BY d1.`cost` DESC) as rownum
                 from (
                          select
                              `uwConclueDate`                            as `uwConclueDate`
                               ,`LEVEL1COMCODE`                           as `LEVEL1COMCODE`
                               ,`LEVEL1COMDESC`                           as `LEVEL1COMDESC`
                               ,`id`                                      as `id`
                               ,`name`                                    as `name`
                               ,sum(cast(`cost` as DECIMAL(18,2)))        as `cost`
                          from ZB_ODS.ZB_ODS_KAFKA.CBDATA 
                          where `COMNAME` is not null
                            and `uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
                          group by
                              `uwConclueDate`
                               ,`LEVEL1COMCODE`
                               ,`LEVEL1COMDESC`
                               ,`id`
                               ,`name`
                      ) d1
             ) c1
         where c1.rownum <= 20
     ) s1
group by
    s1.`uwConclueDate`
;



-- 分公司
insert into ZB_DM.ZB_DM_REDIS.SET_VARCHAR
select
    CONCAT(
            'provrybf/'
        ,s1.`uwConclueDate`
        ,'/',s1.`group_com`
        )                      as `key`
     ,CastToJsonArrayUDF(
        listagg(concat(
                     'com'      ,':'  ,`com`      ,','
                    ,'comname'  ,':'  ,`comname`  ,','
                    ,'city'     ,':'  ,`city`     ,','
                    ,'cityname' ,':'  ,`cityname` ,','
                    ,'id'       ,':'  ,`id`       ,','
                    ,'name'     ,':'  ,`name`     ,','
                    ,'cost'     ,':'  ,cast(s1.`cost` AS VARCHAR )
                    ),';')
       )                      as `val`
from (
         select
             *
         from(
                 select
                     d1.`uwConclueDate`                  as `uwConclueDate`
                      ,d1.`LEVEL1COMCODE`                  as `group_com`
                      ,d1.`LEVEL1COMCODE`                  as `com`
                      ,d1.`LEVEL1COMDESC`                  as `comname`
                      ,d1.`LEVEL2COMCODE`                  as `city`
                      ,d1.`LEVEL2COMDESC`                  as `cityname`
                      ,d1.`id`                             as `id`
                      ,d1.`name`                           as `name`
                      ,d1.`cost`                           as `cost`
                      ,ROW_NUMBER() OVER(PARTITION BY d1.`uwConclueDate`,d1.`LEVEL1COMCODE` ORDER BY d1.`cost` DESC) as rownum
                 from (
                          select
                              `uwConclueDate`                      as `uwConclueDate`
                               ,`LEVEL1COMCODE`                     as `LEVEL1COMCODE`
                               ,`LEVEL1COMDESC`                     as `LEVEL1COMDESC`
                               ,`LEVEL2COMCODE`                     as `LEVEL2COMCODE`
                               ,`LEVEL2COMDESC`                     as `LEVEL2COMDESC`
                               ,`id`                                as `id`
                               ,`name`                              as `name`
                               ,sum(cast(`cost` as DECIMAL(18,2)))  as `cost`
                          from ZB_ODS.ZB_ODS_KAFKA.CBDATA
                          where `COMNAME` is not null
                            and `uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
                          group by
                              `uwConclueDate`
                               ,`LEVEL1COMCODE`
                               ,`LEVEL1COMDESC`
                               ,`LEVEL2COMCODE`
                               ,`LEVEL2COMDESC`
                               ,`id`
                               ,`name`
                      ) d1
             ) c1
         where c1.rownum <= 20
     ) s1
group by
    s1.`uwConclueDate`
       ,s1.`group_com`
;


-- 中支
insert into ZB_DM.ZB_DM_REDIS.SET_VARCHAR
select
    CONCAT(
            'cityrybf/'
        ,s1.`uwConclueDate`
        ,'/',s1.`group_com`
        )                      as `key`
     ,CastToJsonArrayUDF(
        listagg(concat(
                        'com'         ,':'  ,`com`         ,','
                    ,'comname'     ,':'  ,`comname`     ,','
                    ,'city'        ,':'  ,`city`        ,','
                    ,'cityname'    ,':'  ,`cityname`    ,','
                    ,'country'     ,':'  ,`country`     ,','
                    ,'countryname' ,':'  ,`countryname` ,','
                    ,'id'          ,':'  ,`id`          ,','
                    ,'name'        ,':'  ,`name`        ,','
                    ,'cost'        ,':'  ,cast(s1.`cost` AS VARCHAR )
                    ),';')
    )                      as `val`
from (
         select
             *
         from(
                 select
                     d1.`uwConclueDate`                  as `uwConclueDate`
                      ,d1.`LEVEL2COMCODE`                  as `group_com`
                      ,d1.`LEVEL1COMCODE`                  as `com`
                      ,d1.`LEVEL1COMDESC`                  as `comname`
                      ,d1.`LEVEL2COMCODE`                  as `city`
                      ,d1.`LEVEL2COMDESC`                  as `cityname`
                      ,d1.`LEVEL3COMCODE`                  as `country`
                      ,d1.`LEVEL3COMDESC`                  as `countryname`
                      ,d1.`id`                             as `id`
                      ,d1.`name`                           as `name`
                      ,d1.`cost`                           as `cost`
                      ,ROW_NUMBER() OVER(PARTITION BY d1.`uwConclueDate`,d1.`LEVEL2COMCODE` ORDER BY d1.`cost` DESC) as rownum
                 from (
                          select
                              `uwConclueDate`                      as `uwConclueDate`
                               ,`LEVEL1COMCODE`                     as `LEVEL1COMCODE`
                               ,`LEVEL1COMDESC`                     as `LEVEL1COMDESC`
                               ,`LEVEL2COMCODE`                     as `LEVEL2COMCODE`
                               ,`LEVEL2COMDESC`                     as `LEVEL2COMDESC`
                               ,`LEVEL3COMCODE`                     as `LEVEL3COMCODE`
                               ,`LEVEL3COMDESC`                     as `LEVEL3COMDESC`
                               ,`id`                                as `id`
                               ,`name`                              as `name`
                               ,sum(cast(`cost` as DECIMAL(18,2)))  as `cost`
                          from ZB_ODS.ZB_ODS_KAFKA.CBDATA
                          where `COMNAME` is not null
                            and `uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
                          group by
                              `uwConclueDate`
                               ,`LEVEL1COMCODE`
                               ,`LEVEL1COMDESC`
                               ,`LEVEL2COMCODE`
                               ,`LEVEL2COMDESC`
                               ,`LEVEL3COMCODE`
                               ,`LEVEL3COMDESC`
                               ,`id`
                               ,`name`
                      ) d1
             ) c1
         where c1.rownum <= 20
     ) s1
group by
    s1.`uwConclueDate`
       ,s1.`group_com`
;

