-- ZB_DM_FYWLYBF_HB_NEW ZB_DM_分业务来源合并_NEW


-- step1：
-- 团队汇总
CREATE TEMPORARY VIEW VIEW_ZB_DM_FYWLYBF_HB_NEW_TUANDUI AS
SELECT
      a1.`uwConclueDate`                                                as `uwConclueDate`
     ,a1.`businessNatureCode`                                           as `businessNatureCode`
     ,a1.`LEVEL1COMCODE`                                                as `LEVEL1COMCODE`
     ,a1.`LEVEL2COMCODE`                                                as `LEVEL2COMCODE`
     ,a1.`LEVEL3COMCODE`                                                as `LEVEL3COMCODE`
     ,a1.`LEVEL4COMCODE`                                                as `LEVEL4COMCODE`
     ,a1.`startTime`                                                    as `startTime`  
     ,a1.`cost` + if(t1.cost is null ,0,cast(t1.cost as decimal(18,2))) as `cost`
from (
         SELECT
                s1.`uwConclueDate`                     as `uwConclueDate`
              , s1.`businessNatureCode`                as `businessNatureCode`
              , s1.`LEVEL1COMCODE`                     as `LEVEL1COMCODE`
              , s1.`LEVEL2COMCODE`                     as `LEVEL2COMCODE`
              , s1.`LEVEL3COMCODE`                     as `LEVEL3COMCODE`
              , s1.`LEVEL4COMCODE`                     as `LEVEL4COMCODE`
              , s1.`startTime`                         as `startTime`
              , sum(cast(s1.`cost` as DECIMAL(18, 2))) as `cost`
              , max(s1.proctime)                       as proctime
         from ZB_ODS.ZB_ODS_KAFKA.CBDATA s1
         where
             s1.`COMNAME` is not null
           and s1.`uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
           and LongTimeToStringUDF(s1.log_time,'yyyyMMdd HH') = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd HH')
         group by
             s1.`uwConclueDate`
             , s1.`businessNatureCode`
             , s1.`LEVEL1COMCODE`
             , s1.`LEVEL2COMCODE`
             , s1.`LEVEL3COMCODE`
             , s1.`LEVEL4COMCODE`
             , s1.`startTime`
     ) a1
left join ZB_DM.ZB_DM_MYSQL.TEAM_BUSINESS for system_time as of a1.proctime as t1
       on a1.`uwConclueDate`      = t1.`uwConclueDate`
      and a1.`businessNatureCode` = t1.`businessNatureCode`
      and a1.`LEVEL4COMCODE`      = t1.`LEVEL4COMCODE`
      and a1.`startTime`          = t1.`startTime`
;


-- ZB_DM_FYWLYBFNDQQB ZB_DM_分业务来源年底前起保保费
-- key:allywlybf/日期
-- 1、日期:核保日期或者核批完成日期(yyyyMMdd)
-- 2、起保时间小于等于当年

-- 总公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'allywlybf/'
        ,s1.`uwConclueDate`
        )                                       as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_FYWLYBF_HB_NEW_TUANDUI s1
where left(s1.`startTime`,4) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyy')
group by
    s1.`uwConclueDate`
    ,s1.`businessNatureCode`
;

-- 分公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'provywlybf/'
        ,s1.`uwConclueDate`
        ,'/'
        ,s1.`LEVEL1COMCODE`
        )                                       as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_FYWLYBF_HB_NEW_TUANDUI s1
where left(s1.`startTime`,4) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyy')
group by
    s1.`uwConclueDate`
    ,s1.`businessNatureCode`
    ,s1.`LEVEL1COMCODE`
;


-- 中支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'cityywlybf/'
        ,s1.`uwConclueDate`
        ,'/'
        ,s1.`LEVEL2COMCODE`
        )                                        as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_FYWLYBF_HB_NEW_TUANDUI s1
where left(s1.`startTime`,4) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyy')
group by
    s1.`uwConclueDate`
    ,s1.`businessNatureCode`
    ,s1.`LEVEL2COMCODE`
;


-- 县支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'countryywlybf/'
        ,s1.`uwConclueDate`
        ,'/'
        ,s1.`LEVEL3COMCODE`
        )                                       as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_FYWLYBF_HB_NEW_TUANDUI s1
where left(s1.`startTime`,4) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyy')
group by
    s1.`uwConclueDate`
    ,s1.`businessNatureCode`
    ,s1.`LEVEL3COMCODE`
;


-- 团队
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'teamywlybf/'
        ,s1.`uwConclueDate`
        ,'/'
        ,s1.`LEVEL4COMCODE`
        )                                       as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,cast(s1.`cost` as DECIMAL(18,2))       as `val`
from VIEW_ZB_DM_FYWLYBF_HB_NEW_TUANDUI s1
where left(s1.`startTime`,4) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyy')

;



-- ZB_DM_FYWLYBFJMQQB ZB_DM_分业务来源季末前起保保费
-- key:allquarterywlybf/日期
-- 1、日期:核保日期或者核批完成日期(yyyyMMdd)
-- 2、起保时间小于等于当季度

-- 总公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'allquarterywlybf/'
        ,s1.`uwConclueDate`
        )                                       as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_FYWLYBF_HB_NEW_TUANDUI s1
where CASE WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('01','02','03') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'03')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('04','05','06') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'06')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('07','08','09') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'09')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('10','11','12') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'12')
           END
group by 
    s1.`uwConclueDate`
    ,s1.`businessNatureCode`
;

-- 分公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'provquarterywlybf/'
        ,s1.`uwConclueDate`
        ,'/'
        ,s1.`LEVEL1COMCODE`
        )                                       as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_FYWLYBF_HB_NEW_TUANDUI s1
where CASE WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('01','02','03') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'03')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('04','05','06') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'06')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('07','08','09') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'09')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('10','11','12') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'12')
           END
group by 
    s1.`uwConclueDate`
    ,s1.`businessNatureCode`
    ,s1.`LEVEL1COMCODE` 
;


-- 中支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'cityquarterywlybf/'
        ,s1.`uwConclueDate`
        ,'/'
        ,s1.`LEVEL2COMCODE`
        )                                        as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_FYWLYBF_HB_NEW_TUANDUI s1
where CASE WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('01','02','03') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'03')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('04','05','06') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'06')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('07','08','09') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'09')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('10','11','12') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'12')
           END
group by
    s1.`uwConclueDate`
    ,s1.`businessNatureCode`
    ,s1.`LEVEL2COMCODE`
;


-- 县支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'countryquarterywlybf/'
        ,s1.`uwConclueDate`
        ,'/'
        ,s1.`LEVEL3COMCODE`
        )                                       as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_FYWLYBF_HB_NEW_TUANDUI s1
where CASE WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('01','02','03') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'03')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('04','05','06') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'06')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('07','08','09') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'09')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('10','11','12') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'12')
           END
group by
    s1.`uwConclueDate`
    ,s1.`businessNatureCode`
    ,s1.`LEVEL3COMCODE`
;


-- 团队
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'teamquarterywlybf/'
        ,s1.`uwConclueDate`
        ,'/'
        ,s1.`LEVEL4COMCODE`
        )                                       as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,cast(s1.`cost` as DECIMAL(18,2))       as `val`
from VIEW_ZB_DM_FYWLYBF_HB_NEW_TUANDUI s1
where CASE WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('01','02','03') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'03')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('04','05','06') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'06')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('07','08','09') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'09')
           WHEN DATE_FORMAT(LOCALTIMESTAMP,'MM') in ('10','11','12') THEN left(s1.`startTime`,6) <= CONCAT(DATE_FORMAT(LOCALTIMESTAMP,'yyyy'),'12')
           END
;



-- ZB_DM_FYWLYBFYDQQB ZB_DM_分业务来源月底前起保保费
-- key:allmonthywlybf/日期
-- 1、日期:核保日期或者核批完成日期(yyyyMMdd)
-- 2、起保时间小于等于当月

-- 总公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'allmonthywlybf/'
        ,s1.`uwConclueDate`
        )                                       as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_FYWLYBF_HB_NEW_TUANDUI s1
where left(s1.`startTime`,6) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyyMM')
group by
    s1.`uwConclueDate`
    ,s1.`businessNatureCode`
;

-- 分公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'provmonthywlybf/'
        ,s1.`uwConclueDate`
        ,'/'
        ,s1.`LEVEL1COMCODE`
        )                                       as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_FYWLYBF_HB_NEW_TUANDUI s1
where left(s1.`startTime`,6) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyyMM')
group by
    s1.`uwConclueDate`
    ,s1.`businessNatureCode`
    ,s1.`LEVEL1COMCODE`
;


-- 中支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'citymonthywlybf/'
        ,s1.`uwConclueDate`
        ,'/'
        ,s1.`LEVEL2COMCODE`
        )                                        as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_FYWLYBF_HB_NEW_TUANDUI s1
where left(s1.`startTime`,6) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyyMM')
group by
    s1.`uwConclueDate`
    ,s1.`businessNatureCode`
    ,s1.`LEVEL2COMCODE`
;


-- 县支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'countrymonthywlybf/'
        ,s1.`uwConclueDate`
        ,'/'
        ,s1.`LEVEL3COMCODE`
        )                                       as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_FYWLYBF_HB_NEW_TUANDUI s1
where left(s1.`startTime`,6) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyyMM')
group by
    s1.`uwConclueDate`
    ,s1.`businessNatureCode`
    ,s1.`LEVEL3COMCODE`
;


-- 团队
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'teammonthywlybf/'
        ,s1.`uwConclueDate`
        ,'/'
        ,s1.`LEVEL4COMCODE`
        )                                       as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,cast(s1.`cost` as DECIMAL(18,2))       as `val`
from VIEW_ZB_DM_FYWLYBF_HB_NEW_TUANDUI s1
where left(s1.`startTime`,6) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyyMM')

;



-- ZB_DM_FYWLYBFDRQDDRQB ZB_DM_分业务来源当日签单当日起保保费
-- key:alldayywlybf/日期
-- 1、日期:核保日期或者核批完成日期(yyyyMMdd)
-- 2、起保时间等于当日

-- 总公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'alldayywlybf/'
        ,s1.`uwConclueDate`
        )                                       as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_FYWLYBF_HB_NEW_TUANDUI s1
where left(s1.`startTime`,8) = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
group by
    s1.`uwConclueDate`
    ,s1.`businessNatureCode`
;

-- 分公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'provdayywlybf/'
        ,s1.`uwConclueDate`
        ,'/'
        ,s1.`LEVEL1COMCODE`
        )                                       as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_FYWLYBF_HB_NEW_TUANDUI s1
where left(s1.`startTime`,8) = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
group by
    s1.`uwConclueDate`
    ,s1.`businessNatureCode`
    ,s1.`LEVEL1COMCODE`
;


-- 中支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'citydayywlybf/'
        ,s1.`uwConclueDate`
        ,'/'
        ,s1.`LEVEL2COMCODE`
        )                                        as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_FYWLYBF_HB_NEW_TUANDUI s1
where left(s1.`startTime`,8) = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
group by
    s1.`uwConclueDate`
    ,s1.`businessNatureCode`
    ,s1.`LEVEL2COMCODE`
;


-- 县支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'countrydayywlybf/'
        ,s1.`uwConclueDate`
        ,'/'
        ,s1.`LEVEL3COMCODE`
        )                                       as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from VIEW_ZB_DM_FYWLYBF_HB_NEW_TUANDUI s1
where left(s1.`startTime`,8) = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
group by
    s1.`uwConclueDate`
    ,s1.`businessNatureCode`
    ,s1.`LEVEL3COMCODE`
;


-- 团队
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'teamdayywlybf/'
        ,s1.`uwConclueDate`
        ,'/'
        ,s1.`LEVEL4COMCODE`
        )                                       as `key`
     ,s1.`businessNatureCode`                as `hkey`
     ,cast(s1.`cost` as DECIMAL(18,2))       as `val`
from VIEW_ZB_DM_FYWLYBF_HB_NEW_TUANDUI s1
where left(s1.`startTime`,8) = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')


;