-- ZB_DM_GSYWRNQNBFPM_NEW ZB_DM_归属业务人员当日签单保费排名_NEW

-- allrybf/日期
-- 取TOP20

-- step1：
-- 视图
CREATE TEMPORARY VIEW VIEW_ZB_DM_GSYWRNQNBFPM_NEW AS
select
      a1.`uwConclueDate`                                                as `uwConclueDate`
     ,a1.`LEVEL1COMCODE`                                                as `LEVEL1COMCODE`
     ,a1.`LEVEL2COMCODE`                                                as `LEVEL2COMCODE`
     ,a1.`LEVEL3COMCODE`                                                as `LEVEL3COMCODE`
     ,a1.`id`                                                           as `id`
     ,a1.`name`                                                         as `name`
     ,a1.`startTime`                                                    as `startTime`
     ,a1.`cost` + if(t1.cost is null ,0,cast(t1.cost as decimal(18,2))) as `cost`
from (
         select
              s1.`uwConclueDate`                     as `uwConclueDate`
             ,s1.`LEVEL1COMCODE`                     as `LEVEL1COMCODE`
             ,s1.`LEVEL2COMCODE`                     as `LEVEL2COMCODE`
             ,s1.`LEVEL3COMCODE`                     as `LEVEL3COMCODE`
             ,s1.`id`                                as `id`
             ,s1.`name`                              as `name`
             ,s1.`startTime`                         as `startTime`
             ,sum(cast(s1.`cost` as DECIMAL(18, 2))) as `cost`
             ,max(s1.proctime)                       as proctime
        from ZB_ODS.ZB_ODS_KAFKA.CBDATA s1
        where
               s1.`COMNAME` is not null
           and s1.`uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
           and LongTimeToStringUDF(s1.log_time,'yyyyMMdd HH') = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd HH')
         group by
               s1.`uwConclueDate`
             , s1.`LEVEL1COMCODE`
             , s1.`LEVEL2COMCODE`
             , s1.`LEVEL3COMCODE`
             , s1.`id`
             , s1.`name`
     ) a1
left join ZB_DM.ZB_DM_MYSQL.TEAM_CLASSCODE for system_time as of a1.proctime as t1
       on a1.`uwConclueDate` = t1.`uwConclueDate`
      and a1.`LEVEL3COMCODE` = t1.`LEVEL3COMCODE`
      and a1.`startTime`     = t1.`startTime`
      and a1.`id`            = t1.`id`
      and a1.`name`          = t1.`name`
;



-- 总公司
insert into ZB_DM.ZB_DM_REDIS.SET_VARCHAR
select
    CONCAT(
            'allrybf/'
        ,s1.`uwConclueDate`
        )                      as `key`
     ,CastToJsonArrayUDF(
        listagg(concat(
                     'com'      ,':'  ,`com`      ,','
                    ,'comname'  ,':'  ,`comname`  ,','
                    ,'id'       ,':'  ,`id`       ,','
                    ,'name'     ,':'  ,`name`     ,','
                    ,'cost'     ,':'  ,cast(s1.`cost` AS VARCHAR )
                    ),';')
    )                      as `val`
from (
         select
             *
         from(
                 select
                     d1.`uwConclueDate`                     as `uwConclueDate`
                      ,d1.`LEVEL1COMCODE`                     as `group_com`
                      ,d1.`LEVEL1COMCODE`                     as `com`
                      ,d1.`LEVEL1COMDESC`                     as `comname`
                      ,d1.`id`                                as `id`
                      ,d1.`name`                              as `name`
                      ,d1.`cost`                              as `cost`
                      ,ROW_NUMBER() OVER(PARTITION BY d1.`uwConclueDate` ORDER BY d1.`cost` DESC) as rownum
                 from (
                          select
                              `uwConclueDate`                            as `uwConclueDate`
                               ,`LEVEL1COMCODE`                           as `LEVEL1COMCODE`
                               ,`LEVEL1COMDESC`                           as `LEVEL1COMDESC`
                               ,`id`                                      as `id`
                               ,`name`                                    as `name`
                               ,sum(cast(`cost` as DECIMAL(18,2)))        as `cost`
                          from VIEW_ZB_DM_GSYWRNQNBFPM_NEW
                          group by
                              `uwConclueDate`
                                 ,`LEVEL1COMCODE`
                                 ,`LEVEL1COMDESC`
                                 ,`id`
                                 ,`name`
                      ) d1
             ) c1
         where c1.rownum <= 20
     ) s1
group by
    s1.`uwConclueDate`
;



-- 分公司
insert into ZB_DM.ZB_DM_REDIS.SET_VARCHAR
select
    CONCAT(
            'provrybf/'
        ,s1.`uwConclueDate`
        ,'/',s1.`group_com`
        )                      as `key`
     ,CastToJsonArrayUDF(
        listagg(concat(
                     'com'      ,':'  ,`com`      ,','
                    ,'comname'  ,':'  ,`comname`  ,','
                    ,'city'     ,':'  ,`city`     ,','
                    ,'cityname' ,':'  ,`cityname` ,','
                    ,'id'       ,':'  ,`id`       ,','
                    ,'name'     ,':'  ,`name`     ,','
                    ,'cost'     ,':'  ,cast(s1.`cost` AS VARCHAR )
                    ),';')
       )                      as `val`
from (
         select
             *
         from(
                 select
                     d1.`uwConclueDate`                  as `uwConclueDate`
                      ,d1.`LEVEL1COMCODE`                  as `group_com`
                      ,d1.`LEVEL1COMCODE`                  as `com`
                      ,d1.`LEVEL1COMDESC`                  as `comname`
                      ,d1.`LEVEL2COMCODE`                  as `city`
                      ,d1.`LEVEL2COMDESC`                  as `cityname`
                      ,d1.`id`                             as `id`
                      ,d1.`name`                           as `name`
                      ,d1.`cost`                           as `cost`
                      ,ROW_NUMBER() OVER(PARTITION BY d1.`uwConclueDate`,d1.`LEVEL1COMCODE` ORDER BY d1.`cost` DESC) as rownum
                 from (
                          select
                              `uwConclueDate`                      as `uwConclueDate`
                               ,`LEVEL1COMCODE`                     as `LEVEL1COMCODE`
                               ,`LEVEL1COMDESC`                     as `LEVEL1COMDESC`
                               ,`LEVEL2COMCODE`                     as `LEVEL2COMCODE`
                               ,`LEVEL2COMDESC`                     as `LEVEL2COMDESC`
                               ,`id`                                as `id`
                               ,`name`                              as `name`
                               ,sum(cast(`cost` as DECIMAL(18,2)))  as `cost`
                          from VIEW_ZB_DM_GSYWRNQNBFPM_NEW a1
                          group by
                              `uwConclueDate`
                                 ,`LEVEL1COMCODE`
                                 ,`LEVEL1COMDESC`
                                 ,`LEVEL2COMCODE`
                                 ,`LEVEL2COMDESC`
                                 ,`id`
                                 ,`name`
                      ) d1
             ) c1
         where c1.rownum <= 20
     ) s1
group by
    s1.`uwConclueDate`
       ,s1.`group_com`
;


-- 中支
insert into ZB_DM.ZB_DM_REDIS.SET_VARCHAR
select
    CONCAT(
            'cityrybf/'
        ,s1.`uwConclueDate`
        ,'/',s1.`group_com`
        )                      as `key`
     ,CastToJsonArrayUDF(
        listagg(concat(
                        'com'         ,':'  ,`com`         ,','
                    ,'comname'     ,':'  ,`comname`     ,','
                    ,'city'        ,':'  ,`city`        ,','
                    ,'cityname'    ,':'  ,`cityname`    ,','
                    ,'country'     ,':'  ,`country`     ,','
                    ,'countryname' ,':'  ,`countryname` ,','
                    ,'id'          ,':'  ,`id`          ,','
                    ,'name'        ,':'  ,`name`        ,','
                    ,'cost'        ,':'  ,cast(s1.`cost` AS VARCHAR )
                    ),';')
    )                      as `val`
from (
         select
             *
         from(
                 select
                     d1.`uwConclueDate`                  as `uwConclueDate`
                      ,d1.`LEVEL2COMCODE`                  as `group_com`
                      ,d1.`LEVEL1COMCODE`                  as `com`
                      ,d1.`LEVEL1COMDESC`                  as `comname`
                      ,d1.`LEVEL2COMCODE`                  as `city`
                      ,d1.`LEVEL2COMDESC`                  as `cityname`
                      ,d1.`LEVEL3COMCODE`                  as `country`
                      ,d1.`LEVEL3COMDESC`                  as `countryname`
                      ,d1.`id`                             as `id`
                      ,d1.`name`                           as `name`
                      ,d1.`cost`                           as `cost`
                      ,ROW_NUMBER() OVER(PARTITION BY d1.`uwConclueDate`,d1.`LEVEL2COMCODE` ORDER BY d1.`cost` DESC) as rownum
                 from (
                          select
                              `uwConclueDate`                      as `uwConclueDate`
                               ,`LEVEL1COMCODE`                     as `LEVEL1COMCODE`
                               ,`LEVEL1COMDESC`                     as `LEVEL1COMDESC`
                               ,`LEVEL2COMCODE`                     as `LEVEL2COMCODE`
                               ,`LEVEL2COMDESC`                     as `LEVEL2COMDESC`
                               ,`LEVEL3COMCODE`                     as `LEVEL3COMCODE`
                               ,`LEVEL3COMDESC`                     as `LEVEL3COMDESC`
                               ,`id`                                as `id`
                               ,`name`                              as `name`
                               ,sum(cast(`cost` as DECIMAL(18,2)))  as `cost`
                          from VIEW_ZB_DM_GSYWRNQNBFPM_NEW a1
                          group by
                              `uwConclueDate`
                                 ,`LEVEL1COMCODE`
                                 ,`LEVEL1COMDESC`
                                 ,`LEVEL2COMCODE`
                                 ,`LEVEL2COMDESC`
                                 ,`LEVEL3COMCODE`
                                 ,`LEVEL3COMDESC`
                                 ,`id`
                                 ,`name`
                      ) d1
             ) c1
         where c1.rownum <= 20
     ) s1
group by
    s1.`uwConclueDate`
       ,s1.`group_com`
;

