-- ZB_DM_CAR_HB_NEW ZB_DM_车险_NEW


-- step1：
-- 团队汇总
CREATE TEMPORARY VIEW VIEW_ZB_DM_CAR_HB_NEW AS 
SELECT 
     a1.`uwConclueDate`                                                as `uwConclueDate`
    ,a1.`LEVEL1COMCODE`                                                as `LEVEL1COMCODE`                 
    ,a1.`LEVEL2COMCODE`                                                as `LEVEL2COMCODE`                 
    ,a1.`LEVEL3COMCODE`                                                as `LEVEL3COMCODE`
    ,a1.`risk`                                                         as `risk`
    ,a1.`chnl`                                                         as `chnl`
    ,a1.`startTime`                                                    as `startTime`
    ,a1.`cost` + if(t1.cost is null ,0,cast(t1.cost as decimal(18,2))) as `cost`
from (
         SELECT
               s1.`uwConclueDate`                     as `uwConclueDate`
             , s1.`LEVEL1COMCODE`                     as `LEVEL1COMCODE`
             , s1.`LEVEL2COMCODE`                     as `LEVEL2COMCODE`
             , s1.`LEVEL3COMCODE`                     as `LEVEL3COMCODE`
             , s1.`risk`                              as `risk`
             , s1.`chnl`                              as `chnl`
             , s1.`startTime`                         as `startTime`
             , sum(cast(s1.`cost` as DECIMAL(18, 2))) as `cost`
             , max(s1.proctime)                       as proctime
         from ZB_ODS.ZB_ODS_KAFKA.CBDATA s1
         where
             s1.`COMNAME` is not null
           and s1.`uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
           and left(s1.`startTime`,4) <= DATE_FORMAT(LOCALTIMESTAMP,'yyyy')
           and left(s1.risk,2) ='05'
           and LongTimeToStringUDF(s1.log_time,'yyyyMMdd HH') = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd HH')
         group by
             s1.`uwConclueDate`
             , s1.`LEVEL1COMCODE`
             , s1.`LEVEL2COMCODE`
             , s1.`LEVEL3COMCODE`
             , s1.`risk`
             , s1.`chnl`
             , s1.`startTime`
     ) a1
left join ZB_DM.ZB_DM_MYSQL.TEAM_CAR for system_time as of a1.proctime as t1
       on a1.`uwConclueDate` = t1.`uwConclueDate`
      and a1.`LEVEL3COMCODE` = t1.`LEVEL3COMCODE`
      and a1.`risk`          = t1.`risk`
      and a1.`chnl`          = t1.`chnl`
;

-- ZB_DM_QDBF_CAR/ZB_DM_车险今日签单保费
-- key:allcarqbbf/日期
-- 1、日期:核保日期或者核批完成日期(yyyyMMdd)
-- 2、车险

--  总公司
insert into ZB_DM.ZB_DM_REDIS.SET_DECIMAL
select
    CONCAT(
            'allcarqdbf/'
        ,s1.`uwConclueDate`
        )                                       as `key`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from (
         SELECT
             d1.`uwConclueDate`                    as `uwConclueDate`
              ,d1.`LEVEL1COMCODE`                    as `LEVEL1COMCODE`
              ,d1.`LEVEL2COMCODE`                    as `LEVEL2COMCODE`
              ,d1.`LEVEL3COMCODE`                    as `LEVEL3COMCODE`
              ,d1.`LEVEL4COMCODE`                    as `LEVEL4COMCODE`
              ,d1.`risk`                             as `risk`
              ,sum(cast(s1.`cost` as DECIMAL(18,2))) as `cost`
         from VIEW_ZB_DM_CAR_HB_NEW d1
         group by
             d1.`uwConclueDate`
             ,d1.`LEVEL1COMCODE`
             ,d1.`LEVEL2COMCODE`
             ,d1.`LEVEL3COMCODE`
             ,d1.`LEVEL4COMCODE`
             ,d1.`risk`
     ) s1
group by
    s1.`uwConclueDate`
;

-- 分公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'provcarqdbf/'
        ,s1.`uwConclueDate`
        )                                       as `key`
     ,s1.`LEVEL1COMCODE`                     as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from (
         SELECT
             d1.`uwConclueDate`                    as `uwConclueDate`
            ,d1.`LEVEL1COMCODE`                    as `LEVEL1COMCODE`
            ,d1.`LEVEL2COMCODE`                    as `LEVEL2COMCODE`
            ,d1.`LEVEL3COMCODE`                    as `LEVEL3COMCODE`
            ,d1.`LEVEL4COMCODE`                    as `LEVEL4COMCODE`
            ,d1.`risk`                             as `risk`
            ,sum(cast(s1.`cost` as DECIMAL(18,2))) as `cost`
         from VIEW_ZB_DM_CAR_HB_NEW d1
         group by
             d1.`uwConclueDate`
            ,d1.`LEVEL1COMCODE`
            ,d1.`LEVEL2COMCODE`
            ,d1.`LEVEL3COMCODE`
            ,d1.`LEVEL4COMCODE`
            ,d1.`risk`
     ) s1
group by
    s1.`uwConclueDate`
       ,s1.`LEVEL1COMCODE`
;

-- 中支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'citycarqdbf/'
        ,s1.`uwConclueDate`
        )                                    as `key`
     ,s1.`LEVEL2COMCODE`                     as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from (
         SELECT
             d1.`uwConclueDate`                    as `uwConclueDate`
            ,d1.`LEVEL1COMCODE`                    as `LEVEL1COMCODE`
            ,d1.`LEVEL2COMCODE`                    as `LEVEL2COMCODE`
            ,d1.`LEVEL3COMCODE`                    as `LEVEL3COMCODE`
            ,d1.`LEVEL4COMCODE`                    as `LEVEL4COMCODE`
            ,d1.`risk`                             as `risk`
            ,sum(cast(s1.`cost` as DECIMAL(18,2))) as `cost`
         from VIEW_ZB_DM_CAR_HB_NEW d1
         group by
             d1.`uwConclueDate`
            ,d1.`LEVEL1COMCODE`
            ,d1.`LEVEL2COMCODE`
            ,d1.`LEVEL3COMCODE`
            ,d1.`LEVEL4COMCODE`
            ,d1.`risk`
     ) s1
group by
    s1.`uwConclueDate`
       ,s1.`LEVEL2COMCODE`
;


-- 县支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'countycarqdbf/'
        ,s1.`uwConclueDate`
        )                                    as `key`
     ,s1.`LEVEL3COMCODE`                     as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))  as `val`
from (
         SELECT
             d1.`uwConclueDate`                    as `uwConclueDate`
            ,d1.`LEVEL1COMCODE`                    as `LEVEL1COMCODE`
            ,d1.`LEVEL2COMCODE`                    as `LEVEL2COMCODE`
            ,d1.`LEVEL3COMCODE`                    as `LEVEL3COMCODE`
            ,d1.`LEVEL4COMCODE`                    as `LEVEL4COMCODE`
            ,d1.`risk`                             as `risk`
            ,sum(cast(s1.`cost` as DECIMAL(18,2))) as `cost`
         from VIEW_ZB_DM_CAR_HB_NEW d1
         group by
             d1.`uwConclueDate`
            ,d1.`LEVEL1COMCODE`
            ,d1.`LEVEL2COMCODE`
            ,d1.`LEVEL3COMCODE`
            ,d1.`LEVEL4COMCODE`
            ,d1.`risk`
     ) s1
group by
    s1.`uwConclueDate`
       ,s1.`LEVEL3COMCODE`
;


-- 团队
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'teamcarqdbf/'
        ,s1.`uwConclueDate`
        )                                as `key`
     ,s1.`LEVEL4COMCODE`                 as `hkey`
     ,cast(s1.`cost` as DECIMAL(18,2))   as `val`
from (
         SELECT
             d1.`uwConclueDate`                    as `uwConclueDate`
            ,d1.`LEVEL1COMCODE`                    as `LEVEL1COMCODE`
            ,d1.`LEVEL2COMCODE`                    as `LEVEL2COMCODE`
            ,d1.`LEVEL3COMCODE`                    as `LEVEL3COMCODE`
            ,d1.`LEVEL4COMCODE`                    as `LEVEL4COMCODE`
            ,d1.`risk`                             as `risk`
            ,sum(cast(s1.`cost` as DECIMAL(18,2))) as `cost`
         from VIEW_ZB_DM_CAR_HB_NEW d1
         group by
             d1.`uwConclueDate`
            ,d1.`LEVEL1COMCODE`
            ,d1.`LEVEL2COMCODE`
            ,d1.`LEVEL3COMCODE`
            ,d1.`LEVEL4COMCODE`
            ,d1.`risk`
     ) s1
;


-- ZB_DM_CXCBDD ZB_DM_车险承保大单
-- bigcbd/日期
-- 核保或者核批时间在今天，按照保费或者未决赔款排序，取前10，车险riskcode 05开头，其他为非车，

-- 总公司
insert into ZB_DM.ZB_DM_REDIS.SET_VARCHAR
select
    CONCAT(
            'bigcbd/'
        ,s1.`uwConclueDate`
        )                      as `key`
     ,CastToJsonArrayUDF(
        listagg(concat(
                        'com'      ,':'  ,`com`      ,','
                    ,'comname'  ,':'  ,`comname`  ,','
                    ,'risk'     ,':'  ,`risk`     ,','
                    ,'riskname' ,':'  ,`riskname` ,','
                    ,'chnl'     ,':'  ,`chnl`     ,','
                    ,'chnlname' ,':'  ,`chnlname` ,','
                    ,'cost'     ,':'  ,cast(`cost` as varchar) ,','
                    ,'no'       ,':'  ,`no`
                    ),';')
    )                      as `val`
from (
         select
             *
         from(
                 select
                     d1.`uwConclueDate`                      as `uwConclueDate`
                    ,d1.`LEVEL1COMCODE`                     as `com`
                    ,d1.`LEVEL1COMDESC`                     as `comname`
                    ,d1.`risk`                              as `risk`
                    ,d1.`riskname`                          as `riskname`
                    ,d1.`chnl`                              as `chnl`
                    ,d1.`chnlname`                          as `chnlname`
                    ,cast(d1.`cost` as decimal(18,2))       as `cost`
                    ,d1.`no`                                as `no`
                    ,ROW_NUMBER() OVER(PARTITION BY d1.`uwConclueDate` ORDER BY d1.`cost` DESC) as rownum
                 from VIEW_ZB_DM_CAR_HB_NEW d1
             ) c1
         where c1.rownum <= 20
     ) s1
group by
    s1.`uwConclueDate`
;



-- 分公司
insert into ZB_DM.ZB_DM_REDIS.SET_VARCHAR
select
    CONCAT(
            'bigccitybd/'
        ,s1.`uwConclueDate`
        ,'/',s1.`group_com`
        )                      as `key`
     ,CastToJsonArrayUDF(
        listagg(concat(
                        'com'      ,':'  ,`com`      ,','
                    ,'comname'  ,':'  ,`comname`  ,','
                    ,'city'     ,':'  ,`city`     ,','
                    ,'cityname' ,':'  ,`cityname` ,','
                    ,'risk'     ,':'  ,`risk`     ,','
                    ,'riskname' ,':'  ,`riskname` ,','
                    ,'chnl'     ,':'  ,`chnl`     ,','
                    ,'chnlname' ,':'  ,`chnlname` ,','
                    ,'cost'     ,':'  ,cast(`cost` as varchar)     ,','
                    ,'no'       ,':'  ,`no`
                    ),';')
    )                      as `val`
from (
         select
             *
         from (
                  select
                        d1.`uwConclueDate`                     as `uwConclueDate`
                       ,d1.`LEVEL1COMCODE`                     as `group_com`
                       ,d1.`LEVEL1COMCODE`                     as `com`
                       ,d1.`LEVEL1COMDESC`                     as `comname`
                       ,d1.`LEVEL2COMCODE`                     as `city`
                       ,d1.`LEVEL2COMDESC`                     as `cityname`
                       ,d1.`risk`                              as `risk`
                       ,d1.`riskname`                          as `riskname`
                       ,d1.`chnl`                              as `chnl`
                       ,d1.`chnlname`                          as `chnlname`
                       ,cast(d1.`cost` as decimal(18,2))       as `cost`
                       ,d1.`no`                                as `no`
                       ,ROW_NUMBER() OVER(PARTITION BY d1.`LEVEL1COMCODE`,d1.`uwConclueDate` ORDER BY d1.`cost` DESC) as rownum
                  from VIEW_ZB_DM_CAR_HB_NEW d1
              ) c1
         where c1.rownum <= 20
     ) s1
group by
    s1.`uwConclueDate`
       ,s1.`group_com`
;


-- 中支
insert into ZB_DM.ZB_DM_REDIS.SET_VARCHAR
select
    CONCAT(
            'bigccountrybd/'
        ,s1.`uwConclueDate`
        ,'/',s1.`group_com`
        )                      as `key`
     ,CastToJsonArrayUDF(
        listagg(concat(
                        'com'         ,':'  ,`com`         ,','
                    ,'comname'     ,':'  ,`comname`     ,','
                    ,'city'        ,':'  ,`city`        ,','
                    ,'cityname'    ,':'  ,`cityname`    ,','
                    ,'country'     ,':'  ,`country`     ,','
                    ,'countryname' ,':'  ,`countryname` ,','
                    ,'risk'        ,':'  ,`risk`        ,','
                    ,'riskname'    ,':'  ,`riskname`    ,','
                    ,'chnl'        ,':'  ,`chnl`        ,','
                    ,'chnlname'    ,':'  ,`chnlname`    ,','
                    ,'cost'        ,':'  ,cast(`cost` as varchar) ,','
                    ,'no'          ,':'  ,`no`
                    ),';')
    )                         as `val`
from (
         select
             *
         from (
                  select
                        d1.`uwConclueDate`                     as `uwConclueDate`
                       ,d1.`LEVEL2COMCODE`                     as `group_com`
                       ,d1.`LEVEL1COMCODE`                     as `com`
                       ,d1.`LEVEL1COMDESC`                     as `comname`
                       ,d1.`LEVEL2COMCODE`                     as `city`
                       ,d1.`LEVEL2COMDESC`                     as `cityname`
                       ,d1.`LEVEL3COMCODE`                     as `country`
                       ,d1.`LEVEL3COMDESC`                     as `countryname`
                       ,d1.`risk`                              as `risk`
                       ,d1.`riskname`                          as `riskname`
                       ,d1.`chnl`                              as `chnl`
                       ,d1.`chnlname`                          as `chnlname`
                       ,cast(d1.`cost` as decimal(18,2))       as `cost`
                       ,d1.`no`                                as `no`
                       ,ROW_NUMBER() OVER(PARTITION BY d1.`LEVEL2COMCODE`,d1.`uwConclueDate` ORDER BY d1.`cost` DESC) as rownum
                  from VIEW_ZB_DM_CAR_HB_NEW d1
              ) c1
         where c1.rownum <= 20
     ) s1
group by
    s1.`uwConclueDate`
       ,s1.`group_com`
;