-- ZB_DM_JRQDBF ZB_DM_今日签单保费
-- key:allqdbf/日期
-- 1、日期:核保日期或者核批完成日期(yyyyMMdd)



-- step1：
-- 团队汇总
CREATE TEMPORARY VIEW VIEW_ZB_DM_JRQDBF_TUANDUI AS 
SELECT 
      s1.`uwConclueDate`                     as `uwConclueDate`
    , s1.`LEVEL1COMCODE`                     as `LEVEL1COMCODE`
    , s1.`LEVEL2COMCODE`                     as `LEVEL2COMCODE`
    , s1.`LEVEL3COMCODE`                     as `LEVEL3COMCODE`
    , s1.`LEVEL4COMCODE`                     as `LEVEL4COMCODE`
    , s1.`startTime`                         as `startTime`
    , sum(cast(s1.`cost` as DECIMAL(18, 2))) as `cost`
from (
    select
         *
         ,ROW_NUMBER() OVER(PARTITION BY `no`,`COMCODE`,`cost` ORDER BY `uwConclueDate` DESC) as rownum
    from ZB_ODS.ZB_ODS_KAFKA.CBDATA
    where
        `COMNAME` is not null
      and `uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
    ) s1
where s1.rownum = 1
group by
       s1.`uwConclueDate`
       , s1.`LEVEL1COMCODE`
       , s1.`LEVEL2COMCODE`
       , s1.`LEVEL3COMCODE`
       , s1.`LEVEL4COMCODE`
       , s1.`startTime`
;

-- ZB_DM_JRQDBF ZB_DM_今日签单保费
-- key:allqdbf/日期
-- 1、日期:核保日期或者核批完成日期(yyyyMMdd)

-- 总公司 
insert into ZB_DM.ZB_DM_REDIS.SET_DECIMAL
select 
    CONCAT(
        'allqdbf/'
        ,s1.`uwConclueDate`
    )                                      as `key`
    ,sum(cast(s1.`cost` as DECIMAL(18,2))) as `val` 
from VIEW_ZB_DM_JRQDBF_TUANDUI s1
group by 
    s1.`uwConclueDate`
;

-- 分公司
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select 
    CONCAT(
        'provqdbf/'
        ,s1.`uwConclueDate`
    )                                      as `key`
    ,s1.`LEVEL1COMCODE`                    as `hkey` 
    ,sum(cast(s1.`cost` as DECIMAL(18,2))) as `val` 
from VIEW_ZB_DM_JRQDBF_TUANDUI s1
group by 
     s1.`uwConclueDate`
    ,s1.`LEVEL1COMCODE`
;


-- 中支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'cityqdbf/'
        ,s1.`uwConclueDate`
        )                                     as `key`
     ,s1.`LEVEL2COMCODE`                      as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))   as `val`
from VIEW_ZB_DM_JRQDBF_TUANDUI s1
group by
    s1.`uwConclueDate`
   ,s1.`LEVEL2COMCODE`
;

-- 县支
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'countryqdbf/'
        ,s1.`uwConclueDate`
        )                                     as `key`
     ,s1.`LEVEL3COMCODE`                      as `hkey`
     ,sum(cast(s1.`cost` as DECIMAL(18,2)))   as `val`
from VIEW_ZB_DM_JRQDBF_TUANDUI s1
group by
    s1.`uwConclueDate`
    ,s1.`LEVEL3COMCODE`
;

-- 团队
insert into ZB_DM.ZB_DM_REDIS.HSET_DECIMAL
select
    CONCAT(
            'teamqdbf/'
        ,s1.`uwConclueDate`
        )                                   as `key`
     ,s1.`LEVEL4COMCODE`                    as `hkey`
     ,cast(s1.`cost` as DECIMAL(18,2))      as `val`
from VIEW_ZB_DM_JRQDBF_TUANDUI s1
;