-- ZB_DM_FCXCBDD ZB_DM_非车险承保大单
-- bigfcbd/日期
-- 核保或者核批时间在今天，按照保费或者未决赔款排序，取前10，车险riskcode 05开头，其他为非车，


-- 去重
CREATE TEMPORARY VIEW VIEW_ZB_DM_FCXCBDD AS
select
    *
from (
         select
             `uwConclueDate`                      as `uwConclueDate`
              ,`LEVEL1COMCODE`                     as `LEVEL1COMCODE`
              ,`LEVEL1COMDESC`                     as `LEVEL1COMDESC`
              ,`LEVEL2COMCODE`                     as `LEVEL2COMCODE`
              ,`LEVEL2COMDESC`                     as `LEVEL2COMDESC`
              ,`LEVEL3COMCODE`                     as `LEVEL3COMCODE`
              ,`LEVEL3COMDESC`                     as `LEVEL3COMDESC`
              ,`risk`                              as `risk`
              ,`riskname`                          as `riskname`
              ,`chnl`                              as `chnl`
              ,`chnlname`                          as `chnlname`
              ,cast(`cost` as decimal(18,2))       as `cost`
              ,`no`                                as `no`
              ,ROW_NUMBER() OVER(PARTITION BY `no`,`COMCODE`,`cost` ORDER BY `uwConclueDate` DESC) as rownum
         from ZB_ODS.ZB_ODS_KAFKA.CBDATA
         where
             `COMNAME` is not null
           and `uwConclueDate` = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
     ) s1
where s1.rownum = 1
;




-- 总公司
insert into ZB_DM.ZB_DM_REDIS.SET_VARCHAR
select
    CONCAT(
        'bigfcbd/'
        ,s1.`uwConclueDate`
    )                      as `key`
    ,CastToJsonArrayUDF(
        listagg(concat(
             'com'      ,':'  ,`com`      ,','
            ,'comname'  ,':'  ,`comname`  ,','
            ,'risk'     ,':'  ,`risk`     ,','
            ,'riskname' ,':'  ,`riskname` ,','
            ,'chnl'     ,':'  ,`chnl`     ,','
            ,'chnlname' ,':'  ,`chnlname` ,','
            ,'cost'     ,':'  ,cast(`cost` as varchar)     ,','
            ,'no'       ,':'  ,`no`
        ),';')
    )                      as `val`
from (
    select
        *
    from(
        select
            d1.`uwConclueDate`                      as `uwConclueDate`
            ,d1.`LEVEL1COMCODE`                     as `com`
            ,d1.`LEVEL1COMDESC`                     as `comname`
            ,d1.`risk`                              as `risk`
            ,d1.`riskname`                          as `riskname`
            ,d1.`chnl`                              as `chnl`
            ,d1.`chnlname`                          as `chnlname`
            ,d1.`cost`                              as `cost`
            ,d1.`no`                                as `no`
            ,ROW_NUMBER() OVER(PARTITION BY d1.`uwConclueDate` ORDER BY d1.`cost` DESC) as rownum
        from VIEW_ZB_DM_FCXCBDD d1
       where LEFT(d1.`risk`,2) <> '05'
    ) c1
    where c1.rownum <= 20
) s1
group by
    s1.`uwConclueDate`
;



-- 分公司
insert into ZB_DM.ZB_DM_REDIS.SET_VARCHAR
select
    CONCAT(
        'bigfccitybd/'
        ,s1.`uwConclueDate`
        ,'/',s1.`group_com`
    )                      as `key`
    ,CastToJsonArrayUDF(
        listagg(concat(
             'com'      ,':'  ,`com`      ,','
            ,'comname'  ,':'  ,`comname`  ,','
            ,'city'     ,':'  ,`city`     ,','
            ,'cityname' ,':'  ,`cityname` ,','
            ,'risk'     ,':'  ,`risk`     ,','
            ,'riskname' ,':'  ,`riskname` ,','
            ,'chnl'     ,':'  ,`chnl`     ,','
            ,'chnlname' ,':'  ,`chnlname` ,','
            ,'cost'     ,':'  ,cast(`cost` as varchar)     ,','
            ,'no'       ,':'  ,`no`
        ),';')
    )                      as `val`
from (
    select
        *
    from (
        select
             d1.`uwConclueDate`                     as `uwConclueDate`
            ,d1.`LEVEL1COMCODE`                     as `group_com`
            ,d1.`LEVEL1COMCODE`                     as `com`
            ,d1.`LEVEL1COMDESC`                     as `comname`
            ,d1.`LEVEL2COMCODE`                     as `city`
            ,d1.`LEVEL2COMDESC`                     as `cityname`
            ,d1.`risk`                              as `risk`
            ,d1.`riskname`                          as `riskname`
            ,d1.`chnl`                              as `chnl`
            ,d1.`chnlname`                          as `chnlname`
            ,d1.`cost`                              as `cost`
            ,d1.`no`                                as `no`
            ,ROW_NUMBER() OVER(PARTITION BY d1.`LEVEL1COMCODE`,d1.`uwConclueDate` ORDER BY d1.`cost` DESC) as rownum
        from VIEW_ZB_DM_FCXCBDD d1
       where LEFT(d1.`risk`,2) <> '05'
    ) c1
    where c1.rownum <= 20
) s1
group by
    s1.`uwConclueDate`
    ,s1.`group_com`
;


-- 中支
insert into ZB_DM.ZB_DM_REDIS.SET_VARCHAR
select
    CONCAT(
            'bigfccountrybd/'
        ,s1.`uwConclueDate`
        ,'/',s1.`group_com`
        )                      as `key`
    ,CastToJsonArrayUDF(
        listagg(concat(
             'com'         ,':'  ,`com`         ,','
            ,'comname'     ,':'  ,`comname`     ,','
            ,'city'        ,':'  ,`city`        ,','
            ,'cityname'    ,':'  ,`cityname`    ,','
            ,'country'     ,':'  ,`country`     ,','
            ,'countryname' ,':'  ,`countryname` ,','
            ,'risk'        ,':'  ,`risk`        ,','
            ,'riskname'    ,':'  ,`riskname`    ,','
            ,'chnl'        ,':'  ,`chnl`        ,','
            ,'chnlname'    ,':'  ,`chnlname`    ,','
            ,'cost'        ,':'  ,cast(`cost` as varchar)        ,','
            ,'no'          ,':'  ,`no`
        ),';')
     )                         as `val`
from (
    select
        *
    from (
        select
             d1.`uwConclueDate`                     as `uwConclueDate`
            ,d1.`LEVEL2COMCODE`                     as `group_com`
            ,d1.`LEVEL1COMCODE`                     as `com`
            ,d1.`LEVEL1COMDESC`                     as `comname`
            ,d1.`LEVEL2COMCODE`                     as `city`
            ,d1.`LEVEL2COMDESC`                     as `cityname`
            ,d1.`LEVEL3COMCODE`                     as `country`
            ,d1.`LEVEL3COMDESC`                     as `countryname`
            ,d1.`risk`                              as `risk`
            ,d1.`riskname`                          as `riskname`
            ,d1.`chnl`                              as `chnl`
            ,d1.`chnlname`                          as `chnlname`
            ,d1.`cost`                              as `cost`
            ,d1.`no`                                as `no`
            ,ROW_NUMBER() OVER(PARTITION BY d1.`LEVEL2COMCODE`,d1.`uwConclueDate` ORDER BY d1.`cost` DESC) as rownum
        from VIEW_ZB_DM_FCXCBDD d1
       where LEFT(d1.`risk`,2) <> '05'
    ) c1
    where c1.rownum <= 20
    ) s1
group by
    s1.`uwConclueDate`
    ,s1.`group_com`
;