-- ZB_ODS_CBDATA ZB_ODS_指标加工承保业务数据
-- 保费计算
--
-- 1、非车险共保我方保费系数 = 承保保费 * plcSolution[1].plcCoins.plcCoinsBasicInformation[1].coinsRate(系数)
--                    coinsRate 有值 ，系数 = coinsRate
--                    coinsRate 无值 ，系数 = 1
--        备注：只有在非车险共保我方保费时存在系数得字段
-- 2、汇率换算 = 承保保费 * sigAndStaExchangeRate （汇率）
--        备注：批单不用计算，sta开头得字段是被转过汇率得
-- 3、条件： 车险 或 （非车险 并且 plcSolution[1].plcCoins.plcCoinsBasicInformation[1].coinsIdentity(共保我方) =1）


insert into ZB_ODS.ZB_ODS_KAFKA.CBDATA
select
     s1.uwConclueDate                as `uwConclueDate`          --  标记时间
    ,s1.startTime                    as `startTime`              --  起保时间
    ,s1.businessOffice               as `COMCODE`                --
    ,t1.COMNAME                      as `COMNAME`                --
    ,t1.LEVEL1COMCODE                as `LEVEL1COMCODE`          --
    ,t1.LEVEL2COMCODE                as `LEVEL2COMCODE`          --
    ,t1.LEVEL3COMCODE                as `LEVEL3COMCODE`          --
    ,t1.LEVEL4COMCODE                as `LEVEL4COMCODE`          --
    ,t1.LEVEL5COMCODE                as `LEVEL5COMCODE`          --
    ,t1.LEVEL1COMDESC                as `LEVEL1COMDESC`          --
    ,t1.LEVEL2COMDESC                as `LEVEL2COMDESC`          --
    ,t1.LEVEL3COMDESC                as `LEVEL3COMDESC`          --
    ,t1.LEVEL4COMDESC                as `LEVEL4COMDESC`          --
    ,t1.LEVEL5COMDESC                as `LEVEL5COMDESC`          --
    ,s1.productCode                  as `risk`                   -- 险种代码
    ,t3.RISKNAME                     as `riskname`               --
    ,t3.CLASSCODE                    as `classcode`              -- 险类代码
    ,t3.CLASSNAME                    as `classname`              --
    ,s1.businessChannelCode          as `chnl`                   -- 业务渠道
    ,t2.NEWCHNLTYPEDESC              as `chnlname`               --
    ,s1.businessNatureCode           as `businessNatureCode`     -- 业务来源
    ,t4.CODEDESC                     as `businessNatureName`     --
    ,cast(s1.`cost` as varchar)      as `cost`                   -- 不含税保费
    ,s1.`no`                         as `no`                     -- 保单号
    ,s1.`xxzflag`                    as `xxzflag`                -- 新续转标记 1是0否
    ,s1.`id`                         as `id`                     -- 14 归属业务员ID
	,s1.`name`                       as `name`                   -- 15 归属业务员名称
	,s1.`flag`                       as `flag`                     -- 保单批单标记
	,DATE_FORMAT(LOCALTIMESTAMP,'yyyy-MM-dd HH:mm:ss')                    as log_time
from (
     select
          LongTimeToStringUDF(signDate,'yyyyMMdd')              as uwConclueDate        -- 标记时间 UnderWriteEndDate
         ,LongTimeToStringUDF(startTime,'yyyyMMdd')             as `startTime`          -- 起保时间
         ,businessOffice                                        as businessOffice       -- 保单归属机构代码
         ,productCode                                           as productCode          -- 险种代码
         ,businessChannelCode                                   as businessChannelCode  -- 业务渠道
         ,businessNatureCode                                    as businessNatureCode   -- 业务来源
         ,cast(cast(netPremium as decimal(30,4))
                * cast(sigAndStaExchangeRate as decimal(30,4))
                *(
                    case
                        when coinsCode = '0' then (
                            case
                                when coinsLinkCode = '0' then 1  -- 非共保非联保
                                else cast(JsonGetCoinsRateUDF(plcSolution[1].plcCoins.plcLinkBasicInformat,'coinsLinkCode',coinsLinkCode) as decimal(30,4)) /100    -- 纯联保
                            end
                        )
                        else (
                            case
                                when coinsLinkCode = '0' then cast(JsonGetCoinsRateUDF(plcSolution[1].plcCoins.plcCoinsBasicInformation,'coinsCode',coinsCode) as decimal(30,4)) /100 -- 纯共保
                                else (
                                        cast(JsonGetCoinsRateUDF(plcSolution[1].plcCoins.plcCoinsBasicInformation,'coinsCode' ,coinsCode) as decimal(30,4)) /100
                                     )* (
                                        cast(JsonGetCoinsRateUDF(plcSolution[1].plcCoins.plcLinkBasicInformat,'coinsLinkCode' ,coinsLinkCode) as decimal(30,4)) /100
                                     )  -- 即联又共
                            end
                        )
                    end
                )  as decimal (30,4))                                             as `cost`           -- 不含税保费
         ,COALESCE(policyNo,businessNo)                                           as `no`             -- 保单号
         ,case
              when LEFT(productCode,2)  = '05' and (newPolicyFlag = '1' or autoTransrenewFlag = '1' or autoTransrenewFlag = '4' or transferPolicyFlag = '1' or transrenewFlag = '1' or transrenewFlag ='4') then '1'
              when LEFT(productCode,2) <> '05' and (newPolicyFlag = '0' or autoTransrenewFlag = '1' or autoTransrenewFlag = '4' or transferPolicyFlag = '2' or transrenewFlag = '1' ) then '1'
              else '0' end                                      as `xxzflag`              -- 新续转标记 1是0否
         ,mainSalesmanCode                                      as `id`                 -- 14 归属业务员ID
         ,mainSalesmanName                                      as `name`               -- 15 归属业务员名称
         ,'bd'                                                  as `flag`			        -- 保单或批单标记
         ,proctime                                              as proctime
    from ZB_ODS.ZB_ODS_KAFKA.POLICY  -- 保单业务数据
    where LongTimeToStringUDF(signDate,'yyyyMMdd') = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
    and cast(netPremium as decimal(18,2)) <> 0


    union all
    select
          LongTimeToStringUDF(endorsePolicyTime,'yyyyMMdd')     as uwConclueDate        -- 标记时间  endorsePolicyTime
         ,LongTimeToStringUDF(endorseTime,'yyyyMMdd')           as `startTime`          -- 起保时间
         ,businessOffice                                        as businessOffice       -- 保单归属机构代码
         ,productCode                                           as productCode          -- 险种代码
         ,businessChannelCode                                   as businessChannelCode  -- 业务渠道
         ,businessNatureCode                                    as businessNatureCode   -- 业务来源
         ,cast(cast(plpEndorse.netPremiumVariation as decimal(30,4))
                * cast(sigAndStaExchangeRate as decimal(30,4))
                *(
                    case
                        when coinsCode = '0' then (
                            case
                                when coinsLinkCode = '0' then 1  -- 非共保非联保
                                else cast(JsonGetCoinsRateUDF(plcSolution[1].plcCoins.plcLinkBasicInformat,'coinsLinkCode',coinsLinkCode) as decimal(30,4)) /100    -- 纯联保
                            end
                        )
                        else (
                            case
                                when coinsLinkCode = '0' then cast(JsonGetCoinsRateUDF(plcSolution[1].plcCoins.plcCoinsBasicInformation,'coinsCode',coinsCode) as decimal(30,4)) /100 -- 纯共保
                                else (
                                        cast(JsonGetCoinsRateUDF(plcSolution[1].plcCoins.plcCoinsBasicInformation,'coinsCode' ,coinsCode) as decimal(30,4)) /100
                                     )* (
                                        cast(JsonGetCoinsRateUDF(plcSolution[1].plcCoins.plcLinkBasicInformat,'coinsLinkCode' ,coinsLinkCode) as decimal(30,4)) /100
                                     )  -- 即联又共
                            end
                        )
                    end
                )   as decimal (30,4))                                            as `cost`               -- 不含税保费
         ,COALESCE(endorseNo,businessNo)                                          as `no`                 -- 批单号
         ,case
              when LEFT(productCode,2)  = '05' and (newPolicyFlag = '1' or autoTransrenewFlag = '1' or autoTransrenewFlag = '4' or transferPolicyFlag = '1' or transrenewFlag = '1' or transrenewFlag ='4') then '1'
              when LEFT(productCode,2) <> '05' and (newPolicyFlag = '0' or autoTransrenewFlag = '1' or autoTransrenewFlag = '4' or transferPolicyFlag = '2' or transrenewFlag = '1' ) then '1'
              else '0' end                                      as `xxzflag`              -- 新续转标记 1是0否
         ,mainSalesmanCode                                      as `id`                  -- 14 归属业务员ID
         ,mainSalesmanName                                      as `name`                -- 15 归属业务员名称
         ,'pd'                                                  as `flag`			         -- 保单或批单标记
         ,proctime                                              as proctime

    from ZB_ODS.ZB_ODS_KAFKA.ENDOR  -- 批单业务数据
    where LongTimeToStringUDF(endorsePolicyTime,'yyyyMMdd') = DATE_FORMAT(LOCALTIMESTAMP,'yyyyMMdd')
    and cast(plpEndorse.netPremiumVariation as decimal(30,4)) <> 0

) s1
left join ZB_ODS.ZB_ODS_MYSQL.CD_COM_ALL for system_time as of s1.proctime as t1 on s1.businessOffice = t1.COMCODE
left join ZB_ODS.ZB_ODS_MYSQL.CD_NEWCHNLTYPE for system_time as of s1.proctime as t2 on s1.businessChannelCode = t2.NEWCHNLTYPE
left join ZB_ODS.ZB_ODS_MYSQL.CD_REALTIME_RISK for system_time as of s1.proctime as t3 on s1.productCode = t3.RISKCODE
left join ZB_ODS.ZB_ODS_MYSQL.CD_BUSINESSNATURE for system_time as of s1.proctime as t4 on s1.businessNatureCode = t4.CODE

;




